/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen;

import io.vertx.codegen.Case;
import io.vertx.codegen.ClassKind;
import io.vertx.codegen.GenException;
import io.vertx.codegen.Helper;
import io.vertx.codegen.MethodInfo;
import io.vertx.codegen.MethodKind;
import io.vertx.codegen.Model;
import io.vertx.codegen.ModuleInfo;
import io.vertx.codegen.ParamInfo;
import io.vertx.codegen.TypeInfo;
import io.vertx.codegen.TypeParamInfo;
import io.vertx.codegen.annotations.CacheReturn;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.codegen.doc.Doc;
import io.vertx.codegen.doc.Tag;
import io.vertx.codegen.doc.Text;
import io.vertx.codegen.doc.Token;
import io.vertx.codegen.overloadcheck.MethodOverloadChecker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.processing.Messager;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

public class ClassModel
implements Model {
    private static final Logger logger = Logger.getLogger(ClassModel.class.getName());
    public static final String VERTX_READ_STREAM = "io.vertx.core.streams.ReadStream";
    public static final String VERTX_WRITE_STREAM = "io.vertx.core.streams.WriteStream";
    public static final String VERTX_ASYNC_RESULT = "io.vertx.core.AsyncResult";
    public static final String VERTX_HANDLER = "io.vertx.core.Handler";
    public static final String JSON_OBJECT = "io.vertx.core.json.JsonObject";
    public static final String JSON_ARRAY = "io.vertx.core.json.JsonArray";
    public static final String VERTX = "io.vertx.core.Vertx";
    protected final MethodOverloadChecker methodOverloadChecker;
    protected final Messager messager;
    protected final TypeInfo.Factory typeFactory;
    protected final Doc.Factory docFactory;
    protected final Map<String, TypeElement> sources;
    protected final TypeElement modelElt;
    protected final Elements elementUtils;
    protected final Types typeUtils;
    protected boolean processed = false;
    protected LinkedHashMap<ExecutableElement, MethodInfo> methods = new LinkedHashMap();
    protected Set<TypeInfo.Class> collectedTypes = new HashSet<TypeInfo.Class>();
    protected Set<TypeInfo.Class> importedTypes = new HashSet<TypeInfo.Class>();
    protected Set<TypeInfo.Class.Api> referencedTypes = new HashSet<TypeInfo.Class.Api>();
    protected Set<TypeInfo.Class> referencedDataObjectTypes = new HashSet<TypeInfo.Class>();
    protected boolean concrete;
    protected TypeInfo type;
    protected String ifaceSimpleName;
    protected String ifaceFQCN;
    protected String ifacePackageName;
    protected String ifaceComment;
    protected Doc doc;
    protected List<TypeInfo> superTypes = new ArrayList<TypeInfo>();
    protected List<TypeInfo> concreteSuperTypes = new ArrayList<TypeInfo>();
    protected List<TypeInfo> abstractSuperTypes = new ArrayList<TypeInfo>();
    protected TypeInfo handlerSuperType;
    protected Map<String, List<MethodInfo>> methodMap = new LinkedHashMap<String, List<MethodInfo>>();

    public ClassModel(MethodOverloadChecker methodOverloadChecker, Messager messager, Map<String, TypeElement> sources, Elements elementUtils, Types typeUtils, TypeElement modelElt) {
        this.methodOverloadChecker = methodOverloadChecker;
        this.typeFactory = new TypeInfo.Factory(elementUtils, typeUtils);
        this.docFactory = new Doc.Factory(messager, elementUtils, typeUtils, this.typeFactory, modelElt);
        this.messager = messager;
        this.sources = sources;
        this.elementUtils = elementUtils;
        this.typeUtils = typeUtils;
        this.modelElt = modelElt;
    }

    @Override
    public String getKind() {
        return "class";
    }

    @Override
    public String getFqn() {
        return this.type.getRaw().getName();
    }

    @Override
    public TypeElement getElement() {
        return this.modelElt;
    }

    public List<MethodInfo> getMethods() {
        return new ArrayList<MethodInfo>(this.methods.values());
    }

    public List<MethodInfo> getStaticMethods() {
        return this.methods.values().stream().filter(MethodInfo::isStaticMethod).collect(Collectors.toList());
    }

    public List<MethodInfo> getInstanceMethods() {
        return this.methods.values().stream().filter(m -> !m.isStaticMethod()).collect(Collectors.toList());
    }

    public boolean isConcrete() {
        return this.concrete;
    }

    public Set<TypeInfo.Class> getImportedTypes() {
        return this.importedTypes;
    }

    public Set<TypeInfo.Class.Api> getReferencedTypes() {
        return this.referencedTypes;
    }

    public Set<TypeInfo.Class> getReferencedDataObjectTypes() {
        return this.referencedDataObjectTypes;
    }

    public String getIfaceSimpleName() {
        return this.ifaceSimpleName;
    }

    public String getIfaceFQCN() {
        return this.ifaceFQCN;
    }

    public String getIfacePackageName() {
        return this.ifacePackageName;
    }

    public String getIfaceComment() {
        return this.ifaceComment;
    }

    public Doc getDoc() {
        return this.doc;
    }

    public TypeInfo getType() {
        return this.type;
    }

    @Override
    public ModuleInfo getModule() {
        return this.type.getRaw().getModule();
    }

    public List<TypeInfo> getSuperTypes() {
        return this.superTypes;
    }

    public List<TypeInfo> getConcreteSuperTypes() {
        return this.concreteSuperTypes;
    }

    public List<TypeInfo> getAbstractSuperTypes() {
        return this.abstractSuperTypes;
    }

    public TypeInfo getHandlerSuperType() {
        return this.handlerSuperType;
    }

    public Map<String, List<MethodInfo>> getMethodMap() {
        return this.methodMap;
    }

    public List<TypeParamInfo.Class> getTypeParams() {
        return this.type.getRaw().getParams();
    }

    private void sortMethodMap(Map<String, List<MethodInfo>> map) {
        for (List<MethodInfo> list : map.values()) {
            list.sort((meth1, meth2) -> meth1.params.size() - meth2.params.size());
        }
    }

    protected void checkParamType(Element elem, TypeMirror type, TypeInfo typeInfo, int pos, int numParams) {
        if (typeInfo.getKind().basic || typeInfo.getKind().json || typeInfo.getKind() == ClassKind.OBJECT || typeInfo.getKind() == ClassKind.THROWABLE) {
            return;
        }
        if (this.isLegalEnum(type)) {
            return;
        }
        if (this.isLegalHandlerType(typeInfo)) {
            return;
        }
        if (this.isLegalHandlerAsyncResultType(typeInfo)) {
            return;
        }
        if (this.isLegalListSetMapParam(typeInfo)) {
            return;
        }
        if (this.isVertxGenInterface(typeInfo)) {
            return;
        }
        if (this.isDataObjectType(typeInfo)) {
            return;
        }
        if (this.isVariableType(typeInfo)) {
            return;
        }
        throw new GenException(elem, "type " + typeInfo + " is not legal for use for a parameter in code generation");
    }

    protected void checkReturnType(ExecutableElement elem, TypeInfo type, TypeMirror typeMirror) {
        if (type.getKind().basic || type instanceof TypeInfo.Void || type.getKind().json) {
            return;
        }
        if (this.isLegalEnum(typeMirror)) {
            return;
        }
        if (type.getKind() == ClassKind.THROWABLE) {
            return;
        }
        if (this.isLegalListSetMapReturn(type)) {
            return;
        }
        if (this.isVertxGenInterface(type)) {
            return;
        }
        if (this.isDataObjectTypeWithToJson(type)) {
            return;
        }
        if (this.isVariableType(type)) {
            return;
        }
        throw new GenException(elem, "type " + type + " is not legal for use for a return type in code generation");
    }

    private boolean isLegalEnum(TypeMirror type) {
        if (type.getKind() != TypeKind.DECLARED) {
            return false;
        }
        Element typeElt = ((DeclaredType)type).asElement();
        if (typeElt.getKind() != ElementKind.ENUM) {
            return false;
        }
        Element enclosing = typeElt.getEnclosingElement();
        return enclosing.getKind() == ElementKind.PACKAGE;
    }

    private boolean isVariableType(TypeInfo type) {
        return type instanceof TypeInfo.Variable;
    }

    private boolean isDataObjectType(TypeInfo type) {
        return type.getKind() == ClassKind.DATA_OBJECT;
    }

    protected boolean isDataObjectTypeWithToJson(TypeInfo type) {
        TypeElement typeElt;
        if (type.getKind() == ClassKind.DATA_OBJECT && (typeElt = this.elementUtils.getTypeElement(type.getName())) != null) {
            Optional<ExecutableElement> opt = this.elementUtils.getAllMembers(typeElt).stream().flatMap(Helper.FILTER_METHOD).filter(m -> m.getSimpleName().toString().equals("toJson") && m.getParameters().isEmpty() && m.getReturnType().toString().equals(JSON_OBJECT)).findFirst();
            return opt.isPresent();
        }
        return false;
    }

    private boolean isLegalListOrSetForHandler(TypeInfo type) {
        TypeInfo.Class raw;
        if (type instanceof TypeInfo.Parameterized && ((raw = type.getRaw()).getName().equals(List.class.getName()) || raw.getName().equals(Set.class.getName()))) {
            TypeInfo elementType = ((TypeInfo.Parameterized)type).getArgs().get(0);
            if (elementType.getKind().basic || elementType.getKind().json || this.isVertxGenInterface(elementType) || this.isDataObjectTypeWithToJson(elementType)) {
                return true;
            }
        }
        return false;
    }

    protected boolean isLegalListSetMapParam(TypeInfo type) {
        if (ClassModel.rawTypeIs(type, List.class, Set.class, Map.class)) {
            TypeInfo argument = ((TypeInfo.Parameterized)type).getArgs().get(0);
            if (type.getKind() != ClassKind.MAP) {
                if (argument.getKind().basic || argument.getKind().json || this.isVertxGenInterface(argument) || this.isDataObjectType(argument)) {
                    return true;
                }
            } else if (argument.getKind() == ClassKind.STRING) {
                argument = ((TypeInfo.Parameterized)type).getArgs().get(1);
                if (argument.getKind().basic || argument.getKind().json || this.isVertxGenInterface(argument)) {
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean isLegalListSetMapReturn(TypeInfo type) {
        if (ClassModel.rawTypeIs(type, List.class, Set.class, Map.class)) {
            TypeInfo argument = ((TypeInfo.Parameterized)type).getArgs().get(0);
            if (type.getKind() != ClassKind.MAP) {
                if (argument.getKind().basic || argument.getKind().json || this.isVertxGenInterface(argument) || this.isDataObjectTypeWithToJson(argument)) {
                    return true;
                }
            } else if (argument.getKind() == ClassKind.STRING) {
                argument = ((TypeInfo.Parameterized)type).getArgs().get(1);
                if (argument.getKind().basic || argument.getKind().json) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isVertxGenInterface(TypeInfo type) {
        if (type.getKind() == ClassKind.API) {
            if (type instanceof TypeInfo.Parameterized) {
                TypeInfo.Parameterized parameterized = (TypeInfo.Parameterized)type;
                for (TypeInfo param : parameterized.getArgs()) {
                    if (param instanceof TypeInfo.Variable || param.getKind() == ClassKind.VOID) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private boolean isLegalHandlerType(TypeInfo type) {
        if (type.getErased().getKind() == ClassKind.HANDLER) {
            TypeInfo eventType = ((TypeInfo.Parameterized)type).getArgs().get(0);
            if (eventType.getKind().json || eventType.getKind().basic || this.isVertxGenInterface(eventType) || this.isLegalListOrSetForHandler(eventType) || eventType.getKind() == ClassKind.VOID || eventType.getKind() == ClassKind.THROWABLE || this.isVariableType(eventType) || this.isDataObjectTypeWithToJson(eventType)) {
                return true;
            }
        }
        return false;
    }

    private boolean isLegalHandlerAsyncResultType(TypeInfo type) {
        TypeInfo eventType;
        if (type.getErased().getKind() == ClassKind.HANDLER && (eventType = ((TypeInfo.Parameterized)type).getArgs().get(0)).getErased().getKind() == ClassKind.ASYNC_RESULT) {
            TypeInfo resultType = ((TypeInfo.Parameterized)eventType).getArgs().get(0);
            if (resultType.getKind().json || resultType.getKind().basic || this.isVertxGenInterface(resultType) || this.isLegalListOrSetForHandler(resultType) || resultType.getKind() == ClassKind.VOID || this.isVariableType(resultType) || this.isDataObjectTypeWithToJson(resultType)) {
                return true;
            }
        }
        return false;
    }

    private void determineApiTypes() {
        this.collectedTypes.stream().map(TypeInfo.Class::getRaw).flatMap(Helper.instanceOf(TypeInfo.Class.class)).filter(t -> !t.getPackageName().equals(this.ifaceFQCN)).forEach(this.importedTypes::add);
        this.collectedTypes.stream().map(TypeInfo.Class::getRaw).flatMap(Helper.instanceOf(TypeInfo.Class.Api.class)).filter(t -> !t.equals(this.type.getRaw())).forEach(this.referencedTypes::add);
        this.collectedTypes.stream().map(TypeInfo.Class::getRaw).flatMap(Helper.instanceOf(TypeInfo.Class.class)).filter(t -> t.getKind() == ClassKind.DATA_OBJECT).forEach(this.referencedDataObjectTypes::add);
    }

    boolean process() {
        if (!this.processed) {
            this.traverseElem(this.modelElt);
            this.determineApiTypes();
            this.processed = true;
            return true;
        }
        return false;
    }

    private void traverseElem(Element elem) {
        switch (elem.getKind()) {
            case ENUM: 
            case CLASS: {
                throw new GenException(elem, "@VertxGen can only be used with interfaces or enums in " + elem.asType().toString());
            }
            case INTERFACE: {
                if (this.ifaceFQCN != null) {
                    throw new GenException(elem, "Can only have one interface per file");
                }
                this.type = this.typeFactory.create(elem.asType());
                Helper.checkUnderModule(this, "@VertxGen");
                this.ifaceFQCN = elem.asType().toString();
                this.ifaceSimpleName = elem.getSimpleName().toString();
                this.ifacePackageName = this.elementUtils.getPackageOf(elem).toString();
                this.ifaceComment = this.elementUtils.getDocComment(elem);
                this.doc = this.docFactory.createDoc(elem);
                this.concrete = elem.getAnnotation(VertxGen.class) == null || elem.getAnnotation(VertxGen.class).concrete();
                DeclaredType tm = (DeclaredType)elem.asType();
                List<? extends TypeMirror> list = tm.getTypeArguments();
                for (TypeMirror typeMirror : list) {
                    TypeVariable typeVariable = (TypeVariable)typeMirror;
                    if (this.isObjectBound(typeVariable.getUpperBound())) continue;
                    throw new GenException(elem, "Type variable bounds not supported " + typeVariable.getUpperBound());
                }
                List<? extends TypeMirror> st = this.typeUtils.directSupertypes(tm);
                for (TypeMirror typeMirror : st) {
                    TypeInfo superTypeInfo;
                    if (typeMirror.toString().equals(Object.class.getName())) continue;
                    try {
                        superTypeInfo = this.typeFactory.create(typeMirror);
                    }
                    catch (IllegalArgumentException e) {
                        throw new GenException(elem, e.getMessage());
                    }
                    switch (superTypeInfo.getKind()) {
                        case API: {
                            try {
                                TypeInfo.Class.Api superType = (TypeInfo.Class.Api)this.typeFactory.create(typeMirror).getRaw();
                                (superType.isConcrete() ? this.concreteSuperTypes : this.abstractSuperTypes).add(superTypeInfo);
                                this.superTypes.add(superTypeInfo);
                                break;
                            }
                            catch (Exception e) {
                                throw new GenException(elem, e.getMessage());
                            }
                        }
                        case HANDLER: {
                            this.handlerSuperType = superTypeInfo;
                        }
                    }
                    superTypeInfo.collectImports(this.collectedTypes);
                }
                if (this.concrete && this.concreteSuperTypes.size() > 1) {
                    throw new GenException(elem, "A concrete interface cannot extend more than one concrete interfaces");
                }
                if (this.concrete || this.concreteSuperTypes.size() <= 0) break;
                throw new GenException(elem, "A abstract interface cannot extend a concrete interface");
            }
        }
        for (Element element : elem.getEnclosedElements()) {
            if (element.getKind() == ElementKind.METHOD) continue;
            this.traverseElem(element);
        }
        if (elem.getKind() == ElementKind.INTERFACE) {
            boolean bl;
            TypeMirror objectType = this.elementUtils.getTypeElement("java.lang.Object").asType();
            this.elementUtils.getAllMembers((TypeElement)elem).stream().filter(elt -> !this.typeUtils.isSameType(elt.getEnclosingElement().asType(), objectType)).flatMap(Helper.FILTER_METHOD).forEach(this::addMethod);
            boolean bl2 = bl = this.methods.values().stream().filter(m -> !m.isDefaultMethod()).count() == 0L;
            if (bl && this.superTypes.isEmpty()) {
                throw new GenException(elem, "Interface " + this.ifaceFQCN + " does not contain any methods for generation");
            }
            this.sortMethodMap(this.methodMap);
            for (List<MethodInfo> list : this.methodMap.values()) {
                try {
                    this.methodOverloadChecker.checkAmbiguous(list);
                }
                catch (RuntimeException runtimeException) {
                    throw new GenException(elem, runtimeException.getMessage());
                }
                MethodInfo methodInfo = list.get(0);
                for (MethodInfo method : list) {
                    if (method.staticMethod == methodInfo.staticMethod) continue;
                    throw new GenException(elem, "Overloaded method " + method.getName() + " cannot be both static and instance");
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addMethod(ExecutableElement methodElt) {
        void var14_23;
        TypeInfo lastParamType;
        boolean isFluent;
        boolean isIgnore;
        boolean bl = isIgnore = methodElt.getAnnotation(GenIgnore.class) != null;
        if (isIgnore) {
            return;
        }
        Set<Modifier> mods = methodElt.getModifiers();
        if (!mods.contains((Object)Modifier.PUBLIC)) {
            return;
        }
        TypeElement declaringElt = (TypeElement)methodElt.getEnclosingElement();
        if (!declaringElt.equals(this.modelElt)) {
            TypeInfo declaringType = this.typeFactory.create(declaringElt.asType());
            switch (declaringType.getKind()) {
                case API: {
                    TypeInfo.Class.Api declaringApiType = (TypeInfo.Class.Api)declaringType.getRaw();
                    if (!declaringApiType.isConcrete()) break;
                    return;
                }
                case HANDLER: {
                    break;
                }
                default: {
                    return;
                }
            }
        }
        TypeInfo.Class type = this.typeFactory.create(declaringElt.asType()).getRaw();
        HashSet<TypeInfo.Class> ownerTypes = new HashSet<TypeInfo.Class>();
        ownerTypes.add(type);
        for (DeclaredType declaredType : Helper.resolveAncestorTypes(this.modelElt, true, true)) {
            TypeElement ancestorElt = (TypeElement)declaredType.asElement();
            if (ancestorElt.getAnnotation(VertxGen.class) == null) continue;
            this.elementUtils.getAllMembers(ancestorElt).stream().flatMap(Helper.FILTER_METHOD).forEach(meth -> {
                if (this.elementUtils.overrides(methodElt, (ExecutableElement)meth, this.modelElt)) {
                    ownerTypes.add(this.typeFactory.create((DeclaredType)ancestorElt.asType()).getRaw());
                }
            });
        }
        for (Map.Entry entry : this.methods.entrySet()) {
            ExecutableType t2;
            ExecutableType t1;
            if (!((MethodInfo)entry.getValue()).getName().equals(methodElt.getSimpleName().toString()) || !this.typeUtils.isSubsignature(t1 = (ExecutableType)((ExecutableElement)entry.getKey()).asType(), t2 = (ExecutableType)methodElt.asType()) || !this.typeUtils.isSubsignature(t2, t1)) continue;
            ((MethodInfo)entry.getValue()).ownerTypes.addAll(ownerTypes);
            return;
        }
        boolean isDefault = mods.contains((Object)Modifier.DEFAULT);
        boolean bl2 = mods.contains((Object)Modifier.STATIC);
        if (bl2 && !this.concrete) {
            throw new GenException(methodElt, "Abstract interface cannot declare static methods");
        }
        boolean isCacheReturn = methodElt.getAnnotation(CacheReturn.class) != null;
        ArrayList<TypeParamInfo.Method> typeParams = new ArrayList<TypeParamInfo.Method>();
        for (TypeParameterElement typeParameterElement : methodElt.getTypeParameters()) {
            for (TypeMirror typeMirror : typeParameterElement.getBounds()) {
                if (this.isObjectBound(typeMirror)) continue;
                throw new GenException(methodElt, "Type parameter bound not supported " + typeMirror);
            }
            typeParams.add((TypeParamInfo.Method)TypeParamInfo.create(typeParameterElement));
        }
        HashMap<String, String> paramDescs = new HashMap<String, String>();
        String string = this.elementUtils.getDocComment(methodElt);
        Doc doc = this.docFactory.createDoc(methodElt);
        Object var14_21 = null;
        if (doc != null) {
            doc.getBlockTags().stream().filter(tag -> tag.getName().equals("param")).map(Tag.Param::new).forEach(tag -> paramDescs.put(tag.getParamName(), tag.getParamDescription()));
            Optional<Tag> returnTag = doc.getBlockTags().stream().filter(tag -> tag.getName().equals("return")).findFirst();
            if (returnTag.isPresent()) {
                Text text = new Text(Helper.normalizeWhitespaces(returnTag.get().getValue())).map(Token.tagMapper(this.elementUtils, this.typeUtils, this.modelElt));
            }
        }
        ExecutableType methodType = (ExecutableType)this.typeUtils.asMemberOf((DeclaredType)this.modelElt.asType(), methodElt);
        List<ParamInfo> mParams = this.getParams(methodElt, methodType, paramDescs);
        AnnotationMirror fluentAnnotation = Helper.resolveMethodAnnotation(Fluent.class, this.elementUtils, this.typeUtils, declaringElt, methodElt);
        boolean bl3 = isFluent = fluentAnnotation != null;
        if (isFluent) {
            isFluent = true;
            if (!this.typeUtils.isSameType(declaringElt.asType(), this.modelElt.asType())) {
                String msg = "Interface " + this.modelElt + " does not redeclare the @Fluent return type " + " of method " + methodElt + " declared by " + declaringElt;
                this.messager.printMessage(Diagnostic.Kind.WARNING, msg, this.modelElt, fluentAnnotation);
                logger.warning(msg);
            } else {
                TypeMirror fluentType = methodElt.getReturnType();
                if (!this.typeUtils.isAssignable(fluentType, this.modelElt.asType())) {
                    throw new GenException(methodElt, "Methods marked with @Fluent must have a return type that extends the type");
                }
            }
        }
        TypeInfo returnType = this.typeFactory.create(methodType.getReturnType());
        returnType.collectImports(this.collectedTypes);
        if (isCacheReturn && returnType instanceof TypeInfo.Void) {
            throw new GenException(methodElt, "void method can't be marked with @CacheReturn");
        }
        String methodName = methodElt.getSimpleName().toString();
        if (!isFluent) {
            this.checkReturnType(methodElt, returnType, methodType.getReturnType());
        }
        MethodKind kind = MethodKind.OTHER;
        int lastParamIndex = mParams.size() - 1;
        if (lastParamIndex >= 0 && (returnType instanceof TypeInfo.Void || isFluent) && (lastParamType = mParams.get((int)lastParamIndex).type).getKind() == ClassKind.HANDLER) {
            TypeInfo typeArg = ((TypeInfo.Parameterized)lastParamType).getArgs().get(0);
            kind = typeArg.getKind() == ClassKind.ASYNC_RESULT ? MethodKind.FUTURE : MethodKind.HANDLER;
        }
        MethodInfo methodInfo = this.createMethodInfo(ownerTypes, methodName, string, doc, kind, returnType, (Text)var14_23, isFluent, isCacheReturn, mParams, methodElt, bl2, isDefault, typeParams, declaringElt);
        this.checkMethod(methodInfo);
        List<MethodInfo> methodsByName = this.methodMap.get(methodInfo.getName());
        if (methodsByName == null) {
            methodsByName = new ArrayList<MethodInfo>();
            this.methodMap.put(methodInfo.getName(), methodsByName);
        }
        methodsByName.add(methodInfo);
        this.methods.put(methodElt, methodInfo);
        methodInfo.collectImports(this.collectedTypes);
    }

    protected MethodInfo createMethodInfo(Set<TypeInfo.Class> ownerTypes, String methodName, String comment, Doc doc, MethodKind kind, TypeInfo returnType, Text returnDescription, boolean isFluent, boolean isCacheReturn, List<ParamInfo> mParams, ExecutableElement methodElt, boolean isStatic, boolean isDefault, ArrayList<TypeParamInfo.Method> typeParams, TypeElement declaringElt) {
        return new MethodInfo(ownerTypes, methodName, kind, returnType, returnDescription, isFluent, isCacheReturn, mParams, comment, doc, isStatic, isDefault, typeParams);
    }

    protected void checkMethod(MethodInfo methodInfo) {
        List<MethodInfo> methodsByName = this.methodMap.get(methodInfo.getName());
        if (methodsByName != null) {
            for (MethodInfo meth : methodsByName) {
                if (meth.returnType.equals(methodInfo.returnType)) continue;
                throw new GenException(this.modelElt, "Overloaded method " + methodInfo.name + " must have the same return type " + meth.returnType + " != " + methodInfo.returnType);
            }
        }
    }

    private boolean isObjectBound(TypeMirror bound) {
        return bound.getKind() == TypeKind.DECLARED && bound.toString().equals(Object.class.getName());
    }

    private List<ParamInfo> getParams(ExecutableElement execElem, ExecutableType execType, Map<String, String> descs) {
        List<? extends VariableElement> params = execElem.getParameters();
        ArrayList<ParamInfo> mParams = new ArrayList<ParamInfo>();
        for (int i = 0; i < params.size(); ++i) {
            TypeInfo typeInfo;
            VariableElement param = params.get(i);
            TypeMirror type = execType.getParameterTypes().get(i);
            try {
                typeInfo = this.typeFactory.create(type);
            }
            catch (Exception e) {
                throw new GenException(param, e.getMessage());
            }
            this.checkParamType(execElem, type, typeInfo, i, params.size());
            String name = param.getSimpleName().toString();
            String desc = descs.get(name);
            Text text = desc != null ? new Text(desc).map(Token.tagMapper(this.elementUtils, this.typeUtils, this.modelElt)) : null;
            ParamInfo mParam = new ParamInfo(name, text, typeInfo);
            mParams.add(mParam);
        }
        return mParams;
    }

    @Override
    public Map<String, Object> getVars() {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("importedTypes", this.getImportedTypes());
        vars.put("concrete", this.isConcrete());
        vars.put("type", this.getType());
        vars.put("ifacePackageName", this.getIfacePackageName());
        vars.put("ifaceSimpleName", this.getIfaceSimpleName());
        vars.put("ifaceFQCN", this.getIfaceFQCN());
        vars.put("ifaceComment", this.getIfaceComment());
        vars.put("doc", this.doc);
        vars.put("helper", new Helper());
        vars.put("methods", this.getMethods());
        vars.put("referencedTypes", this.getReferencedTypes());
        vars.put("superTypes", this.getSuperTypes());
        vars.put("concreteSuperTypes", this.getConcreteSuperTypes());
        vars.put("abstractSuperTypes", this.getAbstractSuperTypes());
        vars.put("handlerSuperType", this.getHandlerSuperType());
        vars.put("methodsByName", this.getMethodMap());
        vars.put("referencedDataObjectTypes", this.getReferencedDataObjectTypes());
        vars.put("typeParams", this.getTypeParams());
        vars.put("instanceMethods", this.getInstanceMethods());
        vars.put("staticMethods", this.getStaticMethods());
        vars.putAll(ClassKind.vars());
        vars.putAll(MethodKind.vars());
        vars.putAll(Case.vars());
        return vars;
    }

    private static boolean rawTypeIs(TypeInfo type, Class<?> ... classes) {
        if (type instanceof TypeInfo.Parameterized) {
            String rawClassName = type.getRaw().getName();
            for (Class<?> c : classes) {
                if (!rawClassName.equals(c.getName())) continue;
                return true;
            }
        }
        return false;
    }
}

