/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen.doc;

import io.vertx.codegen.doc.Tag;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Token {
    private static final Pattern TOKEN_SPLITTER = Pattern.compile("(\\{@\\p{Alpha}[^\\}]*\\})|(\\r?\\n)");
    private static final Pattern INLINE_TAG_PATTERN = Pattern.compile("\\{@([^\\p{javaWhitespace}]+)((?:.|\\n)*)\\}");
    final String value;

    public static List<Token> tokenize(String s) {
        ArrayList<Token> events = new ArrayList<Token>();
        Token.parse(s, 0, TOKEN_SPLITTER.matcher(s), events);
        return events;
    }

    private static void parse(String s, int prev, Matcher matcher, ArrayList<Token> events) {
        if (matcher.find()) {
            if (matcher.start() > prev) {
                events.add(new Text(s.substring(prev, matcher.start())));
            }
            String value = s.substring(matcher.start(), matcher.end());
            if (matcher.group(1) != null) {
                Matcher tagMatcher = INLINE_TAG_PATTERN.matcher(value);
                if (!tagMatcher.matches()) {
                    throw new AssertionError((Object)("bug -->" + value + "<--"));
                }
                events.add(new InlineTag(value, new Tag(tagMatcher.group(1), tagMatcher.group(2))));
            } else {
                events.add(new LineBreak(value));
            }
            Token.parse(s, matcher.end(), matcher, events);
        } else if (prev < s.length()) {
            events.add(new Text(s.substring(prev, s.length())));
        }
    }

    public Token(String value) {
        this.value = value;
    }

    public boolean isText() {
        return false;
    }

    public boolean isInlineTag() {
        return false;
    }

    public boolean isLineBreak() {
        return false;
    }

    public String getValue() {
        return this.value;
    }

    public static class InlineTag
    extends Token {
        private final Tag tag;

        public InlineTag(String value, Tag tag) {
            super(value);
            this.tag = tag;
        }

        @Override
        public boolean isInlineTag() {
            return true;
        }

        public Tag getTag() {
            return this.tag;
        }
    }

    public static class LineBreak
    extends Token {
        public LineBreak(String value) {
            super(value);
        }

        @Override
        public boolean isLineBreak() {
            return true;
        }
    }

    public static class Text
    extends Token {
        public Text(String value) {
            super(value);
        }

        @Override
        public boolean isText() {
            return true;
        }
    }
}

