/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen;

import io.vertx.codegen.ClassKind;
import io.vertx.codegen.Helper;
import io.vertx.codegen.ModuleInfo;
import io.vertx.codegen.TypeParamInfo;
import io.vertx.codegen.annotations.GenModule;
import io.vertx.codegen.annotations.ProxyGen;
import io.vertx.codegen.annotations.VertxGen;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public abstract class TypeInfo {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TypeInfo create(Type type) {
        if (type == java.lang.Void.TYPE) {
            return Void.INSTANCE;
        }
        if (type instanceof java.lang.Class) {
            ClassKind kind;
            String fqcn = type.getTypeName();
            java.lang.Class classType = (java.lang.Class)type;
            if (classType.isPrimitive()) {
                return new Primitive(classType.getName());
            }
            Package pkg = classType.getPackage();
            ModuleInfo module = null;
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(classType.getClassLoader());
            try {
                while (pkg != null) {
                    GenModule annotation = pkg.getAnnotation(GenModule.class);
                    if (annotation != null) {
                        module = new ModuleInfo(pkg.getName(), annotation.name());
                        break;
                    }
                    int pos = pkg.getName().lastIndexOf(46);
                    if (pos == -1) {
                        break;
                    }
                    pkg = Package.getPackage(pkg.getName().substring(0, pos));
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(loader);
            }
            if ((kind = Helper.getKind(classType::getAnnotation, fqcn)) == ClassKind.API) {
                return new Class.Api(fqcn, true, null, null, module, false);
            }
            return new Class(kind, fqcn, module, false);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            List<TypeInfo> args = Arrays.asList(parameterizedType.getActualTypeArguments()).stream().map(TypeInfo::create).collect(Collectors.toList());
            java.lang.Class raw = (java.lang.Class)parameterizedType.getRawType();
            return new Parameterized((Class)TypeInfo.create(raw), args);
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVar = (TypeVariable)type;
            TypeParamInfo param = TypeParamInfo.create(typeVar);
            return new Variable(param, ((TypeVariable)type).getName());
        }
        throw new IllegalArgumentException("Unsupported type " + type);
    }

    public abstract boolean equals(Object var1);

    public int hashCode() {
        return this.toString().hashCode();
    }

    public void collectImports(Collection<Class> imports) {
    }

    public TypeInfo getErased() {
        return this;
    }

    public Class getRaw() {
        return null;
    }

    public ClassKind getKind() {
        return ClassKind.OTHER;
    }

    public String getName() {
        return this.format(true);
    }

    public TypeInfo renamePackage(String oldPackageName, String newPackageName) {
        return this;
    }

    public String getSimpleName() {
        return this.format(false);
    }

    public String toString() {
        return this.getName();
    }

    abstract String format(boolean var1);

    public static class Void
    extends TypeInfo {
        public static TypeInfo INSTANCE = new Void(){};

        private Void() {
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof Void;
        }

        @Override
        public String format(boolean qualified) {
            return "void";
        }
    }

    public static class Class
    extends TypeInfo {
        final ClassKind kind;
        final String fqcn;
        final String simpleName;
        final String packageName;
        final ModuleInfo module;
        final boolean proxyGen;

        public Class(ClassKind kind, String fqcn, ModuleInfo module, boolean proxyGen) {
            this.kind = kind;
            this.fqcn = fqcn;
            this.simpleName = Helper.getSimpleName(fqcn);
            this.packageName = Helper.getPackageName(fqcn);
            this.module = module;
            this.proxyGen = proxyGen;
        }

        public String getModuleName() {
            return this.module != null ? this.module.getName() : null;
        }

        public ModuleInfo getModule() {
            return this.module;
        }

        @Override
        public ClassKind getKind() {
            return this.kind;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public boolean isProxyGen() {
            return this.proxyGen;
        }

        @Override
        public Class getRaw() {
            return this;
        }

        @Override
        public void collectImports(Collection<Class> imports) {
            imports.add(this);
        }

        @Override
        public Class renamePackage(String oldPackageName, String newPackageName) {
            return this.packageName.startsWith(oldPackageName) ? new Class(this.kind, newPackageName + this.fqcn.substring(oldPackageName.length()), null, this.proxyGen) : this;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof Class) {
                return this.fqcn.equals(((Class)obj).fqcn);
            }
            return false;
        }

        @Override
        public String format(boolean qualified) {
            return qualified ? this.fqcn : this.simpleName;
        }

        public static class Api
        extends Class {
            final boolean concrete;
            final TypeInfo readStreamArg;
            final TypeInfo writeStreamArg;

            public Api(String fqcn, boolean concrete, TypeInfo readStreamArg, TypeInfo writeStreamArg, ModuleInfo module, boolean proxyGen) {
                super(ClassKind.API, fqcn, module, proxyGen);
                this.concrete = concrete;
                this.readStreamArg = readStreamArg;
                this.writeStreamArg = writeStreamArg;
            }

            @Override
            public Class renamePackage(String oldPackageName, String newPackageName) {
                return this.packageName.startsWith(oldPackageName) ? new Api(newPackageName + this.fqcn.substring(oldPackageName.length()), this.concrete, this.readStreamArg, this.writeStreamArg, this.module, this.proxyGen) : this;
            }

            public boolean isConcrete() {
                return this.concrete;
            }

            public boolean isAbstract() {
                return !this.concrete;
            }

            public TypeInfo getReadStreamArg() {
                return this.readStreamArg;
            }

            public boolean isReadStream() {
                return this.readStreamArg != null;
            }

            public TypeInfo getWriteStreamArg() {
                return this.writeStreamArg;
            }

            public boolean isWriteStream() {
                return this.writeStreamArg != null;
            }
        }
    }

    public static class Parameterized
    extends TypeInfo {
        final Class raw;
        final List<TypeInfo> args;

        public Parameterized(Class raw, List<TypeInfo> args) {
            this.raw = raw;
            this.args = args;
        }

        @Override
        public TypeInfo getErased() {
            return new Parameterized(this.raw, this.args.stream().map(TypeInfo::getErased).collect(Collectors.toList()));
        }

        @Override
        public Class getRaw() {
            return this.raw;
        }

        public List<TypeInfo> getArgs() {
            return this.args;
        }

        @Override
        public ClassKind getKind() {
            return this.raw.getKind();
        }

        @Override
        public void collectImports(Collection<Class> imports) {
            this.raw.collectImports(imports);
            this.args.stream().forEach(a -> a.collectImports(imports));
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof Parameterized) {
                Parameterized that = (Parameterized)obj;
                return this.raw.equals(that.raw) && this.args.equals(that.args);
            }
            return false;
        }

        @Override
        public String format(boolean qualified) {
            StringBuilder buf = new StringBuilder(this.raw.format(qualified)).append('<');
            for (int i = 0; i < this.args.size(); ++i) {
                TypeInfo typeArgument = this.args.get(i);
                if (i > 0) {
                    buf.append(',');
                }
                buf.append(typeArgument.format(qualified));
            }
            buf.append('>');
            return buf.toString();
        }

        @Override
        public TypeInfo renamePackage(String oldPackageName, String newPackageName) {
            return new Parameterized(this.raw.renamePackage(oldPackageName, newPackageName), this.args.stream().map(typeArgument -> typeArgument.renamePackage(oldPackageName, newPackageName)).collect(Collectors.toList()));
        }
    }

    public static class Variable
    extends TypeInfo {
        final String name;
        final TypeParamInfo param;

        public Variable(TypeParamInfo param, String name) {
            this.param = param;
            this.name = name;
        }

        public TypeParamInfo getParam() {
            return this.param;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof Variable) {
                Variable that = (Variable)obj;
                return this.param.equals(that.param);
            }
            return false;
        }

        @Override
        public TypeInfo getErased() {
            return new Class(ClassKind.OBJECT, Object.class.getName(), null, false);
        }

        @Override
        public String toString() {
            return this.name;
        }

        @Override
        public String format(boolean qualified) {
            return this.name;
        }

        @Override
        public ClassKind getKind() {
            return ClassKind.OBJECT;
        }
    }

    public static class Primitive
    extends TypeInfo {
        final String name;

        public Primitive(String name) {
            this.name = name;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof Primitive) {
                return this.name.equals(((Primitive)obj).name);
            }
            return false;
        }

        @Override
        public ClassKind getKind() {
            return ClassKind.PRIMITIVE;
        }

        @Override
        public String format(boolean qualified) {
            return this.name;
        }
    }

    public static class Wildcard
    extends TypeInfo {
        @Override
        public boolean equals(Object obj) {
            return obj instanceof Wildcard;
        }

        @Override
        public String format(boolean qualified) {
            return "?";
        }

        @Override
        public ClassKind getKind() {
            return ClassKind.OBJECT;
        }
    }

    public static class Factory {
        final Elements elementUtils;
        final Types typeUtils;

        public Factory(Elements elementUtils, Types typeUtils) {
            this.elementUtils = elementUtils;
            this.typeUtils = typeUtils;
        }

        public TypeInfo create(TypeMirror type) {
            switch (type.getKind()) {
                case VOID: {
                    return Void.INSTANCE;
                }
                case ERROR: 
                case DECLARED: {
                    return this.create((DeclaredType)type);
                }
                case DOUBLE: 
                case LONG: 
                case FLOAT: 
                case CHAR: 
                case BYTE: 
                case SHORT: 
                case BOOLEAN: 
                case INT: {
                    return new Primitive(type.toString());
                }
                case TYPEVAR: {
                    return this.create((javax.lang.model.type.TypeVariable)type);
                }
                case WILDCARD: {
                    return this.create((WildcardType)type);
                }
            }
            throw new IllegalArgumentException("Illegal type " + type + " of kind " + (Object)((Object)type.getKind()));
        }

        public Wildcard create(WildcardType type) {
            if (type.getExtendsBound() != null) {
                throw new IllegalArgumentException("Wildcard type cannot have an upper bound");
            }
            if (type.getSuperBound() != null) {
                throw new IllegalArgumentException("Wildcard type cannot have a lower bound");
            }
            return new Wildcard();
        }

        public TypeInfo create(DeclaredType type) {
            Class raw;
            boolean proxyGen;
            ModuleInfo module = null;
            Element elt = type.asElement();
            PackageElement pkgElt = this.elementUtils.getPackageOf(elt);
            while (pkgElt != null) {
                GenModule annotation = pkgElt.getAnnotation(GenModule.class);
                if (annotation != null) {
                    module = new ModuleInfo(pkgElt.getQualifiedName().toString(), annotation.name());
                    break;
                }
                String pkgQN = pkgElt.getQualifiedName().toString();
                int pos = pkgQN.lastIndexOf(46);
                if (pos == -1) break;
                pkgElt = this.elementUtils.getPackageElement(pkgQN.substring(0, pos));
            }
            String fqcn = this.typeUtils.erasure(type).toString();
            ClassKind kind = elt.getKind() == ElementKind.ENUM ? ClassKind.ENUM : Helper.getKind(annotationType -> elt.getAnnotation(annotationType), fqcn);
            boolean bl = proxyGen = elt.getAnnotation(ProxyGen.class) != null;
            if (kind == ClassKind.API) {
                VertxGen genAnn = elt.getAnnotation(VertxGen.class);
                TypeElement readStreamElt = this.elementUtils.getTypeElement("io.vertx.core.streams.ReadStream");
                TypeMirror readStreamType = readStreamElt.asType();
                TypeElement typeElement = this.elementUtils.getTypeElement("io.vertx.core.streams.WriteStream");
                TypeMirror writeStreamType = typeElement.asType();
                TypeMirror readStreamRawType = this.typeUtils.erasure(readStreamType);
                TypeMirror writeStreamRawType = this.typeUtils.erasure(writeStreamType);
                TypeInfo readStreamArg = null;
                if (this.typeUtils.isSubtype(type, readStreamRawType)) {
                    TypeMirror resolved = Helper.resolveTypeParameter(this.typeUtils, type, readStreamElt.getTypeParameters().get(0));
                    readStreamArg = this.create(resolved);
                }
                TypeInfo writeStreamArg = null;
                if (this.typeUtils.isSubtype(type, writeStreamRawType)) {
                    TypeMirror resolved = Helper.resolveTypeParameter(this.typeUtils, type, typeElement.getTypeParameters().get(0));
                    writeStreamArg = this.create(resolved);
                }
                raw = new Class.Api(fqcn, genAnn.concrete(), readStreamArg, writeStreamArg, module, proxyGen);
            } else {
                raw = new Class(kind, fqcn, module, proxyGen);
            }
            List<? extends TypeMirror> typeArgs = type.getTypeArguments();
            if (typeArgs.size() > 0) {
                ArrayList<TypeInfo> typeArguments = new ArrayList<TypeInfo>(typeArgs.size());
                for (TypeMirror typeMirror : typeArgs) {
                    TypeInfo typeArgDesc = this.create(typeMirror);
                    typeArguments.add(typeArgDesc);
                }
                return new Parameterized(raw, typeArguments);
            }
            return raw;
        }

        public Variable create(javax.lang.model.type.TypeVariable type) {
            TypeParameterElement elt = (TypeParameterElement)type.asElement();
            TypeParamInfo param = TypeParamInfo.create(elt);
            return new Variable(param, type.toString());
        }
    }
}

