/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen.processor.type;

import io.vertx.codegen.processor.type.AnnotationValueInfo;
import io.vertx.codegen.processor.type.TypeMirrorFactory;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;

public class AnnotationValueInfoFactory {
    private final Elements elementUtils;
    private final TypeMirrorFactory typeFactory;

    public AnnotationValueInfoFactory(TypeMirrorFactory typeMirrorFactory) {
        this.elementUtils = typeMirrorFactory.elementUtils;
        this.typeFactory = typeMirrorFactory;
    }

    public AnnotationValueInfo processAnnotation(AnnotationMirror annotation) {
        String fqn = ((TypeElement)annotation.getAnnotationType().asElement()).getQualifiedName().toString();
        AnnotationValueInfo owner = new AnnotationValueInfo(fqn);
        Map<? extends ExecutableElement, ? extends AnnotationValue> valueMap = this.elementUtils.getElementValuesWithDefaults(annotation);
        for (ExecutableElement valueElt : valueMap.keySet().stream().filter(e -> e.getKind().equals((Object)ElementKind.METHOD)).collect(Collectors.toSet())) {
            owner.putMember(valueElt.getSimpleName().toString(), this.processAnnotationMemberValue(valueMap.get(valueElt)));
        }
        return owner;
    }

    private Object processAnnotationMemberValue(AnnotationValue value) {
        List realValue = value.getValue();
        if (realValue instanceof VariableElement) {
            realValue = ((VariableElement)((Object)realValue)).getSimpleName().toString();
        } else if (realValue instanceof AnnotationMirror) {
            realValue = this.processAnnotation((AnnotationMirror)((Object)realValue));
        } else if (realValue instanceof TypeMirror) {
            realValue = this.typeFactory.create((TypeMirror)((Object)realValue));
        } else if (realValue instanceof List) {
            if ((realValue = ((List)realValue).stream().map(AnnotationValue::getValue).collect(Collectors.toList())).isEmpty()) {
                realValue = Collections.emptyList();
            } else if (realValue.get(0) instanceof AnnotationMirror) {
                realValue = realValue.stream().map(this::processAnnotation).collect(Collectors.toList());
            } else if (realValue.get(0) instanceof TypeMirror) {
                realValue = realValue.stream().map(this.typeFactory::create).collect(Collectors.toList());
            } else if (realValue.get(0) instanceof VariableElement) {
                realValue = realValue.stream().map(v -> v.getSimpleName().toString()).collect(Collectors.toList());
            }
        }
        return realValue;
    }
}

