/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.sqlclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.HashingStrategy;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.authentication.UsernamePasswordCredentials;
import io.vertx.ext.auth.sqlclient.SqlAuthentication;
import io.vertx.ext.auth.sqlclient.SqlAuthenticationOptions;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.SqlClient;
import io.vertx.sqlclient.Tuple;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public class SqlAuthenticationImpl
implements SqlAuthentication {
    private final SqlClient client;
    private final SqlAuthenticationOptions options;
    private final HashingStrategy strategy = HashingStrategy.load();

    public SqlAuthenticationImpl(SqlClient client, SqlAuthenticationOptions options) {
        this.client = Objects.requireNonNull(client);
        this.options = Objects.requireNonNull(options);
    }

    public void authenticate(JsonObject credentials, Handler<AsyncResult<User>> resultHandler) {
        this.authenticate(credentials).onComplete(resultHandler);
    }

    public Future<User> authenticate(JsonObject authInfo) {
        return this.authenticate((Credentials)new UsernamePasswordCredentials(authInfo));
    }

    public Future<User> authenticate(Credentials credentials) {
        UsernamePasswordCredentials authInfo;
        try {
            authInfo = (UsernamePasswordCredentials)credentials;
            authInfo.checkValid(null);
        }
        catch (RuntimeException e) {
            return Future.failedFuture((Throwable)e);
        }
        return this.client.preparedQuery(this.options.getAuthenticationQuery()).execute(Tuple.of((Object)authInfo.getUsername())).compose(rows -> {
            switch (rows.size()) {
                case 0: {
                    return Future.failedFuture((String)"Invalid username/password");
                }
                case 1: {
                    Row row = (Row)rows.iterator().next();
                    String hashedStoredPwd = row.getString(0);
                    if (this.strategy.verify(hashedStoredPwd, authInfo.getPassword())) {
                        User user = User.fromName((String)authInfo.getUsername());
                        user.principal().put("amr", Collections.singletonList("pwd"));
                        return Future.succeededFuture((Object)user);
                    }
                    return Future.failedFuture((String)"Invalid username/password");
                }
            }
            return Future.failedFuture((String)"Failure in authentication");
        });
    }

    @Override
    public String hash(String id, Map<String, String> params, String salt, String password) {
        return this.strategy.hash(id, params, salt, password);
    }
}

