/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2.impl.flow;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.oauth2.AccessToken;
import io.vertx.ext.auth.oauth2.impl.AccessTokenImpl;
import io.vertx.ext.auth.oauth2.impl.OAuth2API;
import io.vertx.ext.auth.oauth2.impl.OAuth2AuthProviderImpl;
import io.vertx.ext.auth.oauth2.impl.flow.OAuth2Flow;

public class AuthJWTImpl
implements OAuth2Flow {
    private final OAuth2AuthProviderImpl provider;

    public AuthJWTImpl(OAuth2AuthProviderImpl provider) {
        this.provider = provider;
    }

    @Override
    public void getToken(JsonObject params, Handler<AsyncResult<AccessToken>> handler) {
        JsonObject query = new JsonObject().put("grant_type", "urn:ietf:params:oauth:grant-type:jwt-bearer").put("assertion", this.provider.sign(params));
        OAuth2API.post(this.provider, this.provider.getConfig().getTokenPath(), query, (Handler<AsyncResult<JsonObject>>)((Handler)res -> {
            if (res.succeeded()) {
                try {
                    handler.handle((Object)Future.succeededFuture((Object)new AccessTokenImpl(this.provider, (JsonObject)res.result())));
                }
                catch (RuntimeException e) {
                    handler.handle((Object)Future.failedFuture((Throwable)e));
                }
            } else {
                handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            }
        }));
    }

    @Override
    public void introspectToken(String token, String tokenType, Handler<AsyncResult<JsonObject>> handler) {
        handler.handle((Object)Future.failedFuture((Throwable)new UnsupportedOperationException()));
    }
}

