/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.ext.auth.oauth2;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.oauth2.OAuth2ClientOptions;
import io.vertx.ext.auth.oauth2.OAuth2FlowType;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import io.vertx.rxjava.ext.auth.AuthProvider;
import io.vertx.rxjava.ext.auth.oauth2.AccessToken;
import rx.Observable;

public class OAuth2Auth
extends AuthProvider {
    final io.vertx.ext.auth.oauth2.OAuth2Auth delegate;

    public OAuth2Auth(io.vertx.ext.auth.oauth2.OAuth2Auth delegate) {
        super((io.vertx.ext.auth.AuthProvider)delegate);
        this.delegate = delegate;
    }

    public Object getDelegate() {
        return this.delegate;
    }

    public static OAuth2Auth createKeycloak(io.vertx.rxjava.core.Vertx vertx, OAuth2FlowType flow, JsonObject config) {
        OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.OAuth2Auth.createKeycloak((Vertx)vertx.getDelegate(), flow, config));
        return ret;
    }

    public static OAuth2Auth create(io.vertx.rxjava.core.Vertx vertx, OAuth2FlowType flow, OAuth2ClientOptions config) {
        OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.OAuth2Auth.create((Vertx)vertx.getDelegate(), flow, config));
        return ret;
    }

    public static OAuth2Auth create(io.vertx.rxjava.core.Vertx vertx, OAuth2FlowType flow) {
        OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.OAuth2Auth.create((Vertx)vertx.getDelegate(), flow));
        return ret;
    }

    public String authorizeURL(JsonObject params) {
        String ret = this.delegate.authorizeURL(params);
        return ret;
    }

    public void getToken(JsonObject params, final Handler<AsyncResult<AccessToken>> handler) {
        this.delegate.getToken(params, new Handler<AsyncResult<io.vertx.ext.auth.oauth2.AccessToken>>(){

            public void handle(AsyncResult<io.vertx.ext.auth.oauth2.AccessToken> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)((Object)AccessToken.newInstance((io.vertx.ext.auth.oauth2.AccessToken)ar.result()))));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public Observable<AccessToken> getTokenObservable(JsonObject params) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.getToken(params, (Handler<AsyncResult<AccessToken>>)handler.toHandler());
        return handler;
    }

    public OAuth2Auth api(HttpMethod method, String path, JsonObject params, Handler<AsyncResult<JsonObject>> handler) {
        this.delegate.api(method, path, params, handler);
        return this;
    }

    public Observable<JsonObject> apiObservable(HttpMethod method, String path, JsonObject params) {
        ObservableFuture handler = RxHelper.observableFuture();
        this.api(method, path, params, (Handler<AsyncResult<JsonObject>>)handler.toHandler());
        return handler;
    }

    public boolean hasJWTToken() {
        boolean ret = this.delegate.hasJWTToken();
        return ret;
    }

    public static OAuth2Auth newInstance(io.vertx.ext.auth.oauth2.OAuth2Auth arg) {
        return arg != null ? new OAuth2Auth(arg) : null;
    }
}

