/*
 * Decompiled with CFR 0.152.
 */
package io.valkey;

import io.valkey.ClusterCommandArguments;
import io.valkey.ClusterCommandObjects;
import io.valkey.CommandArguments;
import io.valkey.Connection;
import io.valkey.HostAndPort;
import io.valkey.JedisClientConfig;
import io.valkey.MultiNodePipelineBase;
import io.valkey.RedisProtocol;
import io.valkey.providers.ClusterConnectionProvider;
import io.valkey.util.IOUtils;
import java.time.Duration;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class ClusterPipeline
extends MultiNodePipelineBase {
    private final ClusterConnectionProvider provider;
    private AutoCloseable closeable = null;

    public ClusterPipeline(Set<HostAndPort> clusterNodes, JedisClientConfig clientConfig) {
        this(new ClusterConnectionProvider(clusterNodes, clientConfig), ClusterPipeline.createClusterCommandObjects(clientConfig.getRedisProtocol()));
        this.closeable = this.provider;
    }

    public ClusterPipeline(Set<HostAndPort> clusterNodes, JedisClientConfig clientConfig, GenericObjectPoolConfig<Connection> poolConfig) {
        this(new ClusterConnectionProvider(clusterNodes, clientConfig, poolConfig), ClusterPipeline.createClusterCommandObjects(clientConfig.getRedisProtocol()));
        this.closeable = this.provider;
    }

    public ClusterPipeline(Set<HostAndPort> clusterNodes, JedisClientConfig clientConfig, GenericObjectPoolConfig<Connection> poolConfig, Duration topologyRefreshPeriod) {
        this(new ClusterConnectionProvider(clusterNodes, clientConfig, poolConfig, topologyRefreshPeriod), ClusterPipeline.createClusterCommandObjects(clientConfig.getRedisProtocol()));
        this.closeable = this.provider;
    }

    public ClusterPipeline(ClusterConnectionProvider provider) {
        this(provider, new ClusterCommandObjects());
    }

    public ClusterPipeline(ClusterConnectionProvider provider, ClusterCommandObjects commandObjects) {
        super(commandObjects);
        this.provider = provider;
    }

    private static ClusterCommandObjects createClusterCommandObjects(RedisProtocol protocol) {
        ClusterCommandObjects cco = new ClusterCommandObjects();
        if (protocol == RedisProtocol.RESP3) {
            cco.setProtocol(protocol);
        }
        return cco;
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        finally {
            IOUtils.closeQuietly(this.closeable);
        }
    }

    @Override
    protected HostAndPort getNodeKey(CommandArguments args) {
        return this.provider.getNode(((ClusterCommandArguments)args).getCommandHashSlot());
    }

    @Override
    protected Connection getConnection(HostAndPort nodeKey) {
        return this.provider.getConnection(nodeKey);
    }

    public void prepareGraphCommands() {
        super.prepareGraphCommands(this.provider);
    }
}

