/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr.handshake;

import io.undertow.connector.ByteBufferPool;
import io.undertow.websockets.WebSocketExtension;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.protocol.version13.Hybi13Handshake;
import io.undertow.websockets.extensions.ExtensionHandshake;
import io.undertow.websockets.jsr.ConfiguredServerEndpoint;
import io.undertow.websockets.jsr.ExtensionImpl;
import io.undertow.websockets.jsr.handshake.HandshakeUtil;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import jakarta.websocket.Extension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.xnio.StreamConnection;

public final class JsrHybi13Handshake
extends Hybi13Handshake {
    private final ConfiguredServerEndpoint config;

    public JsrHybi13Handshake(ConfiguredServerEndpoint config) {
        super(Collections.emptySet(), false);
        this.config = config;
    }

    @Override
    protected void upgradeChannel(WebSocketHttpExchange exchange, byte[] data) {
        HandshakeUtil.prepareUpgrade(this.config.getEndpointConfiguration(), exchange);
        super.upgradeChannel(exchange, data);
    }

    @Override
    public WebSocketChannel createChannel(WebSocketHttpExchange exchange, StreamConnection c, ByteBufferPool buffers) {
        WebSocketChannel channel = super.createChannel(exchange, c, buffers);
        HandshakeUtil.setConfig(channel, this.config, exchange);
        return channel;
    }

    @Override
    public boolean matches(WebSocketHttpExchange exchange) {
        return super.matches(exchange) && HandshakeUtil.checkOrigin(this.config.getEndpointConfiguration(), exchange);
    }

    @Override
    protected String supportedSubprotols(String[] requestedSubprotocolArray) {
        return HandshakeUtil.selectSubProtocol(this.config, requestedSubprotocolArray);
    }

    @Override
    protected List<WebSocketExtension> selectedExtension(List<WebSocketExtension> extensionList) {
        ArrayList<Extension> ext = new ArrayList<Extension>();
        for (WebSocketExtension i : extensionList) {
            ext.add(ExtensionImpl.create(i));
        }
        List<Extension> selected = HandshakeUtil.selectExtensions(this.config, ext);
        if (selected == null) {
            return Collections.emptyList();
        }
        HashMap<String, ExtensionHandshake> extensionMap = new HashMap<String, ExtensionHandshake>();
        for (ExtensionHandshake availible : this.availableExtensions) {
            extensionMap.put(availible.getName(), availible);
        }
        ArrayList<WebSocketExtension> ret = new ArrayList<WebSocketExtension>();
        ArrayList<ExtensionHandshake> accepted = new ArrayList<ExtensionHandshake>();
        for (Extension i : selected) {
            WebSocketExtension accept;
            ExtensionHandshake handshake = (ExtensionHandshake)extensionMap.get(i.getName());
            if (handshake == null) continue;
            ArrayList<WebSocketExtension.Parameter> parameters = new ArrayList<WebSocketExtension.Parameter>();
            for (Extension.Parameter p : i.getParameters()) {
                parameters.add(new WebSocketExtension.Parameter(p.getName(), p.getValue()));
            }
            if (handshake.isIncompatible(accepted) || (accept = handshake.accept(new WebSocketExtension(i.getName(), parameters))) == null) continue;
            ret.add(accept);
            accepted.add(handshake);
        }
        return ret;
    }
}

