/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.function;

import io.smallrye.common.constraint.Assert;
import io.smallrye.common.function.ExceptionObjLongConsumer;

@FunctionalInterface
public interface ExceptionObjIntConsumer<T, E extends Exception> {
    public void accept(T var1, int var2) throws E;

    default public ExceptionObjIntConsumer<T, E> andThen(ExceptionObjIntConsumer<? super T, ? extends E> after) {
        Assert.checkNotNullParam("after", after);
        return (t, v) -> {
            this.accept(t, v);
            after.accept(t, v);
        };
    }

    default public ExceptionObjIntConsumer<T, E> compose(ExceptionObjIntConsumer<? super T, ? extends E> before) {
        Assert.checkNotNullParam("before", before);
        return (t, v) -> {
            before.accept(t, v);
            this.accept(t, v);
        };
    }

    default public ExceptionObjIntConsumer<T, E> andThen(ExceptionObjLongConsumer<? super T, ? extends E> after) {
        Assert.checkNotNullParam("after", after);
        return (t, v) -> {
            this.accept(t, v);
            after.accept(t, v);
        };
    }

    default public ExceptionObjIntConsumer<T, E> compose(ExceptionObjLongConsumer<? super T, ? extends E> before) {
        Assert.checkNotNullParam("before", before);
        return (t, v) -> {
            before.accept(t, v);
            this.accept(t, v);
        };
    }
}

