/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.server.handlers.form.FormData;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import io.undertow.servlet.spec.ServletContextImpl;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.http.Part;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class PartImpl
implements Part {
    private final String name;
    private final FormData.FormValue formValue;
    private final MultipartConfigElement config;
    private final ServletContextImpl servletContext;
    private final HttpServletRequestImpl servletRequest;

    public PartImpl(String name, FormData.FormValue formValue, MultipartConfigElement config, ServletContextImpl servletContext, HttpServletRequestImpl servletRequest) {
        this.name = name;
        this.formValue = formValue;
        this.config = config;
        this.servletContext = servletContext;
        this.servletRequest = servletRequest;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.formValue.isFileItem()) {
            return this.formValue.getFileItem().getInputStream();
        }
        String charset = this.formValue.getCharset() != null ? this.formValue.getCharset() : (this.servletRequest.getCharacterEncoding() != null ? this.servletRequest.getCharacterEncoding() : this.servletContext.getDeployment().getDefaultRequestCharset().name());
        return new ByteArrayInputStream(this.formValue.getValue().getBytes(charset));
    }

    @Override
    public String getContentType() {
        return this.formValue.getHeaders().getFirst(Headers.CONTENT_TYPE);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSubmittedFileName() {
        return this.formValue.getFileName();
    }

    @Override
    public long getSize() {
        try {
            if (this.formValue.isFileItem()) {
                return this.formValue.getFileItem().getFileSize();
            }
            if (this.formValue.getCharset() != null) {
                return this.formValue.getValue().getBytes(this.formValue.getCharset()).length;
            }
            return this.formValue.getValue().length();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void write(String fileName) throws IOException {
        Path target = Paths.get(fileName, new String[0]);
        if (!target.isAbsolute()) {
            target = this.config.getLocation().isEmpty() ? this.servletContext.getDeployment().getDeploymentInfo().getTempPath().resolve(fileName) : Paths.get(this.config.getLocation(), fileName);
        }
        if (this.formValue.isFileItem()) {
            this.formValue.getFileItem().write(target);
        }
    }

    @Override
    public void delete() throws IOException {
        if (this.formValue.isFileItem()) {
            try {
                this.formValue.getFileItem().delete();
            }
            catch (IOException e) {
                throw UndertowServletMessages.MESSAGES.deleteFailed(this.formValue.getPath());
            }
        }
    }

    @Override
    public String getHeader(String name) {
        return this.formValue.getHeaders().getFirst(new HttpString(name));
    }

    @Override
    public Collection<String> getHeaders(String name) {
        HeaderValues values = this.formValue.getHeaders().get(new HttpString(name));
        return values == null ? Collections.emptyList() : values;
    }

    @Override
    public Collection<String> getHeaderNames() {
        HashSet<String> ret = new HashSet<String>();
        for (HttpString i : this.formValue.getHeaders().getHeaderNames()) {
            ret.add(i.toString());
        }
        return ret;
    }
}

