/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.cache;

import io.undertow.UndertowLogger;
import io.undertow.server.handlers.cache.LimitedBufferSlicePool;
import io.undertow.util.ConcurrentDirectDeque;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.xnio.BufferAllocator;

public class DirectBufferCache {
    private static final int SAMPLE_INTERVAL = 5;
    public static final int MAX_AGE_NO_CACHING = 0;
    public static final int MAX_AGE_NO_EXPIRY = -1;
    private final LimitedBufferSlicePool pool;
    private final ConcurrentMap<Object, CacheEntry> cache;
    private final ConcurrentDirectDeque<CacheEntry> accessQueue;
    private final int sliceSize;
    private final int maxAge;

    public DirectBufferCache(int sliceSize, int slicesPerPage, int maxMemory) {
        this(sliceSize, slicesPerPage, maxMemory, BufferAllocator.DIRECT_BYTE_BUFFER_ALLOCATOR);
    }

    public DirectBufferCache(int sliceSize, int slicesPerPage, int maxMemory, BufferAllocator<ByteBuffer> bufferAllocator) {
        this(sliceSize, slicesPerPage, maxMemory, bufferAllocator, -1);
    }

    public DirectBufferCache(int sliceSize, int slicesPerPage, int maxMemory, BufferAllocator<ByteBuffer> bufferAllocator, int maxAge) {
        this.sliceSize = sliceSize;
        this.pool = new LimitedBufferSlicePool(bufferAllocator, sliceSize, sliceSize * slicesPerPage, maxMemory / (sliceSize * slicesPerPage));
        this.cache = new ConcurrentHashMap<Object, CacheEntry>(16);
        this.accessQueue = ConcurrentDirectDeque.newInstance();
        this.maxAge = maxAge;
    }

    public CacheEntry add(Object key, int size) {
        return this.add(key, size, this.maxAge);
    }

    public CacheEntry add(Object key, int size, int maxAge) {
        CacheEntry value = (CacheEntry)this.cache.get(key);
        if (value == null) {
            value = new CacheEntry(key, size, this, maxAge);
            CacheEntry result = this.cache.putIfAbsent(key, value);
            if (result != null) {
                value = result;
            } else {
                this.bumpAccess(value);
            }
        }
        return value;
    }

    public CacheEntry get(Object key) {
        CacheEntry cacheEntry = (CacheEntry)this.cache.get(key);
        if (cacheEntry == null) {
            return null;
        }
        long expires = cacheEntry.getExpires();
        if (expires == 0L || expires > 0L && System.currentTimeMillis() > expires) {
            this.remove(key);
            return null;
        }
        if (cacheEntry.hit() % 5 == 0) {
            this.bumpAccess(cacheEntry);
            if (!cacheEntry.allocate()) {
                int reclaimSize = cacheEntry.size();
                for (CacheEntry oldest : this.accessQueue) {
                    if (oldest == cacheEntry) continue;
                    if (oldest.buffers().length > 0) {
                        reclaimSize -= oldest.size();
                    }
                    this.remove(oldest.key());
                    if (reclaimSize > 0) continue;
                    break;
                }
                cacheEntry.allocate();
            }
        }
        return cacheEntry;
    }

    public Set<Object> getAllKeys() {
        return new HashSet<Object>(this.cache.keySet());
    }

    private void bumpAccess(CacheEntry cacheEntry) {
        Object prevToken = cacheEntry.claimToken();
        if (!Boolean.FALSE.equals(prevToken)) {
            if (prevToken != null) {
                this.accessQueue.removeToken(prevToken);
            }
            Object token = null;
            try {
                token = this.accessQueue.offerLastAndReturnToken(cacheEntry);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!cacheEntry.setToken(token) && token != null) {
                this.accessQueue.removeToken(token);
            }
        }
    }

    public void remove(Object key) {
        CacheEntry remove = (CacheEntry)this.cache.remove(key);
        if (remove != null) {
            Object old = remove.clearToken();
            if (old != null) {
                this.accessQueue.removeToken(old);
            }
            remove.dereference();
        }
    }

    public static final class CacheEntry {
        private static final LimitedBufferSlicePool.PooledByteBuffer[] EMPTY_BUFFERS = new LimitedBufferSlicePool.PooledByteBuffer[0];
        private static final LimitedBufferSlicePool.PooledByteBuffer[] INIT_BUFFERS = new LimitedBufferSlicePool.PooledByteBuffer[0];
        private static final Object CLAIM_TOKEN = new Object();
        private static final AtomicIntegerFieldUpdater<CacheEntry> hitsUpdater = AtomicIntegerFieldUpdater.newUpdater(CacheEntry.class, "hits");
        private static final AtomicIntegerFieldUpdater<CacheEntry> refsUpdater = AtomicIntegerFieldUpdater.newUpdater(CacheEntry.class, "refs");
        private static final AtomicIntegerFieldUpdater<CacheEntry> enabledUpdator = AtomicIntegerFieldUpdater.newUpdater(CacheEntry.class, "enabled");
        private static final AtomicReferenceFieldUpdater<CacheEntry, LimitedBufferSlicePool.PooledByteBuffer[]> bufsUpdater = AtomicReferenceFieldUpdater.newUpdater(CacheEntry.class, LimitedBufferSlicePool.PooledByteBuffer[].class, "buffers");
        private static final AtomicReferenceFieldUpdater<CacheEntry, Object> tokenUpdator = AtomicReferenceFieldUpdater.newUpdater(CacheEntry.class, Object.class, "accessToken");
        private final Object key;
        private final int size;
        private final DirectBufferCache cache;
        private final int maxAge;
        private volatile LimitedBufferSlicePool.PooledByteBuffer[] buffers = INIT_BUFFERS;
        private volatile int refs = 1;
        private volatile int hits = 1;
        private volatile Object accessToken;
        private volatile int enabled;
        private volatile long expires = -1L;

        private CacheEntry(Object key, int size, DirectBufferCache cache, int maxAge) {
            this.key = key;
            this.size = size;
            this.cache = cache;
            this.maxAge = maxAge;
        }

        public int size() {
            return this.size;
        }

        public LimitedBufferSlicePool.PooledByteBuffer[] buffers() {
            return this.buffers;
        }

        public int hit() {
            int i;
            do {
                i = this.hits;
            } while (!hitsUpdater.weakCompareAndSet(this, i++, i));
            return i;
        }

        public Object key() {
            return this.key;
        }

        public boolean enabled() {
            return this.enabled == 2;
        }

        public void enable() {
            if (this.maxAge == 0) {
                this.expires = 0L;
                this.disable();
            } else if (this.maxAge == -1) {
                this.expires = -1L;
                this.enabled = 2;
            } else if (this.maxAge > 0) {
                this.expires = System.currentTimeMillis() + (long)this.maxAge;
                this.enabled = 2;
            } else {
                this.expires = 0L;
                UndertowLogger.ROOT_LOGGER.wrongCacheTTLValue(this.maxAge, 0);
                this.disable();
            }
        }

        public void disable() {
            this.enabled = 0;
        }

        public boolean claimEnable() {
            return enabledUpdator.compareAndSet(this, 0, 1);
        }

        public boolean reference() {
            int refs;
            do {
                if ((refs = this.refs) >= 1) continue;
                return false;
            } while (!refsUpdater.compareAndSet(this, refs++, refs));
            return true;
        }

        public boolean dereference() {
            int refs;
            do {
                if ((refs = this.refs) >= 1) continue;
                return false;
            } while (!refsUpdater.compareAndSet(this, refs--, refs));
            if (refs == 0) {
                this.destroy();
            }
            return true;
        }

        public boolean allocate() {
            if (this.buffers.length > 0) {
                return true;
            }
            if (!bufsUpdater.compareAndSet(this, INIT_BUFFERS, EMPTY_BUFFERS)) {
                return true;
            }
            int reserveSize = this.size;
            int n = 1;
            DirectBufferCache bufferCache = this.cache;
            while ((reserveSize -= bufferCache.sliceSize) > 0) {
                ++n;
            }
            LimitedBufferSlicePool slicePool = bufferCache.pool;
            if (!slicePool.canAllocate(n)) {
                this.buffers = INIT_BUFFERS;
                return false;
            }
            LimitedBufferSlicePool.PooledByteBuffer[] buffers = new LimitedBufferSlicePool.PooledByteBuffer[n];
            for (int i = 0; i < n; ++i) {
                LimitedBufferSlicePool.PooledByteBuffer allocate = slicePool.allocate();
                if (allocate == null) {
                    while (--i >= 0) {
                        buffers[i].free();
                    }
                    this.buffers = INIT_BUFFERS;
                    return false;
                }
                buffers[i] = allocate;
            }
            this.buffers = buffers;
            return true;
        }

        private void destroy() {
            for (LimitedBufferSlicePool.PooledByteBuffer buffer : this.buffers = EMPTY_BUFFERS) {
                buffer.free();
            }
        }

        Object claimToken() {
            Object current;
            do {
                if ((current = this.accessToken) != CLAIM_TOKEN) continue;
                return Boolean.FALSE;
            } while (!tokenUpdator.compareAndSet(this, current, CLAIM_TOKEN));
            return current;
        }

        boolean setToken(Object token) {
            return tokenUpdator.compareAndSet(this, CLAIM_TOKEN, token);
        }

        Object clearToken() {
            Object old = tokenUpdator.getAndSet(this, null);
            return old == CLAIM_TOKEN ? null : old;
        }

        long getExpires() {
            return this.expires;
        }
    }
}

