/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.sqlserver;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.OptionalBinder;
import com.microsoft.sqlserver.jdbc.SQLServerDriver;
import io.trino.plugin.jdbc.BaseJdbcConfig;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.DriverConnectionFactory;
import io.trino.plugin.jdbc.ForBaseJdbc;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcModule;
import io.trino.plugin.jdbc.MaxDomainCompactionThreshold;
import io.trino.plugin.jdbc.credential.CredentialProvider;
import io.trino.plugin.sqlserver.SqlServerClient;
import io.trino.plugin.sqlserver.SqlServerTableProperties;
import java.sql.Driver;

public class SqlServerClientModule
implements Module {
    public void configure(Binder binder) {
        binder.bind(JdbcClient.class).annotatedWith(ForBaseJdbc.class).to(SqlServerClient.class).in(Scopes.SINGLETON);
        JdbcModule.bindTablePropertiesProvider((Binder)binder, SqlServerTableProperties.class);
        OptionalBinder.newOptionalBinder((Binder)binder, (Key)Key.get(Integer.TYPE, MaxDomainCompactionThreshold.class)).setBinding().toInstance((Object)500);
    }

    @Provides
    @Singleton
    @ForBaseJdbc
    public ConnectionFactory getConnectionFactory(BaseJdbcConfig config, CredentialProvider credentialProvider) {
        return new DriverConnectionFactory((Driver)new SQLServerDriver(), config, credentialProvider);
    }
}

