/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import io.airlift.configuration.Config;
import io.airlift.resolver.ArtifactResolver;
import java.util.List;
import javax.validation.constraints.NotNull;

public class DevelopmentLoaderConfig {
    private static final Splitter SPLITTER = Splitter.on((char)',').omitEmptyStrings().trimResults();
    private List<String> plugins = ImmutableList.of();
    private String mavenLocalRepository = ArtifactResolver.USER_LOCAL_REPO;
    private List<String> mavenRemoteRepository = ImmutableList.of((Object)"https://repo1.maven.org/maven2/");

    public List<String> getPlugins() {
        return this.plugins;
    }

    public DevelopmentLoaderConfig setPlugins(List<String> plugins) {
        this.plugins = ImmutableList.copyOf(plugins);
        return this;
    }

    @Config(value="plugin.bundles")
    public DevelopmentLoaderConfig setPlugins(String plugins) {
        this.plugins = SPLITTER.splitToList((CharSequence)plugins);
        return this;
    }

    @NotNull
    public String getMavenLocalRepository() {
        return this.mavenLocalRepository;
    }

    @Config(value="maven.repo.local")
    public DevelopmentLoaderConfig setMavenLocalRepository(String mavenLocalRepository) {
        this.mavenLocalRepository = mavenLocalRepository;
        return this;
    }

    @NotNull
    public List<String> getMavenRemoteRepository() {
        return this.mavenRemoteRepository;
    }

    public DevelopmentLoaderConfig setMavenRemoteRepository(List<String> mavenRemoteRepository) {
        this.mavenRemoteRepository = mavenRemoteRepository;
        return this;
    }

    @Config(value="maven.repo.remote")
    public DevelopmentLoaderConfig setMavenRemoteRepository(String mavenRemoteRepository) {
        this.mavenRemoteRepository = ImmutableList.copyOf((Iterable)Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)mavenRemoteRepository));
        return this;
    }
}

