/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import io.airlift.resolver.ArtifactResolver;
import io.airlift.resolver.DefaultArtifact;
import io.trino.server.DevelopmentLoaderConfig;
import io.trino.server.ForStartup;
import io.trino.server.PluginClassLoader;
import io.trino.server.PluginDiscovery;
import io.trino.server.PluginManager;
import io.trino.util.Executors;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.inject.Inject;
import org.sonatype.aether.artifact.Artifact;

public class DevelopmentPluginsProvider
implements PluginManager.PluginsProvider {
    private final ArtifactResolver resolver;
    private final List<String> plugins;
    private final Executor executor;

    @Inject
    public DevelopmentPluginsProvider(DevelopmentLoaderConfig config, @ForStartup Executor executor) {
        this.resolver = new ArtifactResolver(config.getMavenLocalRepository(), config.getMavenRemoteRepository());
        this.plugins = ImmutableList.copyOf(config.getPlugins());
        this.executor = Objects.requireNonNull(executor, "executor is null");
    }

    public void loadPlugins(PluginManager.PluginsProvider.Loader loader, PluginManager.PluginsProvider.ClassLoaderFactory createClassLoader) {
        Executors.executeUntilFailure((Executor)this.executor, (Collection)((Collection)this.plugins.stream().map(plugin -> () -> {
            loader.load(plugin, () -> this.buildClassLoader((String)plugin, createClassLoader));
            return null;
        }).collect(ImmutableList.toImmutableList())));
    }

    private PluginClassLoader buildClassLoader(String plugin, PluginManager.PluginsProvider.ClassLoaderFactory classLoaderFactory) {
        try {
            return this.doBuildClassLoader(plugin, classLoaderFactory);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private PluginClassLoader doBuildClassLoader(String plugin, PluginManager.PluginsProvider.ClassLoaderFactory classLoaderFactory) throws IOException {
        File file = new File(plugin);
        if (file.isFile() && (file.getName().equals("pom.xml") || file.getName().endsWith(".pom"))) {
            return this.buildClassLoaderFromPom(file, classLoaderFactory);
        }
        return this.buildClassLoaderFromCoordinates(plugin, classLoaderFactory);
    }

    private PluginClassLoader buildClassLoaderFromPom(File pomFile, PluginManager.PluginsProvider.ClassLoaderFactory classLoaderFactory) throws IOException {
        List artifacts = this.resolver.resolvePom(pomFile);
        PluginClassLoader classLoader = DevelopmentPluginsProvider.createClassLoader(artifacts, classLoaderFactory);
        Artifact artifact = (Artifact)artifacts.get(0);
        Set<String> plugins = PluginDiscovery.discoverPlugins(artifact, (ClassLoader)classLoader);
        if (!plugins.isEmpty()) {
            File root = new File(artifact.getFile().getParentFile().getCanonicalFile(), "plugin-discovery");
            PluginDiscovery.writePluginServices(plugins, root);
            classLoader = classLoader.withUrl(root.toURI().toURL());
        }
        return classLoader;
    }

    private PluginClassLoader buildClassLoaderFromCoordinates(String coordinates, PluginManager.PluginsProvider.ClassLoaderFactory classLoaderFactory) throws IOException {
        DefaultArtifact rootArtifact = new DefaultArtifact(coordinates);
        List artifacts = this.resolver.resolveArtifacts(new Artifact[]{rootArtifact});
        return DevelopmentPluginsProvider.createClassLoader(artifacts, classLoaderFactory);
    }

    private static PluginClassLoader createClassLoader(List<Artifact> artifacts, PluginManager.PluginsProvider.ClassLoaderFactory classLoaderFactory) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (Artifact artifact : DevelopmentPluginsProvider.sortedArtifacts(artifacts)) {
            if (artifact.getFile() == null) {
                throw new RuntimeException("Could not resolve artifact: " + artifact);
            }
            File file = artifact.getFile().getCanonicalFile();
            urls.add(file.toURI().toURL());
        }
        return classLoaderFactory.create(urls);
    }

    private static List<Artifact> sortedArtifacts(List<Artifact> artifacts) {
        ArrayList<Artifact> list = new ArrayList<Artifact>(artifacts);
        list.sort((Comparator<Artifact>)Ordering.natural().nullsLast().onResultOf(Artifact::getFile));
        return list;
    }
}

