/*
 * Decompiled with CFR 0.152.
 */
package io.trino.decoder.protobuf;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.decoder.DecoderErrorCode;
import io.trino.decoder.FieldValueProvider;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.MapBlockBuilder;
import io.trino.spi.block.MapValueBuilder;
import io.trino.spi.block.RowBlockBuilder;
import io.trino.spi.block.RowValueBuilder;
import io.trino.spi.block.SqlMap;
import io.trino.spi.block.SqlRow;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Timestamps;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.spi.type.Varchars;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class ProtobufValueProvider
extends FieldValueProvider {
    @Nullable
    private final Object value;
    private final Type columnType;
    private final String columnName;
    private final Type jsonType;

    public ProtobufValueProvider(@Nullable Object value, Type columnType, String columnName, TypeManager typeManager) {
        this.value = value;
        this.columnType = Objects.requireNonNull(columnType, "columnType is null");
        this.columnName = Objects.requireNonNull(columnName, "columnName is null");
        this.jsonType = typeManager.getType(new TypeSignature("json", new TypeSignatureParameter[0]));
    }

    @Override
    public boolean isNull() {
        return this.value == null;
    }

    @Override
    public double getDouble() {
        Objects.requireNonNull(this.value, "value is null");
        if (this.value instanceof Double || this.value instanceof Float) {
            return ((Number)this.value).doubleValue();
        }
        throw new TrinoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("cannot decode object of '%s' as '%s' for column '%s'", this.value.getClass(), this.columnType, this.columnName));
    }

    @Override
    public boolean getBoolean() {
        Objects.requireNonNull(this.value, "value is null");
        Object object = this.value;
        if (object instanceof Boolean) {
            Boolean booleanValue = (Boolean)object;
            return booleanValue;
        }
        throw new TrinoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("cannot decode object of '%s' as '%s' for column '%s'", this.value.getClass(), this.columnType, this.columnName));
    }

    @Override
    public long getLong() {
        Objects.requireNonNull(this.value, "value is null");
        Object object = this.value;
        if (object instanceof Long) {
            Long longValue = (Long)object;
            return longValue;
        }
        object = this.value;
        if (object instanceof Integer) {
            Integer intValue = (Integer)object;
            return intValue.longValue();
        }
        object = this.value;
        if (object instanceof Float) {
            Float floatValue = (Float)object;
            return Float.floatToIntBits(floatValue.floatValue());
        }
        object = this.value;
        if (object instanceof DynamicMessage) {
            DynamicMessage dynamicMessage = (DynamicMessage)object;
            Preconditions.checkArgument((boolean)(this.columnType instanceof TimestampType), (Object)"type should be an instance of Timestamp");
            return ProtobufValueProvider.parseTimestamp(((TimestampType)this.columnType).getPrecision(), dynamicMessage);
        }
        throw new TrinoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("cannot decode object of '%s' as '%s' for column '%s'", this.value.getClass(), this.columnType, this.columnName));
    }

    @Override
    public Slice getSlice() {
        return this.getSlice(this.value, this.columnType, this.columnName);
    }

    @Override
    public Object getObject() {
        return this.serializeObject(null, this.value, this.columnType, this.columnName);
    }

    private Slice getSlice(Object value, Type type, String columnName) {
        Objects.requireNonNull(value, "value is null");
        if (type instanceof VarcharType && value instanceof CharSequence || value instanceof Descriptors.EnumValueDescriptor) {
            return Varchars.truncateToLength((Slice)Slices.utf8Slice((String)value.toString()), (Type)type);
        }
        if (type instanceof VarbinaryType && value instanceof ByteString) {
            ByteString byteString = (ByteString)value;
            return Slices.wrappedBuffer((byte[])byteString.toByteArray());
        }
        if (type.equals((Object)this.jsonType)) {
            return (Slice)value;
        }
        throw new TrinoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("cannot decode object of '%s' as '%s' for column '%s'", value.getClass(), type, columnName));
    }

    @Nullable
    private Object serializeObject(BlockBuilder builder, Object value, Type type, String columnName) {
        if (type instanceof ArrayType) {
            return this.serializeList(builder, value, type, columnName);
        }
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            return this.serializeMap(builder, value, mapType, columnName);
        }
        if (type instanceof RowType) {
            return this.serializeRow(builder, value, type, columnName);
        }
        if (type.equals((Object)this.jsonType)) {
            return ProtobufValueProvider.serializeJson(builder, value, type);
        }
        this.serializePrimitive(builder, value, type, columnName);
        return null;
    }

    @Nullable
    private Block serializeList(BlockBuilder parentBlockBuilder, @Nullable Object value, Type type, String columnName) {
        if (value == null) {
            Preconditions.checkState((parentBlockBuilder != null ? 1 : 0) != 0, (Object)"parentBlockBuilder is null");
            parentBlockBuilder.appendNull();
            return null;
        }
        List list = (List)value;
        List typeParameters = type.getTypeParameters();
        Type elementType = (Type)typeParameters.get(0);
        BlockBuilder blockBuilder = elementType.createBlockBuilder(null, list.size());
        for (Object element : list) {
            this.serializeObject(blockBuilder, element, elementType, columnName);
        }
        if (parentBlockBuilder != null) {
            type.writeObject(parentBlockBuilder, (Object)blockBuilder.build());
            return null;
        }
        return blockBuilder.build();
    }

    private void serializePrimitive(BlockBuilder blockBuilder, @Nullable Object value, Type type, String columnName) {
        TimestampType timestampType;
        Objects.requireNonNull(blockBuilder, "parent blockBuilder is null");
        if (value == null) {
            blockBuilder.appendNull();
            return;
        }
        if (type instanceof BooleanType) {
            type.writeBoolean(blockBuilder, ((Boolean)value).booleanValue());
            return;
        }
        if ((value instanceof Integer || value instanceof Long) && (type instanceof BigintType || type instanceof IntegerType || type instanceof SmallintType || type instanceof TinyintType)) {
            type.writeLong(blockBuilder, ((Number)value).longValue());
            return;
        }
        if (type instanceof DoubleType && value instanceof Double) {
            Double doubleValue = (Double)value;
            type.writeDouble(blockBuilder, doubleValue.doubleValue());
            return;
        }
        if (type instanceof RealType && value instanceof Float) {
            Float floatValue = (Float)value;
            type.writeLong(blockBuilder, (long)Float.floatToIntBits(floatValue.floatValue()));
            return;
        }
        if (type instanceof VarcharType || type instanceof VarbinaryType) {
            type.writeSlice(blockBuilder, this.getSlice(value, type, columnName));
            return;
        }
        if (type instanceof TimestampType && (timestampType = (TimestampType)type).isShort()) {
            Preconditions.checkArgument((boolean)(value instanceof DynamicMessage), (Object)"value should be an instance of DynamicMessage");
            type.writeLong(blockBuilder, ProtobufValueProvider.parseTimestamp(timestampType.getPrecision(), (DynamicMessage)value));
            return;
        }
        throw new TrinoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("cannot decode object of '%s' as '%s' for column '%s'", value.getClass(), type, columnName));
    }

    @Nullable
    private SqlMap serializeMap(BlockBuilder parentBlockBuilder, @Nullable Object value, MapType type, String columnName) {
        if (value == null) {
            Preconditions.checkState((parentBlockBuilder != null ? 1 : 0) != 0, (Object)"parentBlockBuilder is null");
            parentBlockBuilder.appendNull();
            return null;
        }
        Collection dynamicMessages = (Collection)((Collection)value).stream().map(DynamicMessage.class::cast).collect(ImmutableList.toImmutableList());
        Type keyType = type.getKeyType();
        Type valueType = type.getValueType();
        if (parentBlockBuilder != null) {
            ((MapBlockBuilder)parentBlockBuilder).buildEntry((keyBuilder, valueBuilder) -> this.buildMap(columnName, dynamicMessages, keyType, valueType, keyBuilder, valueBuilder));
            return null;
        }
        return MapValueBuilder.buildMapValue((MapType)type, (int)dynamicMessages.size(), (keyBuilder, valueBuilder) -> this.buildMap(columnName, dynamicMessages, keyType, valueType, keyBuilder, valueBuilder));
    }

    private void buildMap(String columnName, Collection<DynamicMessage> dynamicMessages, Type keyType, Type valueType, BlockBuilder keyBuilder, BlockBuilder valueBuilder) {
        for (DynamicMessage dynamicMessage : dynamicMessages) {
            if (dynamicMessage.getField(dynamicMessage.getDescriptorForType().findFieldByNumber(1)) == null) continue;
            this.serializeObject(keyBuilder, dynamicMessage.getField(ProtobufValueProvider.getFieldDescriptor(dynamicMessage, 1)), keyType, columnName);
            this.serializeObject(valueBuilder, dynamicMessage.getField(ProtobufValueProvider.getFieldDescriptor(dynamicMessage, 2)), valueType, columnName);
        }
    }

    @Nullable
    private SqlRow serializeRow(BlockBuilder blockBuilder, @Nullable Object value, Type type, String columnName) {
        if (value == null) {
            Preconditions.checkState((blockBuilder != null ? 1 : 0) != 0, (Object)"parent block builder is null");
            blockBuilder.appendNull();
            return null;
        }
        RowType rowType = (RowType)type;
        if (blockBuilder == null) {
            return RowValueBuilder.buildRowValue((RowType)rowType, fieldBuilders -> this.buildRow(rowType, columnName, (DynamicMessage)value, fieldBuilders));
        }
        ((RowBlockBuilder)blockBuilder).buildEntry(fieldBuilders -> this.buildRow(rowType, columnName, (DynamicMessage)value, fieldBuilders));
        return null;
    }

    private void buildRow(RowType rowType, String columnName, DynamicMessage record, List<BlockBuilder> fieldBuilders) {
        List fields = rowType.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            RowType.Field field = (RowType.Field)fields.get(i);
            Preconditions.checkState((boolean)field.getName().isPresent(), (Object)"field name not found");
            Descriptors.FieldDescriptor fieldDescriptor = ProtobufValueProvider.getFieldDescriptor(record, (String)field.getName().get());
            Preconditions.checkState((fieldDescriptor != null ? 1 : 0) != 0, (String)"Unknown Field %s", field.getName().get());
            this.serializeObject(fieldBuilders.get(i), record.getField(fieldDescriptor), field.getType(), columnName);
        }
    }

    @Nullable
    private static Block serializeJson(BlockBuilder builder, Object value, Type type) {
        if (builder != null) {
            type.writeObject(builder, value);
            return null;
        }
        return (Block)value;
    }

    private static long parseTimestamp(int precision, DynamicMessage timestamp) {
        long seconds = (Long)timestamp.getField(timestamp.getDescriptorForType().findFieldByName("seconds"));
        int nanos = (Integer)timestamp.getField(timestamp.getDescriptorForType().findFieldByName("nanos"));
        long micros = seconds * 1000000L;
        Preconditions.checkArgument((precision <= 6 ? 1 : 0) != 0, (Object)"precision must be less than max short timestamp precision (6)");
        return Timestamps.round((long)(micros += (long)Timestamps.roundDiv((int)nanos, (long)1000L)), (int)(6 - precision));
    }

    private static Descriptors.FieldDescriptor getFieldDescriptor(DynamicMessage message, String name) {
        return message.getDescriptorForType().findFieldByName(name);
    }

    private static Descriptors.FieldDescriptor getFieldDescriptor(DynamicMessage message, int index) {
        return message.getDescriptorForType().findFieldByNumber(index);
    }
}

