/*
 * Decompiled with CFR 0.152.
 */
package io.trino.decoder.protobuf;

import com.google.inject.Inject;
import io.trino.decoder.RowDecoder;
import io.trino.decoder.RowDecoderFactory;
import io.trino.decoder.RowDecoderSpec;
import io.trino.decoder.protobuf.DescriptorProvider;
import io.trino.decoder.protobuf.DynamicMessageProvider;
import io.trino.decoder.protobuf.ProtobufRowDecoder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.TypeManager;
import java.util.Objects;
import java.util.Optional;

public class ProtobufRowDecoderFactory
implements RowDecoderFactory {
    public static final String DEFAULT_MESSAGE = "schema";
    private final DynamicMessageProvider.Factory dynamicMessageProviderFactory;
    private final TypeManager typeManager;
    private final DescriptorProvider descriptorProvider;

    @Inject
    public ProtobufRowDecoderFactory(DynamicMessageProvider.Factory dynamicMessageProviderFactory, TypeManager typeManager, DescriptorProvider descriptorProvider) {
        this.dynamicMessageProviderFactory = Objects.requireNonNull(dynamicMessageProviderFactory, "dynamicMessageProviderFactory is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.descriptorProvider = Objects.requireNonNull(descriptorProvider, "descriptorProvider is null");
    }

    @Override
    public RowDecoder create(ConnectorSession session, RowDecoderSpec rowDecoderSpec) {
        return new ProtobufRowDecoder(this.dynamicMessageProviderFactory.create(Optional.ofNullable(rowDecoderSpec.decoderParams().get("dataSchema"))), rowDecoderSpec.columns(), this.typeManager, this.descriptorProvider);
    }
}

