/*
 * Decompiled with CFR 0.152.
 */
package io.trino.decoder.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableSet;
import io.trino.decoder.DecoderColumnHandle;
import io.trino.decoder.DecoderErrorCode;
import io.trino.decoder.FieldValueProvider;
import io.trino.decoder.json.AbstractDateTimeJsonValueProvider;
import io.trino.decoder.json.JsonFieldDecoder;
import io.trino.decoder.json.JsonRowDecoderFactory;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import java.util.Objects;
import java.util.Set;

public class MillisecondsSinceEpochJsonFieldDecoder
implements JsonFieldDecoder {
    private static final Set<Type> SUPPORTED_TYPES = ImmutableSet.of((Object)TimeType.TIME_MILLIS, (Object)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, (Object)TimestampType.TIMESTAMP_MILLIS, (Object)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS);
    private final DecoderColumnHandle columnHandle;

    public MillisecondsSinceEpochJsonFieldDecoder(DecoderColumnHandle columnHandle) {
        this.columnHandle = Objects.requireNonNull(columnHandle, "columnHandle is null");
        if (!SUPPORTED_TYPES.contains(columnHandle.getType())) {
            JsonRowDecoderFactory.throwUnsupportedColumnType(columnHandle);
        }
    }

    @Override
    public FieldValueProvider decode(JsonNode value) {
        return new MillisecondsSinceEpochJsonValueProvider(value, this.columnHandle);
    }

    public static class MillisecondsSinceEpochJsonValueProvider
    extends AbstractDateTimeJsonValueProvider {
        public MillisecondsSinceEpochJsonValueProvider(JsonNode value, DecoderColumnHandle columnHandle) {
            super(value, columnHandle);
        }

        @Override
        protected long getMillis() {
            if (this.value.isIntegralNumber() && !this.value.isBigInteger()) {
                return this.value.longValue();
            }
            if (this.value.isValueNode()) {
                try {
                    return Long.parseLong(this.value.asText());
                }
                catch (NumberFormatException e) {
                    throw new TrinoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("could not parse value '%s' as '%s' for column '%s'", this.value.asText(), this.columnHandle.getType(), this.columnHandle.getName()));
                }
            }
            throw new TrinoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("could not parse non-value node as '%s' for column '%s'", this.columnHandle.getType(), this.columnHandle.getName()));
        }

        @Override
        protected TimeZoneKey getTimeZone() {
            return TimeZoneKey.UTC_KEY;
        }
    }
}

