/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.postgresql;

import io.trino.plugin.jdbc.DefaultQueryBuilder;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcJoinCondition;
import io.trino.plugin.jdbc.JdbcTypeHandle;
import io.trino.plugin.jdbc.QueryParameter;
import io.trino.plugin.jdbc.WriteFunction;
import io.trino.plugin.postgresql.PostgreSqlClient;
import io.trino.plugin.postgresql.PostgreSqlSessionProperties;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.Type;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class CollationAwareQueryBuilder
extends DefaultQueryBuilder {
    protected String formatJoinCondition(JdbcClient client, String leftRelationAlias, String rightRelationAlias, JdbcJoinCondition condition) {
        boolean isCollatable = Stream.of(condition.getLeftColumn(), condition.getRightColumn()).anyMatch(PostgreSqlClient::isCollatable);
        if (isCollatable) {
            return String.format("%s.%s COLLATE \"C\" %s %s.%s COLLATE \"C\"", leftRelationAlias, this.buildJoinColumn(client, condition.getLeftColumn()), condition.getOperator().getValue(), rightRelationAlias, this.buildJoinColumn(client, condition.getRightColumn()));
        }
        return super.formatJoinCondition(client, leftRelationAlias, rightRelationAlias, condition);
    }

    protected String toPredicate(JdbcClient client, ConnectorSession session, JdbcColumnHandle column, JdbcTypeHandle jdbcType, Type type, WriteFunction writeFunction, String operator, Object value, Consumer<QueryParameter> accumulator) {
        if (PostgreSqlClient.isCollatable(column) && PostgreSqlSessionProperties.isEnableStringPushdownWithCollate(session)) {
            accumulator.accept(new QueryParameter(jdbcType, type, Optional.of(value)));
            return String.format("%s %s %s COLLATE \"C\"", client.quoted(column.getColumnName()), operator, writeFunction.getBindExpression());
        }
        return super.toPredicate(client, session, column, jdbcType, type, writeFunction, operator, value, accumulator);
    }
}

