/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.postgresql;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.jdbc.RemoteDatabaseEvent;
import java.io.Closeable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.testcontainers.containers.PostgreSQLContainer;

public class TestingPostgreSqlServer
implements Closeable {
    private static final String USER = "test";
    private static final String PASSWORD = "test";
    private static final String DATABASE = "tpch";
    private static final String LOG_PREFIX_REGEXP = "^([-:0-9. ]+UTC \\[[0-9]+\\] )";
    private static final String LOG_RUNNING_STATEMENT_PREFIX = "LOG:  execute <unnamed>: ";
    private static final String LOG_CANCELLATION_EVENT = "ERROR:  canceling statement due to user request";
    private static final String LOG_CANCELLED_STATEMENT_PREFIX = "STATEMENT:  ";
    private final PostgreSQLContainer<?> dockerContainer = (PostgreSQLContainer)new PostgreSQLContainer("postgres:10").withDatabaseName("tpch").withUsername("test").withPassword("test").withCommand(new String[]{"postgres", "-c", "log_destination=stderr", "-c", "log_statement=all"});

    public TestingPostgreSqlServer() {
        this.dockerContainer.start();
        this.execute("CREATE SCHEMA tpch");
    }

    public void execute(String sql) {
        TestingPostgreSqlServer.execute(this.getJdbcUrl(), this.getProperties(), sql);
    }

    private static void execute(String url, Properties properties, String sql) {
        try (Connection connection = DriverManager.getConnection(url, properties);
             Statement statement = connection.createStatement();){
            statement.execute(sql);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected List<RemoteDatabaseEvent> getRemoteDatabaseEvents() {
        List<String> logs = this.getLogs();
        Iterator<String> logsIterator = logs.iterator();
        ImmutableList.Builder events = ImmutableList.builder();
        while (logsIterator.hasNext()) {
            String cancelledStatementLogLine;
            String logLine = logsIterator.next().replaceAll(LOG_PREFIX_REGEXP, "");
            if (logLine.startsWith(LOG_RUNNING_STATEMENT_PREFIX)) {
                events.add((Object)new RemoteDatabaseEvent(logLine.substring(LOG_RUNNING_STATEMENT_PREFIX.length()), RemoteDatabaseEvent.Status.RUNNING));
            }
            if (!logLine.equals(LOG_CANCELLATION_EVENT) || !(cancelledStatementLogLine = logsIterator.next().replaceAll(LOG_PREFIX_REGEXP, "")).startsWith(LOG_CANCELLED_STATEMENT_PREFIX)) continue;
            events.add((Object)new RemoteDatabaseEvent(cancelledStatementLogLine.substring(LOG_CANCELLED_STATEMENT_PREFIX.length()), RemoteDatabaseEvent.Status.CANCELLED));
        }
        return events.build();
    }

    private List<String> getLogs() {
        return (List)Stream.of(this.dockerContainer.getLogs().split("\n")).filter(Predicate.not(String::isBlank)).collect(ImmutableList.toImmutableList());
    }

    public String getUser() {
        return "test";
    }

    public String getPassword() {
        return "test";
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        properties.setProperty("user", "test");
        properties.setProperty("password", "test");
        properties.setProperty("currentSchema", "tpch,public");
        return properties;
    }

    public String getJdbcUrl() {
        return String.format("jdbc:postgresql://%s:%s/%s", this.dockerContainer.getContainerIpAddress(), this.dockerContainer.getMappedPort(PostgreSQLContainer.POSTGRESQL_PORT.intValue()), DATABASE);
    }

    @Override
    public void close() {
        this.dockerContainer.close();
    }
}

