/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.postgresql;

import io.airlift.concurrent.Threads;
import io.airlift.testing.Closeables;
import io.trino.plugin.jdbc.RemoteDatabaseEvent;
import io.trino.plugin.postgresql.TestingPostgreSqlServer;
import io.trino.testing.assertions.Assert;
import java.io.Closeable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.assertj.core.api.Assertions;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestTestingPostgreSqlServer {
    private final ExecutorService threadPool = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"TestTestingPostgreSqlServer-%d"));
    private TestingPostgreSqlServer postgreSqlServer;

    @BeforeClass
    public void setUp() {
        this.postgreSqlServer = new TestingPostgreSqlServer();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws Exception {
        Closeable[] closeableArray = new Closeable[2];
        closeableArray[0] = this.postgreSqlServer;
        closeableArray[1] = this.threadPool::shutdownNow;
        Closeables.closeAll((Closeable[])closeableArray);
    }

    @Test
    public void testCapturingSuccessfulStatement() {
        String sql = "SELECT 1";
        RemoteDatabaseEvent event = new RemoteDatabaseEvent(sql, RemoteDatabaseEvent.Status.RUNNING);
        Assertions.assertThat(this.postgreSqlServer.getRemoteDatabaseEvents()).doesNotContain((Object[])new RemoteDatabaseEvent[]{event});
        this.postgreSqlServer.execute(sql);
        Assert.assertEventually(() -> Assertions.assertThat(this.postgreSqlServer.getRemoteDatabaseEvents()).contains((Object[])new RemoteDatabaseEvent[]{event}));
    }

    @Test(timeOut=60000L)
    public void testCapturingCancelledStatement() throws Exception {
        String sql = "SELECT pg_sleep(60)";
        RemoteDatabaseEvent running = new RemoteDatabaseEvent(sql, RemoteDatabaseEvent.Status.RUNNING);
        RemoteDatabaseEvent cancelled = new RemoteDatabaseEvent(sql, RemoteDatabaseEvent.Status.CANCELLED);
        Assertions.assertThat(this.postgreSqlServer.getRemoteDatabaseEvents()).doesNotContain((Object[])new RemoteDatabaseEvent[]{running, cancelled});
        try (Connection connection = DriverManager.getConnection(this.postgreSqlServer.getJdbcUrl(), this.postgreSqlServer.getProperties());
             Statement statement = connection.createStatement();){
            Future<Boolean> executeFuture = this.threadPool.submit(() -> statement.execute(sql));
            Assert.assertEventually(() -> Assertions.assertThat(this.postgreSqlServer.getRemoteDatabaseEvents()).contains((Object[])new RemoteDatabaseEvent[]{running}));
            statement.cancel();
            Assertions.assertThatThrownBy(executeFuture::get).hasRootCauseInstanceOf(SQLException.class).hasRootCauseMessage("ERROR: canceling statement due to user request");
        }
        Assert.assertEventually(() -> Assertions.assertThat(this.postgreSqlServer.getRemoteDatabaseEvents()).contains((Object[])new RemoteDatabaseEvent[]{cancelled}));
    }
}

