/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.postgresql;

import io.trino.plugin.jdbc.BaseJdbcConfig;
import io.trino.plugin.jdbc.ColumnMapping;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcExpression;
import io.trino.plugin.jdbc.JdbcTypeHandle;
import io.trino.plugin.jdbc.mapping.DefaultIdentifierMapping;
import io.trino.plugin.jdbc.mapping.IdentifierMapping;
import io.trino.plugin.postgresql.PostgreSqlClient;
import io.trino.plugin.postgresql.PostgreSqlConfig;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.expression.Variable;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.testing.TestingConnectorSession;
import io.trino.testing.assertions.Assert;
import io.trino.type.InternalTypeManager;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestPostgreSqlClient {
    private static final JdbcColumnHandle BIGINT_COLUMN = JdbcColumnHandle.builder().setColumnName("c_bigint").setColumnType((Type)BigintType.BIGINT).setJdbcTypeHandle(new JdbcTypeHandle(-5, Optional.of("int8"), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty())).build();
    private static final JdbcColumnHandle DOUBLE_COLUMN = JdbcColumnHandle.builder().setColumnName("c_double").setColumnType((Type)DoubleType.DOUBLE).setJdbcTypeHandle(new JdbcTypeHandle(8, Optional.of("double"), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty())).build();
    private static final JdbcClient JDBC_CLIENT = new PostgreSqlClient(new BaseJdbcConfig(), new PostgreSqlConfig(), session -> {
        throw new UnsupportedOperationException();
    }, InternalTypeManager.TESTING_TYPE_MANAGER, (IdentifierMapping)new DefaultIdentifierMapping());

    @Test
    public void testImplementCount() {
        Variable bigintVariable = new Variable("v_bigint", (Type)BigintType.BIGINT);
        Variable doubleVariable = new Variable("v_double", (Type)BigintType.BIGINT);
        Optional<Variable> filter = Optional.of(new Variable("a_filter", (Type)BooleanType.BOOLEAN));
        TestPostgreSqlClient.testImplementAggregation(new AggregateFunction("count", (Type)BigintType.BIGINT, List.of(), List.of(), false, Optional.empty()), Map.of(), Optional.of("count(*)"));
        TestPostgreSqlClient.testImplementAggregation(new AggregateFunction("count", (Type)BigintType.BIGINT, List.of(bigintVariable), List.of(), false, Optional.empty()), Map.of(bigintVariable.getName(), BIGINT_COLUMN), Optional.of("count(\"c_bigint\")"));
        TestPostgreSqlClient.testImplementAggregation(new AggregateFunction("count", (Type)BigintType.BIGINT, List.of(doubleVariable), List.of(), false, Optional.empty()), Map.of(doubleVariable.getName(), DOUBLE_COLUMN), Optional.of("count(\"c_double\")"));
        TestPostgreSqlClient.testImplementAggregation(new AggregateFunction("count", (Type)BigintType.BIGINT, List.of(bigintVariable), List.of(), true, Optional.empty()), Map.of(bigintVariable.getName(), BIGINT_COLUMN), Optional.of("count(DISTINCT \"c_bigint\")"));
        TestPostgreSqlClient.testImplementAggregation(new AggregateFunction("count", (Type)BigintType.BIGINT, List.of(), List.of(), false, filter), Map.of(), Optional.empty());
        TestPostgreSqlClient.testImplementAggregation(new AggregateFunction("count", (Type)BigintType.BIGINT, List.of(bigintVariable), List.of(), false, filter), Map.of(bigintVariable.getName(), BIGINT_COLUMN), Optional.empty());
    }

    @Test
    public void testImplementSum() {
        Variable bigintVariable = new Variable("v_bigint", (Type)BigintType.BIGINT);
        Variable doubleVariable = new Variable("v_double", (Type)DoubleType.DOUBLE);
        Optional<Variable> filter = Optional.of(new Variable("a_filter", (Type)BooleanType.BOOLEAN));
        TestPostgreSqlClient.testImplementAggregation(new AggregateFunction("sum", (Type)BigintType.BIGINT, List.of(bigintVariable), List.of(), false, Optional.empty()), Map.of(bigintVariable.getName(), BIGINT_COLUMN), Optional.of("sum(\"c_bigint\")"));
        TestPostgreSqlClient.testImplementAggregation(new AggregateFunction("sum", (Type)DoubleType.DOUBLE, List.of(doubleVariable), List.of(), false, Optional.empty()), Map.of(doubleVariable.getName(), DOUBLE_COLUMN), Optional.of("sum(\"c_double\")"));
        TestPostgreSqlClient.testImplementAggregation(new AggregateFunction("sum", (Type)BigintType.BIGINT, List.of(bigintVariable), List.of(), true, Optional.empty()), Map.of(bigintVariable.getName(), BIGINT_COLUMN), Optional.empty());
        TestPostgreSqlClient.testImplementAggregation(new AggregateFunction("sum", (Type)BigintType.BIGINT, List.of(bigintVariable), List.of(), false, filter), Map.of(bigintVariable.getName(), BIGINT_COLUMN), Optional.empty());
    }

    private static void testImplementAggregation(AggregateFunction aggregateFunction, Map<String, ColumnHandle> assignments, Optional<String> expectedExpression) {
        Optional result = JDBC_CLIENT.implementAggregation(TestingConnectorSession.SESSION, aggregateFunction, assignments);
        if (expectedExpression.isEmpty()) {
            Assertions.assertThat((Optional)result).isEmpty();
        } else {
            Assertions.assertThat((Optional)result).isPresent();
            Assert.assertEquals((String)((JdbcExpression)result.get()).getExpression(), (String)expectedExpression.get());
            Optional columnMapping = JDBC_CLIENT.toColumnMapping(TestingConnectorSession.SESSION, null, ((JdbcExpression)result.get()).getJdbcTypeHandle());
            org.testng.Assert.assertTrue((boolean)columnMapping.isPresent(), (String)("No mapping for: " + ((JdbcExpression)result.get()).getJdbcTypeHandle()));
            Assert.assertEquals((Object)((ColumnMapping)columnMapping.get()).getType(), (Object)aggregateFunction.getOutputType());
        }
    }
}

