/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.postgresql;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.BaseEncoding;
import io.airlift.json.JsonCodec;
import io.trino.Session;
import io.trino.plugin.jdbc.DecimalConfig;
import io.trino.plugin.jdbc.UnsupportedTypeHandling;
import io.trino.plugin.postgresql.PostgreSqlConfig;
import io.trino.plugin.postgresql.PostgreSqlQueryRunner;
import io.trino.plugin.postgresql.TestingPostgreSqlServer;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.UuidType;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DataProviders;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import io.trino.testing.datatype.CreateAndInsertDataSetup;
import io.trino.testing.datatype.CreateAndTrinoInsertDataSetup;
import io.trino.testing.datatype.CreateAsSelectDataSetup;
import io.trino.testing.datatype.DataSetup;
import io.trino.testing.datatype.DataType;
import io.trino.testing.datatype.DataTypeTest;
import io.trino.testing.datatype.SqlDataTypeTest;
import io.trino.testing.sql.JdbcSqlExecutor;
import io.trino.testing.sql.SqlExecutor;
import io.trino.testing.sql.TestTable;
import io.trino.testing.sql.TrinoSqlExecutor;
import io.trino.type.JsonType;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestPostgreSqlTypeMapping
extends AbstractTestQueryFramework {
    private static final LocalDate EPOCH_DAY = LocalDate.ofEpochDay(0L);
    private static final JsonCodec<List<Map<String, String>>> HSTORE_CODEC = JsonCodec.listJsonCodec((JsonCodec)JsonCodec.mapJsonCodec(String.class, String.class));
    protected TestingPostgreSqlServer postgreSqlServer;
    private final LocalDateTime beforeEpoch = LocalDateTime.of(1958, 1, 1, 13, 18, 3, 123000000);
    private final LocalDateTime epoch = LocalDateTime.of(1970, 1, 1, 0, 0, 0);
    private final LocalDateTime afterEpoch = LocalDateTime.of(2019, 3, 18, 10, 1, 17, 987000000);
    private final ZoneId jvmZone = ZoneId.systemDefault();
    private final LocalDateTime timeGapInJvmZone1 = LocalDateTime.of(1970, 1, 1, 0, 13, 42);
    private final LocalDateTime timeGapInJvmZone2 = LocalDateTime.of(2018, 4, 1, 2, 13, 55, 123000000);
    private final LocalDateTime timeDoubledInJvmZone = LocalDateTime.of(2018, 10, 28, 1, 33, 17, 456000000);
    private final ZoneId vilnius = ZoneId.of("Europe/Vilnius");
    private final LocalDateTime timeGapInVilnius = LocalDateTime.of(2018, 3, 25, 3, 17, 17);
    private final LocalDateTime timeDoubledInVilnius = LocalDateTime.of(2018, 10, 28, 3, 33, 33, 333000000);
    private final ZoneId kathmandu = ZoneId.of("Asia/Kathmandu");
    private final LocalDateTime timeGapInKathmandu = LocalDateTime.of(1986, 1, 1, 0, 13, 7);
    private final ZoneOffset fixedOffsetEast = ZoneOffset.ofHoursMinutes(2, 17);
    private final ZoneOffset fixedOffsetWest = ZoneOffset.ofHoursMinutes(-7, -31);

    protected QueryRunner createQueryRunner() throws Exception {
        this.postgreSqlServer = (TestingPostgreSqlServer)this.closeAfterClass(new TestingPostgreSqlServer());
        return PostgreSqlQueryRunner.createPostgreSqlQueryRunner(this.postgreSqlServer, (Map<String, String>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of((Object)"jdbc-types-mapped-to-varchar", (Object)"Tsrange, Inet"), ImmutableList.of());
    }

    @BeforeClass
    public void setUp() {
        Preconditions.checkState((boolean)this.jvmZone.getId().equals("America/Bahia_Banderas"), (Object)"This test assumes certain JVM time zone");
        TestPostgreSqlTypeMapping.checkIsGap(this.jvmZone, this.timeGapInJvmZone1);
        TestPostgreSqlTypeMapping.checkIsGap(this.jvmZone, this.timeGapInJvmZone2);
        TestPostgreSqlTypeMapping.checkIsDoubled(this.jvmZone, this.timeDoubledInJvmZone);
        LocalDate dateOfLocalTimeChangeForwardAtMidnightInSomeZone = LocalDate.of(1983, 4, 1);
        TestPostgreSqlTypeMapping.checkIsGap(this.vilnius, dateOfLocalTimeChangeForwardAtMidnightInSomeZone.atStartOfDay());
        LocalDate dateOfLocalTimeChangeBackwardAtMidnightInSomeZone = LocalDate.of(1983, 10, 1);
        TestPostgreSqlTypeMapping.checkIsDoubled(this.vilnius, dateOfLocalTimeChangeBackwardAtMidnightInSomeZone.atStartOfDay().minusMinutes(1L));
        TestPostgreSqlTypeMapping.checkIsGap(this.vilnius, this.timeGapInVilnius);
        TestPostgreSqlTypeMapping.checkIsDoubled(this.vilnius, this.timeDoubledInVilnius);
        TestPostgreSqlTypeMapping.checkIsGap(this.kathmandu, this.timeGapInKathmandu);
        JdbcSqlExecutor executor = new JdbcSqlExecutor(this.postgreSqlServer.getJdbcUrl(), this.postgreSqlServer.getProperties());
        executor.execute("CREATE EXTENSION hstore WITH SCHEMA public");
    }

    @Test
    public void testBasicTypes() {
        SqlDataTypeTest.create().addRoundTrip("boolean", "true", (Type)BooleanType.BOOLEAN).addRoundTrip("boolean", "false", (Type)BooleanType.BOOLEAN).addRoundTrip("bigint", "123456789012", (Type)BigintType.BIGINT).addRoundTrip("integer", "123456789", (Type)IntegerType.INTEGER).addRoundTrip("smallint", "32456", (Type)SmallintType.SMALLINT, "SMALLINT '32456'").addRoundTrip("tinyint", "5", (Type)SmallintType.SMALLINT, "SMALLINT '5'").execute(this.getQueryRunner(), this.trinoCreateAsSelect("test_basic_types"));
    }

    @Test
    public void testReal() {
        SqlDataTypeTest.create().addRoundTrip("real", "NULL", (Type)RealType.REAL, "CAST(NULL AS real)").addRoundTrip("real", "3.14", (Type)RealType.REAL, "REAL '3.14'").addRoundTrip("real", "3.1415927", (Type)RealType.REAL, "REAL '3.1415927'").addRoundTrip("real", "'NaN'::real", (Type)RealType.REAL, "CAST(nan() AS real)").addRoundTrip("real", "'-Infinity'::real", (Type)RealType.REAL, "CAST(-infinity() AS real)").addRoundTrip("real", "'+Infinity'::real", (Type)RealType.REAL, "CAST(+infinity() AS real)").execute(this.getQueryRunner(), this.postgresCreateAndInsert("postgresql_test_real"));
        SqlDataTypeTest.create().addRoundTrip("real", "NULL", (Type)RealType.REAL, "CAST(NULL AS real)").addRoundTrip("real", "3.14", (Type)RealType.REAL, "REAL '3.14'").addRoundTrip("real", "3.1415927", (Type)RealType.REAL, "REAL '3.1415927'").addRoundTrip("real", "nan()", (Type)RealType.REAL, "CAST(nan() AS real)").addRoundTrip("real", "-infinity()", (Type)RealType.REAL, "CAST(-infinity() AS real)").addRoundTrip("real", "+infinity()", (Type)RealType.REAL, "CAST(+infinity() AS real)").execute(this.getQueryRunner(), this.trinoCreateAsSelect("trino_test_real"));
    }

    @Test
    public void testDouble() {
        SqlDataTypeTest.create().addRoundTrip("double precision", "NULL", (Type)DoubleType.DOUBLE, "CAST(NULL AS double)").addRoundTrip("double precision", "1.0E100", (Type)DoubleType.DOUBLE, "1.0E100").addRoundTrip("double precision", "123.456E10", (Type)DoubleType.DOUBLE, "123.456E10").addRoundTrip("double precision", "'NaN'::double precision", (Type)DoubleType.DOUBLE, "nan()").addRoundTrip("double precision", "'+Infinity'::double precision", (Type)DoubleType.DOUBLE, "+infinity()").addRoundTrip("double precision", "'-Infinity'::double precision", (Type)DoubleType.DOUBLE, "-infinity()").execute(this.getQueryRunner(), this.postgresCreateAndInsert("postgresql_test_double"));
        SqlDataTypeTest.create().addRoundTrip("double", "NULL", (Type)DoubleType.DOUBLE, "CAST(NULL AS double)").addRoundTrip("double", "1.0E100", (Type)DoubleType.DOUBLE, "1.0E100").addRoundTrip("double", "123.456E10", (Type)DoubleType.DOUBLE, "123.456E10").addRoundTrip("double", "nan()", (Type)DoubleType.DOUBLE, "nan()").addRoundTrip("double", "+infinity()", (Type)DoubleType.DOUBLE, "+infinity()").addRoundTrip("double", "-infinity()", (Type)DoubleType.DOUBLE, "-infinity()").execute(this.getQueryRunner(), this.trinoCreateAsSelect("trino_test_double"));
    }

    @Test
    public void testDecimal() {
        SqlDataTypeTest.create().addRoundTrip("decimal(3, 0)", "CAST('193' AS decimal(3, 0))", (Type)DecimalType.createDecimalType((int)3, (int)0), "CAST('193' AS decimal(3, 0))").addRoundTrip("decimal(3, 0)", "CAST('19' AS decimal(3, 0))", (Type)DecimalType.createDecimalType((int)3, (int)0), "CAST('19' AS decimal(3, 0))").addRoundTrip("decimal(3, 0)", "CAST('-193' AS decimal(3, 0))", (Type)DecimalType.createDecimalType((int)3, (int)0), "CAST('-193' AS decimal(3, 0))").addRoundTrip("decimal(3, 1)", "CAST('10.0' AS decimal(3, 1))", (Type)DecimalType.createDecimalType((int)3, (int)1), "CAST('10.0' AS decimal(3, 1))").addRoundTrip("decimal(3, 1)", "CAST('10.1' AS decimal(3, 1))", (Type)DecimalType.createDecimalType((int)3, (int)1), "CAST('10.1' AS decimal(3, 1))").addRoundTrip("decimal(3, 1)", "CAST('-10.1' AS decimal(3, 1))", (Type)DecimalType.createDecimalType((int)3, (int)1), "CAST('-10.1' AS decimal(3, 1))").addRoundTrip("decimal(4, 2)", "CAST('2' AS decimal(4, 2))", (Type)DecimalType.createDecimalType((int)4, (int)2), "CAST('2' AS decimal(4, 2))").addRoundTrip("decimal(4, 2)", "CAST('2.3' AS decimal(4, 2))", (Type)DecimalType.createDecimalType((int)4, (int)2), "CAST('2.3' AS decimal(4, 2))").addRoundTrip("decimal(24, 2)", "CAST('2' AS decimal(24, 2))", (Type)DecimalType.createDecimalType((int)24, (int)2), "CAST('2' AS decimal(24, 2))").addRoundTrip("decimal(24, 2)", "CAST('2.3' AS decimal(24, 2))", (Type)DecimalType.createDecimalType((int)24, (int)2), "CAST('2.3' AS decimal(24, 2))").addRoundTrip("decimal(24, 2)", "CAST('123456789.3' AS decimal(24, 2))", (Type)DecimalType.createDecimalType((int)24, (int)2), "CAST('123456789.3' AS decimal(24, 2))").addRoundTrip("decimal(24, 4)", "CAST('12345678901234567890.31' AS decimal(24, 4))", (Type)DecimalType.createDecimalType((int)24, (int)4), "CAST('12345678901234567890.31' AS decimal(24, 4))").addRoundTrip("decimal(30, 5)", "CAST('3141592653589793238462643.38327' AS decimal(30, 5))", (Type)DecimalType.createDecimalType((int)30, (int)5), "CAST('3141592653589793238462643.38327' AS decimal(30, 5))").addRoundTrip("decimal(30, 5)", "CAST('-3141592653589793238462643.38327' AS decimal(30, 5))", (Type)DecimalType.createDecimalType((int)30, (int)5), "CAST('-3141592653589793238462643.38327' AS decimal(30, 5))").addRoundTrip("decimal(38, 0)", "CAST('27182818284590452353602874713526624977' AS decimal(38, 0))", (Type)DecimalType.createDecimalType((int)38, (int)0), "CAST('27182818284590452353602874713526624977' AS decimal(38, 0))").addRoundTrip("decimal(38, 0)", "CAST('-27182818284590452353602874713526624977' AS decimal(38, 0))", (Type)DecimalType.createDecimalType((int)38, (int)0), "CAST('-27182818284590452353602874713526624977' AS decimal(38, 0))").execute(this.getQueryRunner(), this.postgresCreateAndInsert("test_decimal")).execute(this.getQueryRunner(), this.trinoCreateAsSelect("test_decimal"));
        SqlDataTypeTest.create().addRoundTrip("numeric", "1.1", (Type)DecimalType.createDecimalType((int)38, (int)5), "CAST(1.1 AS DECIMAL(38, 5))").execute(this.getQueryRunner(), this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 5), this.postgresCreateAndInsert("test_unspecified_decimal"));
    }

    @Test
    public void testChar() {
        SqlDataTypeTest.create().addRoundTrip("char(10)", "'text_a'", (Type)CharType.createCharType((long)10L), "CAST('text_a' AS char(10))").addRoundTrip("char(255)", "'text_b'", (Type)CharType.createCharType((long)255L), "CAST('text_b' AS char(255))").addRoundTrip("char(5)", "'\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)CharType.createCharType((long)5L), "CAST('\u653b\u6bbb\u6a5f\u52d5\u968a' AS char(5))").addRoundTrip("char(32)", "'\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)CharType.createCharType((long)32L), "CAST('\u653b\u6bbb\u6a5f\u52d5\u968a' AS char(32))").addRoundTrip("char(1)", "'\ud83d\ude02'", (Type)CharType.createCharType((long)1L), "CAST('\ud83d\ude02' AS char(1))").addRoundTrip("char(77)", "'\u041d\u0443, \u043f\u043e\u0433\u043e\u0434\u0438!'", (Type)CharType.createCharType((long)77L), "CAST('\u041d\u0443, \u043f\u043e\u0433\u043e\u0434\u0438!' AS char(77))").execute(this.getQueryRunner(), this.postgresCreateAndInsert("test_char")).execute(this.getQueryRunner(), this.trinoCreateAsSelect("test_char"));
        int length = 65537;
        String postgresqlType = String.format("char(%s)", length);
        VarcharType trinoType = VarcharType.createVarcharType((int)length);
        SqlDataTypeTest.create().addRoundTrip(postgresqlType, "'test_f'", (Type)trinoType, String.format("'test_f%s'", " ".repeat(length - 6))).addRoundTrip(postgresqlType, String.format("'%s'", "a".repeat(length)), (Type)trinoType, String.format("'%s'", "a".repeat(length))).addRoundTrip(postgresqlType, "'\ud83d\ude02'", (Type)trinoType, String.format("'\ud83d\ude02%s'", " ".repeat(length - 1))).execute(this.getQueryRunner(), this.postgresCreateAndInsert("test_char"));
    }

    @Test
    public void testVarchar() {
        SqlDataTypeTest.create().addRoundTrip("varchar(10)", "'text_a'", (Type)VarcharType.createVarcharType((int)10), "CAST('text_a' AS varchar(10))").addRoundTrip("varchar(255)", "'text_b'", (Type)VarcharType.createVarcharType((int)255), "CAST('text_b' AS varchar(255))").addRoundTrip("varchar(65535)", "'text_d'", (Type)VarcharType.createVarcharType((int)65535), "CAST('text_d' AS varchar(65535))").addRoundTrip("varchar(5)", "'\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)VarcharType.createVarcharType((int)5), "CAST('\u653b\u6bbb\u6a5f\u52d5\u968a' AS varchar(5))").addRoundTrip("varchar(32)", "'\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)VarcharType.createVarcharType((int)32), "CAST('\u653b\u6bbb\u6a5f\u52d5\u968a' AS varchar(32))").addRoundTrip("varchar(20000)", "'\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)VarcharType.createVarcharType((int)20000), "CAST('\u653b\u6bbb\u6a5f\u52d5\u968a' AS varchar(20000))").addRoundTrip("varchar(1)", "'\ud83d\ude02'", (Type)VarcharType.createVarcharType((int)1), "CAST('\ud83d\ude02' AS varchar(1))").addRoundTrip("varchar(77)", "'\u041d\u0443, \u043f\u043e\u0433\u043e\u0434\u0438!'", (Type)VarcharType.createVarcharType((int)77), "CAST('\u041d\u0443, \u043f\u043e\u0433\u043e\u0434\u0438!' AS varchar(77))").addRoundTrip("varchar(10485760)", "'text_f'", (Type)VarcharType.createVarcharType((int)0xA00000), "CAST('text_f' AS varchar(10485760))").execute(this.getQueryRunner(), this.postgresCreateAndInsert("test_varchar")).execute(this.getQueryRunner(), this.trinoCreateAsSelect("test_varchar"));
    }

    @Test
    public void testUnboundedVarchar() {
        SqlDataTypeTest.create().addRoundTrip("varchar", "'text_a'", (Type)VarcharType.createUnboundedVarcharType(), "CAST('text_a' AS varchar)").addRoundTrip("varchar", "'text_b'", (Type)VarcharType.createUnboundedVarcharType(), "CAST('text_b' AS varchar)").addRoundTrip("varchar", "'text_d'", (Type)VarcharType.createUnboundedVarcharType(), "CAST('text_d' AS varchar)").addRoundTrip("varchar", "'\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)VarcharType.createUnboundedVarcharType(), "CAST('\u653b\u6bbb\u6a5f\u52d5\u968a' AS varchar)").addRoundTrip("varchar", "'\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)VarcharType.createUnboundedVarcharType(), "CAST('\u653b\u6bbb\u6a5f\u52d5\u968a' AS varchar)").addRoundTrip("varchar", "'\u653b\u6bbb\u6a5f\u52d5\u968a'", (Type)VarcharType.createUnboundedVarcharType(), "CAST('\u653b\u6bbb\u6a5f\u52d5\u968a' AS varchar)").addRoundTrip("varchar", "'\ud83d\ude02'", (Type)VarcharType.createUnboundedVarcharType(), "CAST('\ud83d\ude02' AS varchar)").addRoundTrip("varchar", "'\u041d\u0443, \u043f\u043e\u0433\u043e\u0434\u0438!'", (Type)VarcharType.createUnboundedVarcharType(), "CAST('\u041d\u0443, \u043f\u043e\u0433\u043e\u0434\u0438!' AS varchar)").addRoundTrip("varchar", "'text_f'", (Type)VarcharType.createUnboundedVarcharType(), "CAST('text_f' AS varchar)").execute(this.getQueryRunner(), this.postgresCreateAndInsert("test_varchar")).execute(this.getQueryRunner(), this.trinoCreateAsSelect("test_varchar"));
    }

    @Test
    public void testVarbinary() {
        SqlDataTypeTest.create().addRoundTrip("bytea", "NULL", (Type)VarbinaryType.VARBINARY, "CAST(NULL AS varbinary)").addRoundTrip("bytea", "bytea E'\\\\x'", (Type)VarbinaryType.VARBINARY, "X''").addRoundTrip("bytea", TestPostgreSqlTypeMapping.utf8ByteaLiteral("hello"), (Type)VarbinaryType.VARBINARY, "to_utf8('hello')").addRoundTrip("bytea", TestPostgreSqlTypeMapping.utf8ByteaLiteral("Pi\u0119kna \u0142\u0105ka w \u6771\u4eac\u90fd"), (Type)VarbinaryType.VARBINARY, "to_utf8('Pi\u0119kna \u0142\u0105ka w \u6771\u4eac\u90fd')").addRoundTrip("bytea", TestPostgreSqlTypeMapping.utf8ByteaLiteral("Bag full of \ud83d\udcb0"), (Type)VarbinaryType.VARBINARY, "to_utf8('Bag full of \ud83d\udcb0')").addRoundTrip("bytea", "bytea E'\\\\x0001020304050607080DF9367AA7000000'", (Type)VarbinaryType.VARBINARY, "X'0001020304050607080DF9367AA7000000'").addRoundTrip("bytea", "bytea E'\\\\x000000000000'", (Type)VarbinaryType.VARBINARY, "X'000000000000'").execute(this.getQueryRunner(), this.postgresCreateAndInsert("test_bytea"));
        SqlDataTypeTest.create().addRoundTrip("varbinary", "NULL", (Type)VarbinaryType.VARBINARY, "CAST(NULL AS varbinary)").addRoundTrip("varbinary", "X''", (Type)VarbinaryType.VARBINARY, "X''").addRoundTrip("varbinary", "X'68656C6C6F'", (Type)VarbinaryType.VARBINARY, "to_utf8('hello')").addRoundTrip("varbinary", "X'5069C4996B6E6120C582C4856B61207720E69DB1E4BAACE983BD'", (Type)VarbinaryType.VARBINARY, "to_utf8('Pi\u0119kna \u0142\u0105ka w \u6771\u4eac\u90fd')").addRoundTrip("varbinary", "X'4261672066756C6C206F6620F09F92B0'", (Type)VarbinaryType.VARBINARY, "to_utf8('Bag full of \ud83d\udcb0')").addRoundTrip("varbinary", "X'0001020304050607080DF9367AA7000000'", (Type)VarbinaryType.VARBINARY, "X'0001020304050607080DF9367AA7000000'").addRoundTrip("varbinary", "X'000000000000'", (Type)VarbinaryType.VARBINARY, "X'000000000000'").execute(this.getQueryRunner(), this.trinoCreateAsSelect("test_varbinary"));
    }

    private static String utf8ByteaLiteral(String string) {
        return String.format("bytea E'\\\\x%s'", BaseEncoding.base16().encode(string.getBytes(StandardCharsets.UTF_8)));
    }

    @Test
    public void testForcedMappingToVarchar() {
        JdbcSqlExecutor jdbcSqlExecutor = new JdbcSqlExecutor(this.postgreSqlServer.getJdbcUrl(), this.postgreSqlServer.getProperties());
        jdbcSqlExecutor.execute("CREATE TABLE test_forced_varchar_mapping(tsrange_col tsrange, inet_col inet, tsrange_arr_col tsrange[], unsupported_nonforced_column tstzrange)");
        jdbcSqlExecutor.execute("INSERT INTO test_forced_varchar_mapping(tsrange_col, inet_col, tsrange_arr_col, unsupported_nonforced_column) VALUES ('[2010-01-01 14:30, 2010-01-01 15:30)'::tsrange, '172.0.0.1'::inet, array['[2010-01-01 14:30, 2010-01-01 15:30)'::tsrange], '[2010-01-01 14:30, 2010-01-01 15:30)'::tstzrange)");
        try {
            this.assertQuery(this.sessionWithArrayAsArray(), "SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = 'tpch' AND table_name = 'test_forced_varchar_mapping'", "VALUES ('tsrange_col','varchar'),('inet_col','varchar'),('tsrange_arr_col','array(varchar)')");
            this.assertQuery(this.sessionWithArrayAsArray(), "SELECT * FROM test_forced_varchar_mapping", "VALUES ('[\"2010-01-01 14:30:00\",\"2010-01-01 15:30:00\")','172.0.0.1',ARRAY['[\"2010-01-01 14:30:00\",\"2010-01-01 15:30:00\")'])");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT 1 FROM test_forced_varchar_mapping WHERE tsrange_col = '[\"2010-01-01 14:30:00\",\"2010-01-01 15:30:00\")'"))).matches("VALUES 1").isNotFullyPushedDown(new Class[]{FilterNode.class});
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT 1 FROM test_forced_varchar_mapping WHERE tsrange_col = 'some value'"))).returnsEmptyResult().isNotFullyPushedDown(new Class[]{FilterNode.class});
            this.assertQueryFails("INSERT INTO test_forced_varchar_mapping (tsrange_col) VALUES ('some value')", "Underlying type that is mapped to VARCHAR is not supported for INSERT: tsrange");
        }
        finally {
            jdbcSqlExecutor.execute("DROP TABLE test_forced_varchar_mapping");
        }
    }

    @Test
    public void testDecimalExceedingPrecisionMaxIgnored() {
        this.testUnsupportedDataTypeAsIgnored("decimal(50,0)", "12345678901234567890123456789012345678901234567890");
    }

    @Test
    public void testDecimalExceedingPrecisionMaxConvertedToVarchar() {
        this.testUnsupportedDataTypeConvertedToVarchar(this.getSession(), "decimal(50,0)", "numeric", "12345678901234567890123456789012345678901234567890", "'12345678901234567890123456789012345678901234567890'");
    }

    @Test
    public void testDecimalExceedingPrecisionMaxWithExceedingIntegerValues() {
        JdbcSqlExecutor jdbcSqlExecutor = new JdbcSqlExecutor(this.postgreSqlServer.getJdbcUrl(), this.postgreSqlServer.getProperties());
        try (TestTable testTable = new TestTable((SqlExecutor)jdbcSqlExecutor, "test_exceeding_max_decimal", "(d_col decimal(65,25))", Arrays.asList("1234567890123456789012345678901234567890.123456789", "-1234567890123456789012345678901234567890.123456789"));){
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 0), String.format("SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = 'tpch' AND table_name = '%s'", testTable.getName()), "VALUES ('d_col', 'decimal(38,0)')");
            this.assertQueryFails(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 0), "SELECT d_col FROM " + testTable.getName(), "Rounding necessary");
            this.assertQueryFails(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.HALF_UP, 0), "SELECT d_col FROM " + testTable.getName(), "Decimal overflow");
            this.assertQuery(this.sessionWithDecimalMappingStrict(UnsupportedTypeHandling.CONVERT_TO_VARCHAR), String.format("SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = 'tpch' AND table_name = '%s'", testTable.getName()), "VALUES ('d_col', 'varchar')");
            this.assertQuery(this.sessionWithDecimalMappingStrict(UnsupportedTypeHandling.CONVERT_TO_VARCHAR), "SELECT d_col FROM " + testTable.getName(), "VALUES ('1234567890123456789012345678901234567890.1234567890000000000000000'), ('-1234567890123456789012345678901234567890.1234567890000000000000000')");
        }
    }

    @Test
    public void testDecimalExceedingPrecisionMaxWithNonExceedingIntegerValues() {
        JdbcSqlExecutor jdbcSqlExecutor = new JdbcSqlExecutor(this.postgreSqlServer.getJdbcUrl(), this.postgreSqlServer.getProperties());
        try (TestTable testTable = new TestTable((SqlExecutor)jdbcSqlExecutor, "test_exceeding_max_decimal", "(d_col decimal(60,20))", Arrays.asList("123456789012345678901234567890.123456789012345", "-123456789012345678901234567890.123456789012345"));){
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 0), String.format("SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = 'tpch' AND table_name = '%s'", testTable.getName()), "VALUES ('d_col', 'decimal(38,0)')");
            this.assertQueryFails(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 0), "SELECT d_col FROM " + testTable.getName(), "Rounding necessary");
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.HALF_UP, 0), "SELECT d_col FROM " + testTable.getName(), "VALUES (123456789012345678901234567890), (-123456789012345678901234567890)");
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 8), String.format("SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = 'tpch' AND table_name = '%s'", testTable.getName()), "VALUES ('d_col', 'decimal(38,8)')");
            this.assertQueryFails(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 8), "SELECT d_col FROM " + testTable.getName(), "Rounding necessary");
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.HALF_UP, 8), "SELECT d_col FROM " + testTable.getName(), "VALUES (123456789012345678901234567890.12345679), (-123456789012345678901234567890.12345679)");
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.HALF_UP, 22), String.format("SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = 'tpch' AND table_name = '%s'", testTable.getName()), "VALUES ('d_col', 'decimal(38,20)')");
            this.assertQueryFails(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.HALF_UP, 20), "SELECT d_col FROM " + testTable.getName(), "Decimal overflow");
            this.assertQueryFails(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.HALF_UP, 9), "SELECT d_col FROM " + testTable.getName(), "Decimal overflow");
            this.assertQuery(this.sessionWithDecimalMappingStrict(UnsupportedTypeHandling.CONVERT_TO_VARCHAR), String.format("SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = 'tpch' AND table_name = '%s'", testTable.getName()), "VALUES ('d_col', 'varchar')");
            this.assertQuery(this.sessionWithDecimalMappingStrict(UnsupportedTypeHandling.CONVERT_TO_VARCHAR), "SELECT d_col FROM " + testTable.getName(), "VALUES ('123456789012345678901234567890.12345678901234500000'), ('-123456789012345678901234567890.12345678901234500000')");
        }
    }

    @Test(dataProvider="testDecimalExceedingPrecisionMaxProvider")
    public void testDecimalExceedingPrecisionMaxWithSupportedValues(int typePrecision, int typeScale) {
        JdbcSqlExecutor jdbcSqlExecutor = new JdbcSqlExecutor(this.postgreSqlServer.getJdbcUrl(), this.postgreSqlServer.getProperties());
        try (TestTable testTable = new TestTable((SqlExecutor)jdbcSqlExecutor, "test_exceeding_max_decimal", String.format("(d_col decimal(%d,%d))", typePrecision, typeScale), Arrays.asList("12.01", "-12.01", "123", "-123", "1.12345678", "-1.12345678"));){
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 0), String.format("SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = 'tpch' AND table_name = '%s'", testTable.getName()), "VALUES ('d_col', 'decimal(38,0)')");
            this.assertQueryFails(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 0), "SELECT d_col FROM " + testTable.getName(), "Rounding necessary");
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.HALF_UP, 0), "SELECT d_col FROM " + testTable.getName(), "VALUES (12), (-12), (123), (-123), (1), (-1)");
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.HALF_UP, 3), String.format("SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = 'tpch' AND table_name = '%s'", testTable.getName()), "VALUES ('d_col', 'decimal(38,3)')");
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.HALF_UP, 3), "SELECT d_col FROM " + testTable.getName(), "VALUES (12.01), (-12.01), (123), (-123), (1.123), (-1.123)");
            this.assertQueryFails(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 3), "SELECT d_col FROM " + testTable.getName(), "Rounding necessary");
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.HALF_UP, 8), String.format("SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = 'tpch' AND table_name = '%s'", testTable.getName()), "VALUES ('d_col', 'decimal(38,8)')");
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.HALF_UP, 8), "SELECT d_col FROM " + testTable.getName(), "VALUES (12.01), (-12.01), (123), (-123), (1.12345678), (-1.12345678)");
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.HALF_UP, 9), "SELECT d_col FROM " + testTable.getName(), "VALUES (12.01), (-12.01), (123), (-123), (1.12345678), (-1.12345678)");
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 8), "SELECT d_col FROM " + testTable.getName(), "VALUES (12.01), (-12.01), (123), (-123), (1.12345678), (-1.12345678)");
        }
    }

    @DataProvider
    public Object[][] testDecimalExceedingPrecisionMaxProvider() {
        return new Object[][]{{40, 8}, {50, 10}};
    }

    @Test
    public void testDecimalUnspecifiedPrecisionWithSupportedValues() {
        JdbcSqlExecutor jdbcSqlExecutor = new JdbcSqlExecutor(this.postgreSqlServer.getJdbcUrl(), this.postgreSqlServer.getProperties());
        try (TestTable testTable = new TestTable((SqlExecutor)jdbcSqlExecutor, "test_var_decimal", "(d_col decimal)", Arrays.asList("1.12", "123456.789", "-1.12", "-123456.789"));){
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 0), String.format("SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = 'tpch' AND table_name = '%s'", testTable.getName()), "VALUES ('d_col','decimal(38,0)')");
            this.assertQueryFails(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 0), "SELECT d_col FROM " + testTable.getName(), "Rounding necessary");
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.HALF_UP, 0), "SELECT d_col FROM " + testTable.getName(), "VALUES (1), (123457), (-1), (-123457)");
            this.assertQueryFails(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 1), "SELECT d_col FROM " + testTable.getName(), "Rounding necessary");
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.HALF_UP, 1), String.format("SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = 'tpch' AND table_name = '%s'", testTable.getName()), "VALUES ('d_col','decimal(38,1)')");
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.HALF_UP, 1), "SELECT d_col FROM " + testTable.getName(), "VALUES (1.1), (123456.8), (-1.1), (-123456.8)");
            this.assertQueryFails(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 2), "SELECT d_col FROM " + testTable.getName(), "Rounding necessary");
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.HALF_UP, 2), "SELECT d_col FROM " + testTable.getName(), "VALUES (1.12), (123456.79), (-1.12), (-123456.79)");
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 3), String.format("SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = 'tpch' AND table_name = '%s'", testTable.getName()), "VALUES ('d_col','decimal(38,3)')");
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 3), "SELECT d_col FROM " + testTable.getName(), "VALUES (1.12), (123456.789), (-1.12), (-123456.789)");
        }
    }

    @Test
    public void testDecimalUnspecifiedPrecisionWithExceedingValue() {
        JdbcSqlExecutor jdbcSqlExecutor = new JdbcSqlExecutor(this.postgreSqlServer.getJdbcUrl(), this.postgreSqlServer.getProperties());
        try (TestTable testTable = new TestTable((SqlExecutor)jdbcSqlExecutor, "test_var_decimal_with_exceeding_value", "(key varchar(5), d_col decimal)", Arrays.asList("NULL, '1.12'", "NULL, '1234567890123456789012345678901234567890.1234567'"));){
            this.assertQuery(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 0), String.format("SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = 'tpch' AND table_name = '%s'", testTable.getName()), "VALUES ('key', 'varchar(5)'),('d_col', 'decimal(38,0)')");
            this.assertQueryFails(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.UNNECESSARY, 0), "SELECT * FROM " + testTable.getName(), "Rounding necessary");
            this.assertQueryFails(this.sessionWithDecimalMappingAllowOverflow(RoundingMode.HALF_UP, 0), "SELECT * FROM " + testTable.getName(), "Decimal overflow");
            this.assertQuery(this.sessionWithDecimalMappingStrict(UnsupportedTypeHandling.CONVERT_TO_VARCHAR), String.format("SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = 'tpch' AND table_name = '%s'", testTable.getName()), "VALUES ('key', 'varchar(5)'),('d_col', 'varchar')");
            this.assertQuery(this.sessionWithDecimalMappingStrict(UnsupportedTypeHandling.CONVERT_TO_VARCHAR), "SELECT * FROM " + testTable.getName(), "VALUES (NULL, '1.12'), (NULL, '1234567890123456789012345678901234567890.1234567')");
            this.assertQuery(this.sessionWithDecimalMappingStrict(UnsupportedTypeHandling.IGNORE), String.format("SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = 'tpch' AND table_name = '%s'", testTable.getName()), "VALUES ('key', 'varchar(5)')");
        }
    }

    @Test
    public void testArrayDisabled() {
        Session session = Session.builder((Session)this.getSession()).setCatalogSessionProperty("postgresql", "array_mapping", PostgreSqlConfig.ArrayMapping.DISABLED.name()).build();
        this.testUnsupportedDataTypeAsIgnored(session, "bigint[]", "ARRAY[42]");
        this.testUnsupportedDataTypeConvertedToVarchar(session, "bigint[]", "_int8", "ARRAY[42]", "'{42}'");
        this.testUnsupportedDataTypeAsIgnored(session, "bytea[]", "ARRAY['binary'::bytea]");
        this.testUnsupportedDataTypeConvertedToVarchar(session, "bytea[]", "_bytea", "ARRAY['binary'::bytea]", "'{\"\\\\x62696e617279\"}'");
    }

    @Test
    public void testArray() {
        Session session = this.sessionWithArrayAsArray();
        SqlDataTypeTest.create().addRoundTrip("ARRAY(boolean)", "ARRAY[true, false]", (Type)new ArrayType((Type)BooleanType.BOOLEAN), "ARRAY[true, false]").addRoundTrip("ARRAY(bigint)", "ARRAY[123456789012]", (Type)new ArrayType((Type)BigintType.BIGINT), "ARRAY[123456789012]").addRoundTrip("ARRAY(integer)", "ARRAY[1, 2, 1234567890]", (Type)new ArrayType((Type)IntegerType.INTEGER), "ARRAY[1, 2, 1234567890]").addRoundTrip("ARRAY(smallint)", "ARRAY[32456]", (Type)new ArrayType((Type)SmallintType.SMALLINT), "ARRAY[SMALLINT '32456']").addRoundTrip("ARRAY(double)", "ARRAY[123.45]", (Type)new ArrayType((Type)DoubleType.DOUBLE), "ARRAY[DOUBLE '123.45']").addRoundTrip("ARRAY(real)", "ARRAY[123.45]", (Type)new ArrayType((Type)RealType.REAL), "ARRAY[REAL '123.45']").execute(this.getQueryRunner(), session, this.trinoCreateAsSelect(session, "test_array_basic"));
        this.arrayDateTest(TestPostgreSqlTypeMapping::arrayDataType).execute(this.getQueryRunner(), session, this.trinoCreateAsSelect(session, "test_array_date"));
        this.arrayDateTest(TestPostgreSqlTypeMapping::postgresArrayDataType).execute(this.getQueryRunner(), session, this.postgresCreateAndInsert("test_array_date"));
        this.arrayDecimalTest(TestPostgreSqlTypeMapping::arrayDataType).execute(this.getQueryRunner(), session, this.trinoCreateAsSelect(session, "test_array_decimal"));
        this.arrayDecimalTest(TestPostgreSqlTypeMapping::postgresArrayDataType).execute(this.getQueryRunner(), session, this.postgresCreateAndInsert("test_array_decimal"));
        this.arrayVarcharDataTypeTest(TestPostgreSqlTypeMapping::arrayDataType).execute(this.getQueryRunner(), session, this.trinoCreateAsSelect(session, "test_array_varchar"));
        this.arrayVarcharDataTypeTest(TestPostgreSqlTypeMapping::postgresArrayDataType).execute(this.getQueryRunner(), session, this.postgresCreateAndInsert("test_array_varchar"));
        this.testUnsupportedDataTypeAsIgnored(session, "bytea[]", "ARRAY['binary value'::bytea]");
        this.testUnsupportedDataTypeAsIgnored(session, "bytea[]", "ARRAY[ARRAY['binary value'::bytea]]");
        this.testUnsupportedDataTypeAsIgnored(session, "bytea[]", "ARRAY[ARRAY[ARRAY['binary value'::bytea]]]");
        this.testUnsupportedDataTypeAsIgnored(session, "_bytea", "ARRAY['binary value'::bytea]");
        this.testUnsupportedDataTypeConvertedToVarchar(session, "bytea[]", "_bytea", "ARRAY['binary value'::bytea]", "'{\"\\\\x62696e6172792076616c7565\"}'");
        this.arrayUnicodeDataTypeTest(TestPostgreSqlTypeMapping::arrayDataType, DataType::charDataType).execute(this.getQueryRunner(), session, this.trinoCreateAsSelect(session, "test_array_parameterized_char_unicode"));
        this.arrayUnicodeDataTypeTest(TestPostgreSqlTypeMapping::postgresArrayDataType, DataType::charDataType).execute(this.getQueryRunner(), session, this.postgresCreateAndInsert("test_array_parameterized_char_unicode"));
        this.arrayVarcharUnicodeDataTypeTest(TestPostgreSqlTypeMapping::arrayDataType).execute(this.getQueryRunner(), session, this.trinoCreateAsSelect(session, "test_array_parameterized_varchar_unicode"));
        this.arrayVarcharUnicodeDataTypeTest(TestPostgreSqlTypeMapping::postgresArrayDataType).execute(this.getQueryRunner(), session, this.postgresCreateAndInsert("test_array_parameterized_varchar_unicode"));
    }

    @Test
    public void testInternalArray() {
        SqlDataTypeTest.create().addRoundTrip("_int4", "ARRAY[1, 2, 3]", (Type)new ArrayType((Type)IntegerType.INTEGER), "ARRAY[1, 2, 3]").addRoundTrip("_text", "ARRAY['a', 'b']", (Type)new ArrayType((Type)VarcharType.VARCHAR), "ARRAY[CAST('a' AS varchar), CAST('b' AS varchar)]").execute(this.getQueryRunner(), this.sessionWithArrayAsArray(), this.postgresCreateAndInsert("test_array_with_native_name"));
    }

    @Test
    public void testArrayEmptyOrNulls() {
        DataTypeTest.create().addRoundTrip(TestPostgreSqlTypeMapping.arrayDataType(DataType.bigintDataType()), Arrays.asList(new Long[0])).addRoundTrip(TestPostgreSqlTypeMapping.arrayDataType(DataType.booleanDataType()), null).addRoundTrip(TestPostgreSqlTypeMapping.arrayDataType(DataType.realDataType()), Collections.singletonList(null)).addRoundTrip(TestPostgreSqlTypeMapping.arrayDataType(DataType.integerDataType()), Arrays.asList(1, null, 3, null)).addRoundTrip(TestPostgreSqlTypeMapping.arrayDataType(DataType.timestampDataType((int)3)), Arrays.asList(new LocalDateTime[0])).addRoundTrip(TestPostgreSqlTypeMapping.arrayDataType(DataType.timestampDataType((int)3)), Collections.singletonList(null)).addRoundTrip(TestPostgreSqlTypeMapping.arrayDataType(TestPostgreSqlTypeMapping.trinoTimestampWithTimeZoneDataType(3)), Arrays.asList(new ZonedDateTime[0])).addRoundTrip(TestPostgreSqlTypeMapping.arrayDataType(TestPostgreSqlTypeMapping.trinoTimestampWithTimeZoneDataType(3)), Collections.singletonList(null)).execute(this.getQueryRunner(), this.sessionWithArrayAsArray(), this.trinoCreateAsSelect(this.sessionWithArrayAsArray(), "test_array_empty_or_nulls"));
    }

    private DataTypeTest arrayDecimalTest(Function<DataType<BigDecimal>, DataType<List<BigDecimal>>> arrayTypeFactory) {
        return DataTypeTest.create().addRoundTrip(arrayTypeFactory.apply((DataType<BigDecimal>)DataType.decimalDataType((int)3, (int)0)), Arrays.asList(new BigDecimal("193"), new BigDecimal("19"), new BigDecimal("-193"))).addRoundTrip(arrayTypeFactory.apply((DataType<BigDecimal>)DataType.decimalDataType((int)3, (int)1)), Arrays.asList(new BigDecimal("10.0"), new BigDecimal("10.1"), new BigDecimal("-10.1"))).addRoundTrip(arrayTypeFactory.apply((DataType<BigDecimal>)DataType.decimalDataType((int)4, (int)2)), Arrays.asList(new BigDecimal("2"), new BigDecimal("2.3"))).addRoundTrip(arrayTypeFactory.apply((DataType<BigDecimal>)DataType.decimalDataType((int)24, (int)2)), Arrays.asList(new BigDecimal("2"), new BigDecimal("2.3"), new BigDecimal("123456789.3"))).addRoundTrip(arrayTypeFactory.apply((DataType<BigDecimal>)DataType.decimalDataType((int)24, (int)4)), Arrays.asList(new BigDecimal("12345678901234567890.31"))).addRoundTrip(arrayTypeFactory.apply((DataType<BigDecimal>)DataType.decimalDataType((int)30, (int)5)), Arrays.asList(new BigDecimal("3141592653589793238462643.38327"), new BigDecimal("-3141592653589793238462643.38327"))).addRoundTrip(arrayTypeFactory.apply((DataType<BigDecimal>)DataType.decimalDataType((int)38, (int)0)), Arrays.asList(new BigDecimal("27182818284590452353602874713526624977"), new BigDecimal("-27182818284590452353602874713526624977")));
    }

    private DataTypeTest arrayVarcharDataTypeTest(Function<DataType<String>, DataType<List<String>>> arrayTypeFactory) {
        return DataTypeTest.create().addRoundTrip(arrayTypeFactory.apply((DataType<String>)DataType.varcharDataType((int)10)), Arrays.asList("text_a")).addRoundTrip(arrayTypeFactory.apply((DataType<String>)DataType.varcharDataType((int)255)), Arrays.asList("text_b")).addRoundTrip(arrayTypeFactory.apply((DataType<String>)DataType.varcharDataType((int)65535)), Arrays.asList("text_d")).addRoundTrip(arrayTypeFactory.apply((DataType<String>)DataType.varcharDataType((int)0xA00000)), Arrays.asList("text_f")).addRoundTrip(arrayTypeFactory.apply((DataType<String>)DataType.varcharDataType()), Arrays.asList("unbounded"));
    }

    private DataTypeTest arrayVarcharUnicodeDataTypeTest(Function<DataType<String>, DataType<List<String>>> arrayTypeFactory) {
        return this.arrayUnicodeDataTypeTest(arrayTypeFactory, DataType::varcharDataType).addRoundTrip(arrayTypeFactory.apply((DataType<String>)DataType.varcharDataType()), Arrays.asList("\u041d\u0443, \u043f\u043e\u0433\u043e\u0434\u0438!"));
    }

    private DataTypeTest arrayUnicodeDataTypeTest(Function<DataType<String>, DataType<List<String>>> arrayTypeFactory, Function<Integer, DataType<String>> dataTypeFactory) {
        String sampleUnicodeText = "\u653b\u6bbb\u6a5f\u52d5\u968a";
        String sampleFourByteUnicodeCharacter = "\ud83d\ude02";
        return DataTypeTest.create().addRoundTrip(arrayTypeFactory.apply(dataTypeFactory.apply(sampleUnicodeText.length())), Arrays.asList(sampleUnicodeText)).addRoundTrip(arrayTypeFactory.apply(dataTypeFactory.apply(32)), Arrays.asList(sampleUnicodeText)).addRoundTrip(arrayTypeFactory.apply(dataTypeFactory.apply(20000)), Arrays.asList(sampleUnicodeText)).addRoundTrip(arrayTypeFactory.apply(dataTypeFactory.apply(1)), Arrays.asList(sampleFourByteUnicodeCharacter));
    }

    private DataTypeTest arrayDateTest(Function<DataType<LocalDate>, DataType<List<LocalDate>>> arrayTypeFactory) {
        ZoneId jvmZone = ZoneId.systemDefault();
        Preconditions.checkState((boolean)jvmZone.getId().equals("America/Bahia_Banderas"), (Object)"This test assumes certain JVM time zone");
        LocalDate dateOfLocalTimeChangeForwardAtMidnightInJvmZone = LocalDate.of(1970, 1, 1);
        TestPostgreSqlTypeMapping.checkIsGap(jvmZone, dateOfLocalTimeChangeForwardAtMidnightInJvmZone.atStartOfDay());
        ZoneId someZone = ZoneId.of("Europe/Vilnius");
        LocalDate dateOfLocalTimeChangeForwardAtMidnightInSomeZone = LocalDate.of(1983, 4, 1);
        TestPostgreSqlTypeMapping.checkIsGap(someZone, dateOfLocalTimeChangeForwardAtMidnightInSomeZone.atStartOfDay());
        LocalDate dateOfLocalTimeChangeBackwardAtMidnightInSomeZone = LocalDate.of(1983, 10, 1);
        TestPostgreSqlTypeMapping.checkIsDoubled(someZone, dateOfLocalTimeChangeBackwardAtMidnightInSomeZone.atStartOfDay().minusMinutes(1L));
        return DataTypeTest.create().addRoundTrip(arrayTypeFactory.apply((DataType<LocalDate>)DataType.dateDataType()), Arrays.asList(LocalDate.of(1952, 4, 3))).addRoundTrip(arrayTypeFactory.apply((DataType<LocalDate>)DataType.dateDataType()), Arrays.asList(LocalDate.of(1970, 1, 1))).addRoundTrip(arrayTypeFactory.apply((DataType<LocalDate>)DataType.dateDataType()), Arrays.asList(LocalDate.of(1970, 2, 3))).addRoundTrip(arrayTypeFactory.apply((DataType<LocalDate>)DataType.dateDataType()), Arrays.asList(LocalDate.of(2017, 7, 1))).addRoundTrip(arrayTypeFactory.apply((DataType<LocalDate>)DataType.dateDataType()), Arrays.asList(LocalDate.of(2017, 1, 1))).addRoundTrip(arrayTypeFactory.apply((DataType<LocalDate>)DataType.dateDataType()), Arrays.asList(dateOfLocalTimeChangeForwardAtMidnightInJvmZone)).addRoundTrip(arrayTypeFactory.apply((DataType<LocalDate>)DataType.dateDataType()), Arrays.asList(dateOfLocalTimeChangeForwardAtMidnightInSomeZone)).addRoundTrip(arrayTypeFactory.apply((DataType<LocalDate>)DataType.dateDataType()), Arrays.asList(dateOfLocalTimeChangeBackwardAtMidnightInSomeZone));
    }

    @Test
    public void testArrayMultidimensional() {
        DataTypeTest.create().addRoundTrip(TestPostgreSqlTypeMapping.arrayDataType(TestPostgreSqlTypeMapping.arrayDataType(DataType.booleanDataType())), Arrays.asList(Arrays.asList(null, null, null))).addRoundTrip(TestPostgreSqlTypeMapping.arrayDataType(TestPostgreSqlTypeMapping.arrayDataType(DataType.booleanDataType())), Arrays.asList(Arrays.asList(true, null), Arrays.asList(null, null), Arrays.asList(false, false))).addRoundTrip(TestPostgreSqlTypeMapping.arrayDataType(TestPostgreSqlTypeMapping.arrayDataType(DataType.integerDataType())), Arrays.asList(Arrays.asList(1, 2), Arrays.asList(null, null), Arrays.asList(3, 4))).addRoundTrip(TestPostgreSqlTypeMapping.arrayDataType(TestPostgreSqlTypeMapping.arrayDataType(DataType.decimalDataType((int)3, (int)0))), Arrays.asList(Arrays.asList(new BigDecimal("193")), Arrays.asList(new BigDecimal("19")), Arrays.asList(new BigDecimal("-193")))).execute(this.getQueryRunner(), this.sessionWithArrayAsArray(), this.trinoCreateAsSelect(this.sessionWithArrayAsArray(), "test_array_2d"));
        DataTypeTest.create().addRoundTrip(TestPostgreSqlTypeMapping.arrayDataType(TestPostgreSqlTypeMapping.arrayDataType(TestPostgreSqlTypeMapping.arrayDataType(DataType.doubleDataType()))), Arrays.asList(Arrays.asList(Arrays.asList(123.45), Arrays.asList(678.99)), Arrays.asList(Arrays.asList(543.21), Arrays.asList(998.76)), Arrays.asList(Arrays.asList(567.123), Arrays.asList(789.12)))).addRoundTrip(TestPostgreSqlTypeMapping.arrayDataType(TestPostgreSqlTypeMapping.arrayDataType(TestPostgreSqlTypeMapping.arrayDataType(DataType.dateDataType()))), Arrays.asList(Arrays.asList(Arrays.asList(LocalDate.of(1952, 4, 3), LocalDate.of(1970, 1, 1))), Arrays.asList(Arrays.asList(null, LocalDate.of(1970, 1, 1))), Arrays.asList(Arrays.asList(LocalDate.of(1970, 2, 3), LocalDate.of(2017, 7, 1))))).execute(this.getQueryRunner(), this.sessionWithArrayAsArray(), this.trinoCreateAsSelect(this.sessionWithArrayAsArray(), "test_array_3d"));
    }

    @Test
    public void testArrayAsJson() {
        Session session = Session.builder((Session)this.getSession()).setSystemProperty("postgresql.array_mapping", PostgreSqlConfig.ArrayMapping.AS_JSON.name()).build();
        DataTypeTest.create().addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("boolean[]"), null).addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("boolean[]"), (Object)"[[true,false],[false,true],[true,true]]").addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("boolean[3][2]"), (Object)"[[true,false],[false,true],[true,true]]").addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("boolean[100][100][100]"), (Object)"[true]").addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("_bool"), (Object)"[[true,false],[null,null]]").addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("_bool"), (Object)"[[[null]]]").addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("_bool"), (Object)"[]").execute(this.getQueryRunner(), session, this.postgresCreateAndInsert("test_boolean_array_as_json"));
        DataTypeTest.create().addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("integer[]"), null).addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("integer[]"), (Object)"[[[1,2,3],[4,5,6]],[[7,8,9],[10,11,12]]]").addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("integer[100][100][100]"), (Object)"[0]").addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("integer[]"), (Object)"[[[null,null]]]").addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("integer[]"), (Object)"[]").addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("_int4"), (Object)"[]").addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("_int4"), (Object)"[[0],[1],[2],[3]]").execute(this.getQueryRunner(), session, this.postgresCreateAndInsert("test_integer_array_as_json"));
        DataTypeTest.create().addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("double precision[]"), null).addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("double precision[]"), (Object)"[[[1.1,2.2,3.3],[4.4,5.5,6.6]]]").addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("double precision[100][100][100]"), (Object)"[42.3]").addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("double precision[]"), (Object)"[[[null,null]]]").addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("double precision[]"), (Object)"[]").addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("_float8"), (Object)"[]").addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("_float8"), (Object)"[[1.1],[2.2]]").execute(this.getQueryRunner(), session, this.postgresCreateAndInsert("test_double_array_as_json"));
        DataTypeTest.create().addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("real[]"), null).addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("real[]"), (Object)"[[[1.1,2.2,3.3],[4.4,5.5,6.6]]]").addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("real[100][100][100]"), (Object)"[42.3]").addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("real[]"), (Object)"[[[null,null]]]").addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("real[]"), (Object)"[]").addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("_float4"), (Object)"[]").addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("_float4"), (Object)"[[1.1],[2.2]]").execute(this.getQueryRunner(), session, this.postgresCreateAndInsert("test_real_array_as_json"));
        DataTypeTest.create().addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("varchar[]"), null).addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("varchar[]"), (Object)"[\"text\"]").addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("_text"), (Object)"[[\"one\",\"two\"],[\"three\",\"four\"]]").addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("_text"), (Object)"[[\"one\",null]]").addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("_text"), (Object)"[]").execute(this.getQueryRunner(), session, this.postgresCreateAndInsert("test_varchar_array_as_json"));
        this.testUnsupportedDataTypeAsIgnored(session, "bytea[]", "ARRAY['binary value'::bytea]");
        this.testUnsupportedDataTypeAsIgnored(session, "bytea[]", "ARRAY[ARRAY['binary value'::bytea]]");
        this.testUnsupportedDataTypeAsIgnored(session, "bytea[]", "ARRAY[ARRAY[ARRAY['binary value'::bytea]]]");
        this.testUnsupportedDataTypeAsIgnored(session, "_bytea", "ARRAY['binary value'::bytea]");
        this.testUnsupportedDataTypeConvertedToVarchar(session, "bytea[]", "_bytea", "ARRAY['binary value'::bytea]", " '{\"\\\\x62696e6172792076616c7565\"}' ");
        DataTypeTest.create().addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("date[]"), null).addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("date[]"), (Object)"[\"2019-01-02\"]").addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("date[]"), (Object)"[null,null]").execute(this.getQueryRunner(), session, this.postgresCreateAndInsert("test_timestamp_array_as_json"));
        DataTypeTest.create().addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("timestamp[]"), null).addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("timestamp[]"), (Object)"[\"2019-01-02 03:04:05.789000\"]").addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("timestamp[]"), (Object)"[null,null]").execute(this.getQueryRunner(), session, this.postgresCreateAndInsert("test_timestamp_array_as_json"));
        DataTypeTest.create().addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("hstore[]"), null).addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("hstore[]"), (Object)"[]").addRoundTrip(TestPostgreSqlTypeMapping.arrayAsJsonDataType("hstore[]"), (Object)"[null,null]").addRoundTrip(TestPostgreSqlTypeMapping.hstoreArrayAsJsonDataType(), (Object)"[{\"a\":\"1\",\"b\":\"2\"},{\"a\":\"3\",\"d\":\"4\"}]").addRoundTrip(TestPostgreSqlTypeMapping.hstoreArrayAsJsonDataType(), (Object)"[{\"a\":null,\"b\":\"2\"}]").execute(this.getQueryRunner(), session, this.postgresCreateAndInsert("test_hstore_array_as_json"));
    }

    private static <E> DataType<List<E>> arrayDataType(DataType<E> elementType) {
        return TestPostgreSqlTypeMapping.arrayDataType(elementType, String.format("ARRAY(%s)", elementType.getInsertType()));
    }

    private static <E> DataType<List<E>> postgresArrayDataType(DataType<E> elementType) {
        return TestPostgreSqlTypeMapping.arrayDataType(elementType, elementType.getInsertType() + "[]");
    }

    private static <E> DataType<List<E>> arrayDataType(DataType<E> elementType, String insertType) {
        return DataType.dataType((String)insertType, (Type)new ArrayType(elementType.getTrinoResultType()), valuesList -> "ARRAY" + valuesList.stream().map(arg_0 -> ((DataType)elementType).toLiteral(arg_0)).collect(Collectors.toList()), valuesList -> "ARRAY" + valuesList.stream().map(arg_0 -> ((DataType)elementType).toTrinoLiteral(arg_0)).collect(Collectors.toList()), valuesList -> valuesList == null ? null : valuesList.stream().map(arg_0 -> ((DataType)elementType).toTrinoQueryResult(arg_0)).collect(Collectors.toList()));
    }

    private static DataType<String> arrayAsJsonDataType(String insertType) {
        return DataType.dataType((String)insertType, (Type)JsonType.JSON, value -> value.replace("[", "ARRAY[").replace("\"", "'") + "::" + insertType);
    }

    private static DataType<String> hstoreArrayAsJsonDataType() {
        return DataType.dataType((String)"hstore[]", (Type)JsonType.JSON, json -> ((List)HSTORE_CODEC.fromJson(json)).stream().map(TestPostgreSqlTypeMapping::hstoreLiteral).collect(Collectors.joining(",", "ARRAY[", "]")));
    }

    @Test(dataProvider="sessionZonesDataProvider")
    public void testDate(ZoneId sessionZone) {
        Session session = Session.builder((Session)this.getSession()).setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)sessionZone.getId())).build();
        SqlDataTypeTest.create().addRoundTrip("date", "DATE '0001-01-01'", (Type)DateType.DATE, "DATE '0001-01-01'").addRoundTrip("date", "DATE '1582-10-04'", (Type)DateType.DATE, "DATE '1582-10-04'").addRoundTrip("date", "DATE '1582-10-05'", (Type)DateType.DATE, "DATE '1582-10-05'").addRoundTrip("date", "DATE '1582-10-14'", (Type)DateType.DATE, "DATE '1582-10-14'").addRoundTrip("date", "DATE '1952-04-03'", (Type)DateType.DATE, "DATE '1952-04-03'").addRoundTrip("date", "DATE '1970-01-01'", (Type)DateType.DATE, "DATE '1970-01-01'").addRoundTrip("date", "DATE '1970-02-03'", (Type)DateType.DATE, "DATE '1970-02-03'").addRoundTrip("date", "DATE '2017-07-01'", (Type)DateType.DATE, "DATE '2017-07-01'").addRoundTrip("date", "DATE '2017-01-01'", (Type)DateType.DATE, "DATE '2017-01-01'").addRoundTrip("date", "DATE '1970-01-01'", (Type)DateType.DATE, "DATE '1970-01-01'").addRoundTrip("date", "DATE '1983-04-01'", (Type)DateType.DATE, "DATE '1983-04-01'").addRoundTrip("date", "DATE '1983-10-01'", (Type)DateType.DATE, "DATE '1983-10-01'").addRoundTrip("date", "DATE '5874897-12-31'", (Type)DateType.DATE, "DATE '5874897-12-31'").execute(this.getQueryRunner(), session, this.postgresCreateAndInsert("test_date")).execute(this.getQueryRunner(), session, this.trinoCreateAsSelect(session, "test_date")).execute(this.getQueryRunner(), session, this.trinoCreateAsSelect(this.getSession(), "test_date")).execute(this.getQueryRunner(), session, this.trinoCreateAndInsert(session, "test_date"));
        SqlDataTypeTest.create().addRoundTrip("DATE", "'4713-01-01 BC'", (Type)DateType.DATE, "DATE '-4712-01-01'").execute(this.getQueryRunner(), this.postgresCreateAndInsert("test_date_min"));
        SqlDataTypeTest.create().addRoundTrip("DATE", "DATE '-4712-01-01'", (Type)DateType.DATE, "DATE '-4712-01-01'").execute(this.getQueryRunner(), session, this.trinoCreateAsSelect(session, "test_date_min")).execute(this.getQueryRunner(), session, this.trinoCreateAsSelect(this.getSession(), "test_date_min")).execute(this.getQueryRunner(), session, this.trinoCreateAndInsert(session, "test_date_min"));
    }

    @Test
    public void testEnum() {
        JdbcSqlExecutor jdbcSqlExecutor = new JdbcSqlExecutor(this.postgreSqlServer.getJdbcUrl(), this.postgreSqlServer.getProperties());
        jdbcSqlExecutor.execute("CREATE TYPE enum_t AS ENUM ('a','b','c')");
        jdbcSqlExecutor.execute("CREATE TABLE test_enum(id int, enum_column enum_t)");
        jdbcSqlExecutor.execute("INSERT INTO test_enum(id,enum_column) values (1,'a'::enum_t),(2,'b'::enum_t)");
        try {
            this.assertQuery("SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = 'tpch' AND table_name = 'test_enum'", "VALUES ('id','integer'),('enum_column','varchar')");
            this.assertQuery("SELECT * FROM test_enum", "VALUES (1,'a'),(2,'b')");
            this.assertQuery("SELECT * FROM test_enum WHERE enum_column='a'", "VALUES (1,'a')");
        }
        finally {
            jdbcSqlExecutor.execute("DROP TABLE test_enum");
            jdbcSqlExecutor.execute("DROP TYPE enum_t");
        }
    }

    @Test(dataProvider="sessionZonesDataProvider")
    public void testTime(ZoneId sessionZone) {
        LocalTime timeGapInJvmZone = LocalTime.of(0, 12, 34, 567000000);
        TestPostgreSqlTypeMapping.checkIsGap(this.jvmZone, timeGapInJvmZone.atDate(EPOCH_DAY));
        Session session = Session.builder((Session)this.getSession()).setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)sessionZone.getId())).build();
        SqlDataTypeTest.create().addRoundTrip("time(0)", "TIME '01:12:34'", (Type)TimeType.createTimeType((int)0), "TIME '01:12:34'").addRoundTrip("time(1)", "TIME '02:12:34.1'", (Type)TimeType.createTimeType((int)1), "TIME '02:12:34.1'").addRoundTrip("time(2)", "TIME '02:12:34.01'", (Type)TimeType.createTimeType((int)2), "TIME '02:12:34.01'").addRoundTrip("time(3)", "TIME '02:12:34.001'", (Type)TimeType.createTimeType((int)3), "TIME '02:12:34.001'").addRoundTrip("time(3)", "TIME '03:12:34.000'", (Type)TimeType.createTimeType((int)3), "TIME '03:12:34.000'").addRoundTrip("time(4)", "TIME '04:12:34.0000'", (Type)TimeType.createTimeType((int)4), "TIME '04:12:34.0000'").addRoundTrip("time(5)", "TIME '05:12:34.00000'", (Type)TimeType.createTimeType((int)5), "TIME '05:12:34.00000'").addRoundTrip("time(5)", "TIME '06:12:34.00000'", (Type)TimeType.createTimeType((int)5), "TIME '06:12:34.00000'").addRoundTrip("time(6)", "TIME '09:12:34.000000'", (Type)TimeType.createTimeType((int)6), "TIME '09:12:34.000000'").addRoundTrip("time(6)", "TIME '10:12:34.000000'", (Type)TimeType.createTimeType((int)6), "TIME '10:12:34.000000'").addRoundTrip("time(6)", "TIME '15:12:34.567000'", (Type)TimeType.createTimeType((int)6), "TIME '15:12:34.567000'").addRoundTrip("time(6)", "TIME '23:59:59.000000'", (Type)TimeType.createTimeType((int)6), "TIME '23:59:59.000000'").addRoundTrip("time(6)", "TIME '23:59:59.999000'", (Type)TimeType.createTimeType((int)6), "TIME '23:59:59.999000'").addRoundTrip("time(6)", "TIME '23:59:59.999900'", (Type)TimeType.createTimeType((int)6), "TIME '23:59:59.999900'").addRoundTrip("time(6)", "TIME '23:59:59.999990'", (Type)TimeType.createTimeType((int)6), "TIME '23:59:59.999990'").addRoundTrip("time(6)", "TIME '23:59:59.999999'", (Type)TimeType.createTimeType((int)6), "TIME '23:59:59.999999'").addRoundTrip("time(3)", "TIME '00:00:00.000'", (Type)TimeType.createTimeType((int)3), "TIME '00:00:00.000'").addRoundTrip("time(3)", "TIME '00:12:34.567'", (Type)TimeType.createTimeType((int)3), "TIME '00:12:34.567'").execute(this.getQueryRunner(), session, this.trinoCreateAsSelect(session, "test_time")).execute(this.getQueryRunner(), session, this.trinoCreateAsSelect(this.getSession(), "test_time")).execute(this.getQueryRunner(), session, this.trinoCreateAndInsert(session, "test_time")).execute(this.getQueryRunner(), session, this.postgresCreateAndInsert("test_time"));
    }

    @Test
    public void testTimeCoercion() {
        SqlDataTypeTest.create().addRoundTrip("TIME '00:00:00'", "TIME '00:00:00'").addRoundTrip("TIME '00:00:00.000000'", "TIME '00:00:00.000000'").addRoundTrip("TIME '00:00:00.123456'", "TIME '00:00:00.123456'").addRoundTrip("TIME '12:34:56'", "TIME '12:34:56'").addRoundTrip("TIME '12:34:56.123456'", "TIME '12:34:56.123456'").addRoundTrip("TIME '23:59:59.000000'", "TIME '23:59:59.000000'").addRoundTrip("TIME '23:59:59.900000'", "TIME '23:59:59.900000'").addRoundTrip("TIME '23:59:59.990000'", "TIME '23:59:59.990000'").addRoundTrip("TIME '23:59:59.999000'", "TIME '23:59:59.999000'").addRoundTrip("TIME '23:59:59.999900'", "TIME '23:59:59.999900'").addRoundTrip("TIME '23:59:59.999990'", "TIME '23:59:59.999990'").addRoundTrip("TIME '23:59:59.999999'", "TIME '23:59:59.999999'").addRoundTrip("TIME '23:59:59'", "TIME '23:59:59'").addRoundTrip("TIME '23:59:59.9'", "TIME '23:59:59.9'").addRoundTrip("TIME '23:59:59.99'", "TIME '23:59:59.99'").addRoundTrip("TIME '23:59:59.999'", "TIME '23:59:59.999'").addRoundTrip("TIME '23:59:59.9999'", "TIME '23:59:59.9999'").addRoundTrip("TIME '23:59:59.99999'", "TIME '23:59:59.99999'").addRoundTrip("TIME '23:59:59.999999'", "TIME '23:59:59.999999'").addRoundTrip("TIME '00:00:00.0000001'", "TIME '00:00:00.000000'").addRoundTrip("TIME '00:00:00.000000000001'", "TIME '00:00:00.000000'").addRoundTrip("TIME '12:34:56.1234561'", "TIME '12:34:56.123456'").addRoundTrip("TIME '23:59:59.9999994'", "TIME '23:59:59.999999'").addRoundTrip("TIME '23:59:59.999999499999'", "TIME '23:59:59.999999'").addRoundTrip("TIME '00:00:00.0000004'", "TIME '00:00:00.000000'").addRoundTrip("TIME '00:00:00.00000049'", "TIME '00:00:00.000000'").addRoundTrip("TIME '00:00:00.000000449'", "TIME '00:00:00.000000'").addRoundTrip("TIME '00:00:00.0000004449'", "TIME '00:00:00.000000'").addRoundTrip("TIME '00:00:00.00000044449'", "TIME '00:00:00.000000'").addRoundTrip("TIME '00:00:00.000000444449'", "TIME '00:00:00.000000'").addRoundTrip("TIME '00:00:00.0000005'", "TIME '00:00:00.000001'").addRoundTrip("TIME '00:00:00.00000050'", "TIME '00:00:00.000001'").addRoundTrip("TIME '00:00:00.000000500'", "TIME '00:00:00.000001'").addRoundTrip("TIME '00:00:00.0000005000'", "TIME '00:00:00.000001'").addRoundTrip("TIME '00:00:00.00000050000'", "TIME '00:00:00.000001'").addRoundTrip("TIME '00:00:00.000000500000'", "TIME '00:00:00.000001'").addRoundTrip("TIME '00:00:00.0000009'", "TIME '00:00:00.000001'").addRoundTrip("TIME '00:00:00.00000099'", "TIME '00:00:00.000001'").addRoundTrip("TIME '00:00:00.000000999'", "TIME '00:00:00.000001'").addRoundTrip("TIME '00:00:00.0000009999'", "TIME '00:00:00.000001'").addRoundTrip("TIME '00:00:00.00000099999'", "TIME '00:00:00.000001'").addRoundTrip("TIME '00:00:00.000000999999'", "TIME '00:00:00.000001'").addRoundTrip("TIME '23:59:59.9999995'", "TIME '00:00:00.000000'").addRoundTrip("TIME '23:59:59.99999950'", "TIME '00:00:00.000000'").addRoundTrip("TIME '23:59:59.999999500'", "TIME '00:00:00.000000'").addRoundTrip("TIME '23:59:59.9999995000'", "TIME '00:00:00.000000'").addRoundTrip("TIME '23:59:59.99999950000'", "TIME '00:00:00.000000'").addRoundTrip("TIME '23:59:59.999999500000'", "TIME '00:00:00.000000'").addRoundTrip("TIME '23:59:59.9999999'", "TIME '00:00:00.000000'").addRoundTrip("TIME '23:59:59.99999999'", "TIME '00:00:00.000000'").addRoundTrip("TIME '23:59:59.999999999'", "TIME '00:00:00.000000'").addRoundTrip("TIME '23:59:59.9999999999'", "TIME '00:00:00.000000'").addRoundTrip("TIME '23:59:59.99999999999'", "TIME '00:00:00.000000'").addRoundTrip("TIME '23:59:59.999999999999'", "TIME '00:00:00.000000'").execute(this.getQueryRunner(), this.trinoCreateAsSelect(this.getSession(), "test_time_coercion")).execute(this.getQueryRunner(), this.trinoCreateAndInsert(this.getSession(), "test_time_coercion"));
    }

    @Test
    public void testTime24() {
        try (TestTable testTable = new TestTable((SqlExecutor)new JdbcSqlExecutor(this.postgreSqlServer.getJdbcUrl(), this.postgreSqlServer.getProperties()), "test_time_24", "(a time(0), b time(3), c time(6))", List.of("TIME '00:00:00', TIME '00:00:00.000', TIME '00:00:00.000000'", "TIME '23:59:59', TIME '23:59:59.999', TIME '23:59:59.999999'", "TIME '24:00:00', TIME '24:00:00.000', TIME '24:00:00.000000'"));){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT a, b, c FROM " + testTable.getName()))).matches("VALUES (TIME '00:00:00', TIME '00:00:00.000', TIME '00:00:00.000000'), (TIME '23:59:59', TIME '23:59:59.999', TIME '23:59:59.999999'), (TIME '23:59:59', TIME '23:59:59.999', TIME '23:59:59.999999')");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT count(*) FROM " + testTable.getName() + " WHERE a = TIME '23:59:59'"))).matches("VALUES BIGINT '2'").isNotFullyPushedDown(new Class[]{FilterNode.class});
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT count(*) FROM " + testTable.getName() + " WHERE b = TIME '23:59:59.999'"))).matches("VALUES BIGINT '2'").isNotFullyPushedDown(new Class[]{FilterNode.class});
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT count(*) FROM " + testTable.getName() + " WHERE c = TIME '23:59:59.999999'"))).matches("VALUES BIGINT '2'").isNotFullyPushedDown(new Class[]{FilterNode.class});
        }
    }

    @Test(dataProvider="sessionZonesDataProvider")
    public void testTimestamp(ZoneId sessionZone) {
        Session session = Session.builder((Session)this.getSession()).setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)sessionZone.getId())).build();
        SqlDataTypeTest.create().addRoundTrip("timestamp(3)", "TIMESTAMP '1958-01-01 13:18:03.123'", (Type)TimestampType.createTimestampType((int)3), "TIMESTAMP '1958-01-01 13:18:03.123'").addRoundTrip("timestamp(3)", "TIMESTAMP '2019-03-18 10:01:17.987'", (Type)TimestampType.createTimestampType((int)3), "TIMESTAMP '2019-03-18 10:01:17.987'").addRoundTrip("timestamp(3)", "TIMESTAMP '2018-10-28 01:33:17.456'", (Type)TimestampType.createTimestampType((int)3), "TIMESTAMP '2018-10-28 01:33:17.456'").addRoundTrip("timestamp(3)", "TIMESTAMP '2018-10-28 03:33:33.333'", (Type)TimestampType.createTimestampType((int)3), "TIMESTAMP '2018-10-28 03:33:33.333'").addRoundTrip("timestamp(3)", "TIMESTAMP '1970-01-01 00:00:00.000'", (Type)TimestampType.createTimestampType((int)3), "TIMESTAMP '1970-01-01 00:00:00.000'").addRoundTrip("timestamp(3)", "TIMESTAMP '1970-01-01 00:13:42.000'", (Type)TimestampType.createTimestampType((int)3), "TIMESTAMP '1970-01-01 00:13:42.000'").addRoundTrip("timestamp(3)", "TIMESTAMP '2018-04-01 02:13:55.123'", (Type)TimestampType.createTimestampType((int)3), "TIMESTAMP '2018-04-01 02:13:55.123'").addRoundTrip("timestamp(3)", "TIMESTAMP '2018-03-25 03:17:17.000'", (Type)TimestampType.createTimestampType((int)3), "TIMESTAMP '2018-03-25 03:17:17.000'").addRoundTrip("timestamp(3)", "TIMESTAMP '1986-01-01 00:13:07.000'", (Type)TimestampType.createTimestampType((int)3), "TIMESTAMP '1986-01-01 00:13:07.000'").addRoundTrip("timestamp(0)", "TIMESTAMP '1970-01-01 00:00:00'", (Type)TimestampType.createTimestampType((int)0), "TIMESTAMP '1970-01-01 00:00:00'").addRoundTrip("timestamp(1)", "TIMESTAMP '1970-01-01 00:00:00.1'", (Type)TimestampType.createTimestampType((int)1), "TIMESTAMP '1970-01-01 00:00:00.1'").addRoundTrip("timestamp(2)", "TIMESTAMP '1970-01-01 00:00:00.12'", (Type)TimestampType.createTimestampType((int)2), "TIMESTAMP '1970-01-01 00:00:00.12'").addRoundTrip("timestamp(3)", "TIMESTAMP '1970-01-01 00:00:00.123'", (Type)TimestampType.createTimestampType((int)3), "TIMESTAMP '1970-01-01 00:00:00.123'").addRoundTrip("timestamp(4)", "TIMESTAMP '1970-01-01 00:00:00.1234'", (Type)TimestampType.createTimestampType((int)4), "TIMESTAMP '1970-01-01 00:00:00.1234'").addRoundTrip("timestamp(5)", "TIMESTAMP '1970-01-01 00:00:00.12345'", (Type)TimestampType.createTimestampType((int)5), "TIMESTAMP '1970-01-01 00:00:00.12345'").addRoundTrip("timestamp(6)", "TIMESTAMP '1970-01-01 00:00:00.123456'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '1970-01-01 00:00:00.123456'").addRoundTrip("timestamp(6)", "TIMESTAMP '1969-12-31 23:59:59.123000'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '1969-12-31 23:59:59.123000'").addRoundTrip("timestamp(6)", "TIMESTAMP '1969-12-31 23:59:59.123456'", (Type)TimestampType.createTimestampType((int)6), "TIMESTAMP '1969-12-31 23:59:59.123456'").execute(this.getQueryRunner(), session, this.trinoCreateAsSelect(session, "test_timestamp")).execute(this.getQueryRunner(), session, this.trinoCreateAsSelect(this.getSession(), "test_timestamp")).execute(this.getQueryRunner(), session, this.trinoCreateAndInsert(session, "test_timestamp")).execute(this.getQueryRunner(), session, this.postgresCreateAndInsert("test_timestamp"));
    }

    @Test
    public void testTimestampCoercion() {
        SqlDataTypeTest.create().addRoundTrip("TIMESTAMP '1970-01-01 00:00:00'", "TIMESTAMP '1970-01-01 00:00:00'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.1'", "TIMESTAMP '1970-01-01 00:00:00.1'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.9'", "TIMESTAMP '1970-01-01 00:00:00.9'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.123'", "TIMESTAMP '1970-01-01 00:00:00.123'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.123000'", "TIMESTAMP '1970-01-01 00:00:00.123000'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.999'", "TIMESTAMP '1970-01-01 00:00:00.999'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.123456'", "TIMESTAMP '1970-01-01 00:00:00.123456'").addRoundTrip("TIMESTAMP '2020-09-27 12:34:56.1'", "TIMESTAMP '2020-09-27 12:34:56.1'").addRoundTrip("TIMESTAMP '2020-09-27 12:34:56.9'", "TIMESTAMP '2020-09-27 12:34:56.9'").addRoundTrip("TIMESTAMP '2020-09-27 12:34:56.123'", "TIMESTAMP '2020-09-27 12:34:56.123'").addRoundTrip("TIMESTAMP '2020-09-27 12:34:56.123000'", "TIMESTAMP '2020-09-27 12:34:56.123000'").addRoundTrip("TIMESTAMP '2020-09-27 12:34:56.999'", "TIMESTAMP '2020-09-27 12:34:56.999'").addRoundTrip("TIMESTAMP '2020-09-27 12:34:56.123456'", "TIMESTAMP '2020-09-27 12:34:56.123456'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.1234561'", "TIMESTAMP '1970-01-01 00:00:00.123456'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.123456499'", "TIMESTAMP '1970-01-01 00:00:00.123456'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.123456499999'", "TIMESTAMP '1970-01-01 00:00:00.123456'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.1234565'", "TIMESTAMP '1970-01-01 00:00:00.123457'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.111222333444'", "TIMESTAMP '1970-01-01 00:00:00.111222'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.9999995'", "TIMESTAMP '1970-01-01 00:00:01.000000'").addRoundTrip("TIMESTAMP '1970-01-01 23:59:59.9999995'", "TIMESTAMP '1970-01-02 00:00:00.000000'").addRoundTrip("TIMESTAMP '1969-12-31 23:59:59.9999995'", "TIMESTAMP '1970-01-01 00:00:00.000000'").addRoundTrip("TIMESTAMP '1969-12-31 23:59:59.999999499999'", "TIMESTAMP '1969-12-31 23:59:59.999999'").addRoundTrip("TIMESTAMP '1969-12-31 23:59:59.9999994'", "TIMESTAMP '1969-12-31 23:59:59.999999'").execute(this.getQueryRunner(), this.trinoCreateAsSelect(this.getSession(), "test_timestamp_coercion")).execute(this.getQueryRunner(), this.trinoCreateAndInsert(this.getSession(), "test_timestamp_coercion"));
    }

    @Test(dataProvider="sessionZonesDataProvider")
    public void testArrayTimestamp(ZoneId sessionZone) {
        Session session = Session.builder((Session)this.sessionWithArrayAsArray()).setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)sessionZone.getId())).build();
        SqlDataTypeTest.create().addRoundTrip("ARRAY(timestamp(3))", "ARRAY[TIMESTAMP '1958-01-01 13:18:03.123']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)3)), "ARRAY[TIMESTAMP '1958-01-01 13:18:03.123']").addRoundTrip("ARRAY(timestamp(3))", "ARRAY[TIMESTAMP '2019-03-18 10:01:17.987']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)3)), "ARRAY[TIMESTAMP '2019-03-18 10:01:17.987']").addRoundTrip("ARRAY(timestamp(3))", "ARRAY[TIMESTAMP '2018-10-28 01:33:17.456']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)3)), "ARRAY[TIMESTAMP '2018-10-28 01:33:17.456']").addRoundTrip("ARRAY(timestamp(3))", "ARRAY[TIMESTAMP '2018-10-28 03:33:33.333']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)3)), "ARRAY[TIMESTAMP '2018-10-28 03:33:33.333']").addRoundTrip("ARRAY(timestamp(3))", "ARRAY[TIMESTAMP '1970-01-01 00:00:00.000']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)3)), "ARRAY[TIMESTAMP '1970-01-01 00:00:00.000']").addRoundTrip("ARRAY(timestamp(3))", "ARRAY[TIMESTAMP '1970-01-01 00:13:42.000']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)3)), "ARRAY[TIMESTAMP '1970-01-01 00:13:42.000']").addRoundTrip("ARRAY(timestamp(3))", "ARRAY[TIMESTAMP '2018-04-01 02:13:55.123']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)3)), "ARRAY[TIMESTAMP '2018-04-01 02:13:55.123']").addRoundTrip("ARRAY(timestamp(3))", "ARRAY[TIMESTAMP '2018-03-25 03:17:17.000']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)3)), "ARRAY[TIMESTAMP '2018-03-25 03:17:17.000']").addRoundTrip("ARRAY(timestamp(3))", "ARRAY[TIMESTAMP '1986-01-01 00:13:07.000']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)3)), "ARRAY[TIMESTAMP '1986-01-01 00:13:07.000']").addRoundTrip("ARRAY(timestamp(1))", "ARRAY[TIMESTAMP '1970-01-01 01:01:01.1']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)1)), "ARRAY[TIMESTAMP '1970-01-01 01:01:01.1']").addRoundTrip("ARRAY(timestamp(2))", "ARRAY[TIMESTAMP '1970-01-01 01:01:01.12']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)2)), "ARRAY[TIMESTAMP '1970-01-01 01:01:01.12']").addRoundTrip("ARRAY(timestamp(3))", "ARRAY[TIMESTAMP '1970-01-01 01:01:01.123']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)3)), "ARRAY[TIMESTAMP '1970-01-01 01:01:01.123']").addRoundTrip("ARRAY(timestamp(4))", "ARRAY[TIMESTAMP '1970-01-01 01:01:01.1234']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)4)), "ARRAY[TIMESTAMP '1970-01-01 01:01:01.1234']").addRoundTrip("ARRAY(timestamp(5))", "ARRAY[TIMESTAMP '1970-01-01 01:01:01.12345']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)5)), "ARRAY[TIMESTAMP '1970-01-01 01:01:01.12345']").addRoundTrip("ARRAY(timestamp(6))", "ARRAY[TIMESTAMP '1970-01-01 01:01:01.123456']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)6)), "ARRAY[TIMESTAMP '1970-01-01 01:01:01.123456']").execute(this.getQueryRunner(), session, this.trinoCreateAsSelect(this.sessionWithArrayAsArray(), "test_array_timestamp"));
        SqlDataTypeTest.create().addRoundTrip("timestamp(3)[]", "ARRAY[TIMESTAMP '1958-01-01 13:18:03.123']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)3)), "ARRAY[TIMESTAMP '1958-01-01 13:18:03.123']").addRoundTrip("timestamp(3)[]", "ARRAY[TIMESTAMP '2019-03-18 10:01:17.987']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)3)), "ARRAY[TIMESTAMP '2019-03-18 10:01:17.987']").addRoundTrip("timestamp(3)[]", "ARRAY[TIMESTAMP '2018-10-28 01:33:17.456']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)3)), "ARRAY[TIMESTAMP '2018-10-28 01:33:17.456']").addRoundTrip("timestamp(3)[]", "ARRAY[TIMESTAMP '2018-10-28 03:33:33.333']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)3)), "ARRAY[TIMESTAMP '2018-10-28 03:33:33.333']").addRoundTrip("timestamp(3)[]", "ARRAY[TIMESTAMP '1970-01-01 00:00:00.000']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)3)), "ARRAY[TIMESTAMP '1970-01-01 00:00:00.000']").addRoundTrip("timestamp(3)[]", "ARRAY[TIMESTAMP '1970-01-01 00:13:42.000']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)3)), "ARRAY[TIMESTAMP '1970-01-01 00:13:42.000']").addRoundTrip("timestamp(3)[]", "ARRAY[TIMESTAMP '2018-04-01 02:13:55.123']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)3)), "ARRAY[TIMESTAMP '2018-04-01 02:13:55.123']").addRoundTrip("timestamp(3)[]", "ARRAY[TIMESTAMP '2018-03-25 03:17:17.000']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)3)), "ARRAY[TIMESTAMP '2018-03-25 03:17:17.000']").addRoundTrip("timestamp(3)[]", "ARRAY[TIMESTAMP '1986-01-01 00:13:07.000']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)3)), "ARRAY[TIMESTAMP '1986-01-01 00:13:07.000']").addRoundTrip("timestamp(1)[]", "ARRAY[TIMESTAMP '1970-01-01 01:01:01.1']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)1)), "ARRAY[TIMESTAMP '1970-01-01 01:01:01.1']").addRoundTrip("timestamp(2)[]", "ARRAY[TIMESTAMP '1970-01-01 01:01:01.12']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)2)), "ARRAY[TIMESTAMP '1970-01-01 01:01:01.12']").addRoundTrip("timestamp(3)[]", "ARRAY[TIMESTAMP '1970-01-01 01:01:01.123']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)3)), "ARRAY[TIMESTAMP '1970-01-01 01:01:01.123']").addRoundTrip("timestamp(4)[]", "ARRAY[TIMESTAMP '1970-01-01 01:01:01.1234']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)4)), "ARRAY[TIMESTAMP '1970-01-01 01:01:01.1234']").addRoundTrip("timestamp(5)[]", "ARRAY[TIMESTAMP '1970-01-01 01:01:01.12345']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)5)), "ARRAY[TIMESTAMP '1970-01-01 01:01:01.12345']").addRoundTrip("timestamp(6)[]", "ARRAY[TIMESTAMP '1970-01-01 01:01:01.123456']", (Type)new ArrayType((Type)TimestampType.createTimestampType((int)6)), "ARRAY[TIMESTAMP '1970-01-01 01:01:01.123456']").execute(this.getQueryRunner(), session, this.postgresCreateAndInsert("test_array_timestamp"));
    }

    @DataProvider
    public Object[][] sessionZonesDataProvider() {
        return new Object[][]{{ZoneOffset.UTC}, {this.jvmZone}, {this.vilnius}, {this.kathmandu}, {ZoneId.of(TestingSession.DEFAULT_TIME_ZONE_KEY.getId())}};
    }

    @Test(dataProvider="trueFalse", dataProviderClass=DataProviders.class)
    public void testTimestampWithTimeZone(boolean insertWithTrino) {
        DataTypeTest tests = DataTypeTest.create((boolean)true);
        for (int precision : List.of(Integer.valueOf(3), Integer.valueOf(6))) {
            DataType<ZonedDateTime> dataType = TestPostgreSqlTypeMapping.timestampWithTimeZoneDataType(precision, insertWithTrino);
            tests.addRoundTrip(dataType, (Object)this.epoch.atZone(ZoneOffset.UTC));
            tests.addRoundTrip(dataType, (Object)this.epoch.atZone(this.kathmandu));
            tests.addRoundTrip(dataType, (Object)this.epoch.atZone(this.fixedOffsetEast));
            tests.addRoundTrip(dataType, (Object)this.epoch.atZone(this.fixedOffsetWest));
            tests.addRoundTrip(dataType, (Object)this.beforeEpoch.atZone(ZoneOffset.UTC));
            tests.addRoundTrip(dataType, (Object)this.beforeEpoch.atZone(this.kathmandu));
            tests.addRoundTrip(dataType, (Object)this.beforeEpoch.atZone(this.fixedOffsetEast));
            tests.addRoundTrip(dataType, (Object)this.beforeEpoch.atZone(this.fixedOffsetWest));
            tests.addRoundTrip(dataType, (Object)this.afterEpoch.atZone(ZoneOffset.UTC));
            tests.addRoundTrip(dataType, (Object)this.afterEpoch.atZone(this.kathmandu));
            tests.addRoundTrip(dataType, (Object)this.afterEpoch.atZone(this.fixedOffsetEast));
            tests.addRoundTrip(dataType, (Object)this.afterEpoch.atZone(this.fixedOffsetWest));
            tests.addRoundTrip(dataType, (Object)this.afterEpoch.atZone(ZoneId.of("GMT")));
            tests.addRoundTrip(dataType, (Object)this.afterEpoch.atZone(ZoneId.of("UTC")));
            tests.addRoundTrip(dataType, (Object)this.afterEpoch.atZone(ZoneId.of("UTC+00:00")));
            tests.addRoundTrip(dataType, (Object)this.timeDoubledInJvmZone.atZone(ZoneOffset.UTC));
            tests.addRoundTrip(dataType, (Object)this.timeDoubledInJvmZone.atZone(this.jvmZone));
            tests.addRoundTrip(dataType, (Object)this.timeDoubledInJvmZone.atZone(this.kathmandu));
            tests.addRoundTrip(dataType, (Object)this.timeDoubledInVilnius.atZone(ZoneOffset.UTC));
            tests.addRoundTrip(dataType, (Object)this.timeDoubledInVilnius.atZone(this.vilnius));
            tests.addRoundTrip(dataType, (Object)this.timeDoubledInVilnius.atZone(this.kathmandu));
            tests.addRoundTrip(dataType, (Object)this.timeGapInJvmZone1.atZone(ZoneOffset.UTC));
            tests.addRoundTrip(dataType, (Object)this.timeGapInJvmZone1.atZone(this.kathmandu));
            tests.addRoundTrip(dataType, (Object)this.timeGapInJvmZone2.atZone(ZoneOffset.UTC));
            tests.addRoundTrip(dataType, (Object)this.timeGapInJvmZone2.atZone(this.kathmandu));
            tests.addRoundTrip(dataType, (Object)this.timeGapInVilnius.atZone(this.kathmandu));
            tests.addRoundTrip(dataType, (Object)this.timeGapInKathmandu.atZone(this.vilnius));
        }
        tests.addRoundTrip(TestPostgreSqlTypeMapping.timestampWithTimeZoneDataType(1, insertWithTrino), (Object)ZonedDateTime.of(2012, 1, 2, 3, 4, 5, 100000000, this.kathmandu));
        tests.addRoundTrip(TestPostgreSqlTypeMapping.timestampWithTimeZoneDataType(2, insertWithTrino), (Object)ZonedDateTime.of(2012, 1, 2, 3, 4, 5, 120000000, this.kathmandu));
        tests.addRoundTrip(TestPostgreSqlTypeMapping.timestampWithTimeZoneDataType(3, insertWithTrino), (Object)ZonedDateTime.of(2012, 1, 2, 3, 4, 5, 123000000, this.kathmandu));
        tests.addRoundTrip(TestPostgreSqlTypeMapping.timestampWithTimeZoneDataType(4, insertWithTrino), (Object)ZonedDateTime.of(2012, 1, 2, 3, 4, 5, 123400000, this.kathmandu));
        tests.addRoundTrip(TestPostgreSqlTypeMapping.timestampWithTimeZoneDataType(5, insertWithTrino), (Object)ZonedDateTime.of(2012, 1, 2, 3, 4, 5, 123450000, this.kathmandu));
        tests.addRoundTrip(TestPostgreSqlTypeMapping.timestampWithTimeZoneDataType(6, insertWithTrino), (Object)ZonedDateTime.of(2012, 1, 2, 3, 4, 5, 123456000, this.kathmandu));
        if (insertWithTrino) {
            tests.execute(this.getQueryRunner(), this.trinoCreateAsSelect("test_timestamp_with_time_zone"));
        } else {
            tests.execute(this.getQueryRunner(), this.postgresCreateAndInsert("test_timestamp_with_time_zone"));
        }
    }

    @Test
    public void testTimestampWithTimeZoneCoercion() {
        SqlDataTypeTest.create().addRoundTrip("TIMESTAMP '1970-01-01 00:00:00 UTC'", "TIMESTAMP '1970-01-01 00:00:00 UTC'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.1 UTC'", "TIMESTAMP '1970-01-01 00:00:00.1 UTC'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.9 UTC'", "TIMESTAMP '1970-01-01 00:00:00.9 UTC'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.123 UTC'", "TIMESTAMP '1970-01-01 00:00:00.123 UTC'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.123000 UTC'", "TIMESTAMP '1970-01-01 00:00:00.123000 UTC'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.999 UTC'", "TIMESTAMP '1970-01-01 00:00:00.999 UTC'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.123456 UTC'", "TIMESTAMP '1970-01-01 00:00:00.123456 UTC'").addRoundTrip("TIMESTAMP '2020-09-27 12:34:56.1 UTC'", "TIMESTAMP '2020-09-27 12:34:56.1 UTC'").addRoundTrip("TIMESTAMP '2020-09-27 12:34:56.9 UTC'", "TIMESTAMP '2020-09-27 12:34:56.9 UTC'").addRoundTrip("TIMESTAMP '2020-09-27 12:34:56.123 UTC'", "TIMESTAMP '2020-09-27 12:34:56.123 UTC'").addRoundTrip("TIMESTAMP '2020-09-27 12:34:56.123000 UTC'", "TIMESTAMP '2020-09-27 12:34:56.123000 UTC'").addRoundTrip("TIMESTAMP '2020-09-27 12:34:56.999 UTC'", "TIMESTAMP '2020-09-27 12:34:56.999 UTC'").addRoundTrip("TIMESTAMP '2020-09-27 12:34:56.123456 UTC'", "TIMESTAMP '2020-09-27 12:34:56.123456 UTC'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.1234561 UTC'", "TIMESTAMP '1970-01-01 00:00:00.123456 UTC'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.123456499 UTC'", "TIMESTAMP '1970-01-01 00:00:00.123456 UTC'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.123456499999 UTC'", "TIMESTAMP '1970-01-01 00:00:00.123456 UTC'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.1234565 UTC'", "TIMESTAMP '1970-01-01 00:00:00.123457 UTC'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.111222333444 UTC'", "TIMESTAMP '1970-01-01 00:00:00.111222 UTC'").addRoundTrip("TIMESTAMP '1970-01-01 00:00:00.9999995 UTC'", "TIMESTAMP '1970-01-01 00:00:01.000000 UTC'").addRoundTrip("TIMESTAMP '1970-01-01 23:59:59.9999995 UTC'", "TIMESTAMP '1970-01-02 00:00:00.000000 UTC'").addRoundTrip("TIMESTAMP '1969-12-31 23:59:59.9999995 UTC'", "TIMESTAMP '1970-01-01 00:00:00.000000 UTC'").addRoundTrip("TIMESTAMP '1969-12-31 23:59:59.999999499999 UTC'", "TIMESTAMP '1969-12-31 23:59:59.999999 UTC'").addRoundTrip("TIMESTAMP '1969-12-31 23:59:59.9999994 UTC'", "TIMESTAMP '1969-12-31 23:59:59.999999 UTC'").execute(this.getQueryRunner(), this.trinoCreateAsSelect(this.getSession(), "test_timestamp_tz_coercion")).execute(this.getQueryRunner(), this.trinoCreateAndInsert(this.getSession(), "test_timestamp_tz_coercion"));
    }

    @Test(dataProvider="trueFalse", dataProviderClass=DataProviders.class)
    public void testArrayTimestampWithTimeZone(boolean insertWithTrino) {
        DataTypeTest tests = DataTypeTest.create();
        for (int precision : List.of(Integer.valueOf(3), Integer.valueOf(6))) {
            DataType<List<ZonedDateTime>> dataType = TestPostgreSqlTypeMapping.arrayOfTimestampWithTimeZoneDataType(precision, insertWithTrino);
            tests.addRoundTrip(dataType, Arrays.asList(this.epoch.atZone(ZoneOffset.UTC), this.epoch.atZone(this.kathmandu)));
            tests.addRoundTrip(dataType, Arrays.asList(this.beforeEpoch.atZone(this.kathmandu), this.beforeEpoch.atZone(ZoneOffset.UTC)));
            tests.addRoundTrip(dataType, Arrays.asList(this.afterEpoch.atZone(ZoneOffset.UTC), this.afterEpoch.atZone(this.kathmandu)));
            tests.addRoundTrip(dataType, Arrays.asList(this.timeDoubledInJvmZone.atZone(ZoneOffset.UTC)));
            tests.addRoundTrip(dataType, Arrays.asList(this.timeDoubledInJvmZone.atZone(this.kathmandu)));
            tests.addRoundTrip(dataType, Arrays.asList(this.timeDoubledInVilnius.atZone(ZoneOffset.UTC), this.timeDoubledInVilnius.atZone(this.vilnius), this.timeDoubledInVilnius.atZone(this.kathmandu)));
            tests.addRoundTrip(dataType, Arrays.asList(this.timeGapInJvmZone1.atZone(ZoneOffset.UTC), this.timeGapInJvmZone1.atZone(this.kathmandu)));
            tests.addRoundTrip(dataType, Arrays.asList(this.timeGapInJvmZone2.atZone(ZoneOffset.UTC), this.timeGapInJvmZone2.atZone(this.kathmandu)));
            tests.addRoundTrip(dataType, Arrays.asList(this.timeGapInVilnius.atZone(this.kathmandu)));
            tests.addRoundTrip(dataType, Arrays.asList(this.timeGapInKathmandu.atZone(this.vilnius)));
            if (insertWithTrino) continue;
            tests.addRoundTrip(dataType, Arrays.asList(this.timeDoubledInJvmZone.atZone(this.jvmZone)));
        }
        tests.addRoundTrip(TestPostgreSqlTypeMapping.arrayOfTimestampWithTimeZoneDataType(1, insertWithTrino), Arrays.asList(ZonedDateTime.of(2012, 1, 2, 3, 4, 5, 100000000, this.kathmandu)));
        tests.addRoundTrip(TestPostgreSqlTypeMapping.arrayOfTimestampWithTimeZoneDataType(2, insertWithTrino), Arrays.asList(ZonedDateTime.of(2012, 1, 2, 3, 4, 5, 120000000, this.kathmandu)));
        tests.addRoundTrip(TestPostgreSqlTypeMapping.arrayOfTimestampWithTimeZoneDataType(3, insertWithTrino), Arrays.asList(ZonedDateTime.of(2012, 1, 2, 3, 4, 5, 123000000, this.kathmandu)));
        tests.addRoundTrip(TestPostgreSqlTypeMapping.arrayOfTimestampWithTimeZoneDataType(4, insertWithTrino), Arrays.asList(ZonedDateTime.of(2012, 1, 2, 3, 4, 5, 123400000, this.kathmandu)));
        tests.addRoundTrip(TestPostgreSqlTypeMapping.arrayOfTimestampWithTimeZoneDataType(5, insertWithTrino), Arrays.asList(ZonedDateTime.of(2012, 1, 2, 3, 4, 5, 123450000, this.kathmandu)));
        tests.addRoundTrip(TestPostgreSqlTypeMapping.arrayOfTimestampWithTimeZoneDataType(6, insertWithTrino), Arrays.asList(ZonedDateTime.of(2012, 1, 2, 3, 4, 5, 123456000, this.kathmandu)));
        if (insertWithTrino) {
            tests.execute(this.getQueryRunner(), this.sessionWithArrayAsArray(), this.trinoCreateAsSelect(this.sessionWithArrayAsArray(), "test_array_timestamp_with_time_zone"));
        } else {
            tests.execute(this.getQueryRunner(), this.sessionWithArrayAsArray(), this.postgresCreateAndInsert("test_array_timestamp_with_time_zone"));
        }
    }

    @Test
    public void testJson() {
        SqlDataTypeTest.create().addRoundTrip("json", "JSON '{}'", (Type)JsonType.JSON, "JSON '{}'").addRoundTrip("json", "NULL", (Type)JsonType.JSON, "CAST(NULL AS JSON)").addRoundTrip("json", "JSON 'null'", (Type)JsonType.JSON, "JSON 'null'").addRoundTrip("json", "JSON '123.4'", (Type)JsonType.JSON, "JSON '123.4'").addRoundTrip("json", "JSON '\"abc\"'", (Type)JsonType.JSON, "JSON '\"abc\"'").addRoundTrip("json", "JSON '\"text with '' apostrophes\"'", (Type)JsonType.JSON, "JSON '\"text with '' apostrophes\"'").addRoundTrip("json", "JSON '\"\"'", (Type)JsonType.JSON, "JSON '\"\"'").addRoundTrip("json", "JSON '{\"a\":1,\"b\":2}'", (Type)JsonType.JSON, "JSON '{\"a\":1,\"b\":2}'").addRoundTrip("json", "JSON '{\"a\":[1,2,3],\"b\":{\"aa\":11,\"bb\":[{\"a\":1,\"b\":2},{\"a\":0}]}}'", (Type)JsonType.JSON, "JSON '{\"a\":[1,2,3],\"b\":{\"aa\":11,\"bb\":[{\"a\":1,\"b\":2},{\"a\":0}]}}'").addRoundTrip("json", "JSON '[]'", (Type)JsonType.JSON, "JSON '[]'").execute(this.getQueryRunner(), this.postgresCreateAndInsert("postgresql_test_json")).execute(this.getQueryRunner(), this.trinoCreateAsSelect("trino_test_json"));
    }

    @Test
    public void testJsonb() {
        SqlDataTypeTest.create().addRoundTrip("jsonb", "JSON '{}'", (Type)JsonType.JSON, "JSON '{}'").addRoundTrip("jsonb", "NULL", (Type)JsonType.JSON, "CAST(NULL AS JSON)").addRoundTrip("jsonb", "JSON 'null'", (Type)JsonType.JSON, "JSON 'null'").addRoundTrip("jsonb", "JSON '123.4'", (Type)JsonType.JSON, "JSON '123.4'").addRoundTrip("jsonb", "JSON '\"abc\"'", (Type)JsonType.JSON, "JSON '\"abc\"'").addRoundTrip("jsonb", "JSON '\"text with '' apostrophes\"'", (Type)JsonType.JSON, "JSON '\"text with '' apostrophes\"'").addRoundTrip("jsonb", "JSON '\"\"'", (Type)JsonType.JSON, "JSON '\"\"'").addRoundTrip("jsonb", "JSON '{\"a\":1,\"b\":2}'", (Type)JsonType.JSON, "JSON '{\"a\":1,\"b\":2}'").addRoundTrip("jsonb", "JSON '{\"a\":[1,2,3],\"b\":{\"aa\":11,\"bb\":[{\"a\":1,\"b\":2},{\"a\":0}]}}'", (Type)JsonType.JSON, "JSON '{\"a\":[1,2,3],\"b\":{\"aa\":11,\"bb\":[{\"a\":1,\"b\":2},{\"a\":0}]}}'").addRoundTrip("jsonb", "JSON '[]'", (Type)JsonType.JSON, "JSON '[]'").execute(this.getQueryRunner(), this.postgresCreateAndInsert("postgresql_test_jsonb"));
    }

    @Test
    public void testHstore() {
        this.hstoreTestCases(this.hstoreDataType()).execute(this.getQueryRunner(), this.postgresCreateAndInsert("postgresql_test_hstore"));
        this.hstoreTestCases(this.varcharMapDataType()).execute(this.getQueryRunner(), this.postgresCreateTrinoInsert("postgresql_test_hstore"));
    }

    private DataTypeTest hstoreTestCases(DataType<Map<String, String>> varcharMapDataType) {
        return DataTypeTest.create().addRoundTrip(varcharMapDataType, null).addRoundTrip(varcharMapDataType, (Object)ImmutableMap.of()).addRoundTrip(varcharMapDataType, (Object)ImmutableMap.of((Object)"key1", (Object)"value1")).addRoundTrip(varcharMapDataType, (Object)ImmutableMap.of((Object)"key1", (Object)"value1", (Object)"key2", (Object)"value2", (Object)"key3", (Object)"value3")).addRoundTrip(varcharMapDataType, (Object)ImmutableMap.of((Object)"key1", (Object)" \" ", (Object)"key2", (Object)" ' ", (Object)"key3", (Object)" ]) ")).addRoundTrip(varcharMapDataType, Collections.singletonMap("key1", null));
    }

    @Test
    public void testUuid() {
        SqlDataTypeTest.create().addRoundTrip("uuid", "UUID '00000000-0000-0000-0000-000000000000'", (Type)UuidType.UUID, "UUID '00000000-0000-0000-0000-000000000000'").addRoundTrip("uuid", "UUID '123e4567-e89b-12d3-a456-426655440000'", (Type)UuidType.UUID, "UUID '123e4567-e89b-12d3-a456-426655440000'").execute(this.getQueryRunner(), this.postgresCreateAndInsert("postgresql_test_uuid")).execute(this.getQueryRunner(), this.trinoCreateAsSelect("trino_test_uuid"));
    }

    @Test
    public void testMoney() {
        SqlDataTypeTest.create().addRoundTrip("money", "NULL", (Type)VarcharType.createUnboundedVarcharType(), "CAST(NULL AS VARCHAR)").addRoundTrip("money", "10.0", (Type)VarcharType.createUnboundedVarcharType(), "CAST('$10.00' AS VARCHAR)").addRoundTrip("money", "10.54", (Type)VarcharType.createUnboundedVarcharType(), "CAST('$10.54' AS VARCHAR)").addRoundTrip("money", "1.000000042E7", (Type)VarcharType.createUnboundedVarcharType(), "CAST('$10,000,000.42' AS VARCHAR)").execute(this.getQueryRunner(), this.postgresCreateAndInsert("trino_test_money"));
    }

    private void testUnsupportedDataTypeAsIgnored(String dataTypeName, String databaseValue) {
        this.testUnsupportedDataTypeAsIgnored(this.getSession(), dataTypeName, databaseValue);
    }

    private void testUnsupportedDataTypeAsIgnored(Session session, String dataTypeName, String databaseValue) {
        JdbcSqlExecutor jdbcSqlExecutor = new JdbcSqlExecutor(this.postgreSqlServer.getJdbcUrl(), this.postgreSqlServer.getProperties());
        try (TestTable table = new TestTable((SqlExecutor)jdbcSqlExecutor, "unsupported_type", String.format("(key varchar(5), unsupported_column %s)", dataTypeName), (List)ImmutableList.of((Object)"'1', NULL", (Object)("'2', " + databaseValue)));){
            this.assertQuery(session, "SELECT * FROM " + table.getName(), "VALUES 1, 2");
            this.assertQuery(session, "DESC " + table.getName(), "VALUES ('key', 'varchar(5)','', '')");
            this.assertUpdate(session, String.format("INSERT INTO %s VALUES '3'", table.getName()), 1L);
            this.assertQuery(session, "SELECT * FROM " + table.getName(), "VALUES '1', '2', '3'");
        }
    }

    private void testUnsupportedDataTypeConvertedToVarchar(Session session, String dataTypeName, String internalDataTypeName, String databaseValue, String trinoValue) {
        JdbcSqlExecutor jdbcSqlExecutor = new JdbcSqlExecutor(this.postgreSqlServer.getJdbcUrl(), this.postgreSqlServer.getProperties());
        try (TestTable table = new TestTable((SqlExecutor)jdbcSqlExecutor, "unsupported_type", String.format("(key varchar(5), unsupported_column %s)", dataTypeName), (List)ImmutableList.of((Object)"1, NULL", (Object)("2, " + databaseValue)));){
            Session convertToVarchar = Session.builder((Session)session).setCatalogSessionProperty("postgresql", "unsupported_type_handling", UnsupportedTypeHandling.CONVERT_TO_VARCHAR.name()).build();
            this.assertQuery(convertToVarchar, "SELECT * FROM " + table.getName(), String.format("VALUES ('1', NULL), ('2', %s)", trinoValue));
            this.assertQuery(convertToVarchar, String.format("SELECT key FROM %s WHERE unsupported_column = %s", table.getName(), trinoValue), "VALUES '2'");
            this.assertQuery(convertToVarchar, "DESC " + table.getName(), "VALUES ('key', 'varchar(5)', '', ''), ('unsupported_column', 'varchar', '', '')");
            this.assertUpdate(convertToVarchar, String.format("INSERT INTO %s (key, unsupported_column) VALUES ('3', NULL)", table.getName()), 1L);
            this.assertQueryFails(convertToVarchar, String.format("INSERT INTO %s (key, unsupported_column) VALUES ('4', %s)", table.getName(), trinoValue), "\\QUnderlying type that is mapped to VARCHAR is not supported for INSERT: " + internalDataTypeName);
            this.assertUpdate(convertToVarchar, String.format("INSERT INTO %s (key) VALUES '5'", table.getName()), 1L);
            this.assertQuery(convertToVarchar, "SELECT * FROM " + table.getName(), String.format("VALUES ('1', NULL), ('2', %s), ('3', NULL), ('5', NULL)", trinoValue));
        }
    }

    public static DataType<ZonedDateTime> timestampWithTimeZoneDataType(int precision, boolean insertWithTrino) {
        if (insertWithTrino) {
            return TestPostgreSqlTypeMapping.trinoTimestampWithTimeZoneDataType(precision);
        }
        return TestPostgreSqlTypeMapping.postgreSqlTimestampWithTimeZoneDataType(precision);
    }

    public static DataType<ZonedDateTime> trinoTimestampWithTimeZoneDataType(int precision) {
        return DataType.dataType((String)String.format("timestamp(%d) with time zone", precision), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)precision), zonedDateTime -> DateTimeFormatter.ofPattern("'TIMESTAMP '''uuuu-MM-dd HH:mm:ss.SSSSSS VV''").format((TemporalAccessor)zonedDateTime), zonedDateTime -> zonedDateTime.withZoneSameInstant(ZoneId.of("UTC")));
    }

    public static DataType<ZonedDateTime> postgreSqlTimestampWithTimeZoneDataType(int precision) {
        return DataType.dataType((String)String.format("timestamp(%d) with time zone", precision), (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)precision), zonedDateTime -> {
            String pattern = String.format("'TIMESTAMP (%d) WITH TIME ZONE '''uuuu-MM-dd HH:mm:ss.SSSSSS VV''", precision);
            return DateTimeFormatter.ofPattern(pattern).format(zonedDateTime.withZoneSameInstant(ZoneOffset.UTC));
        }, zonedDateTime -> DateTimeFormatter.ofPattern("'TIMESTAMP '''uuuu-MM-dd HH:mm:ss.SSSSSS VV''").format((TemporalAccessor)zonedDateTime), zonedDateTime -> zonedDateTime.withZoneSameInstant(ZoneId.of("UTC")));
    }

    public static DataType<List<ZonedDateTime>> arrayOfTimestampWithTimeZoneDataType(int precision, boolean insertWithTrino) {
        if (insertWithTrino) {
            return TestPostgreSqlTypeMapping.arrayDataType(TestPostgreSqlTypeMapping.trinoTimestampWithTimeZoneDataType(precision));
        }
        return TestPostgreSqlTypeMapping.arrayDataType(TestPostgreSqlTypeMapping.postgreSqlTimestampWithTimeZoneDataType(precision), String.format("timestamptz(%d)[]", precision));
    }

    private DataType<Map<String, String>> hstoreDataType() {
        return DataType.dataType((String)"hstore", (Type)this.getQueryRunner().getTypeManager().getType(TypeSignature.mapType((TypeSignature)VarcharType.VARCHAR.getTypeSignature(), (TypeSignature)VarcharType.VARCHAR.getTypeSignature())), TestPostgreSqlTypeMapping::hstoreLiteral);
    }

    private static String hstoreLiteral(Map<String, String> value) {
        return value.entrySet().stream().flatMap(entry -> Stream.of((String)entry.getKey(), (String)entry.getValue())).map(input -> input == null ? "null" : DataType.formatStringLiteral((String)input)).collect(Collectors.joining(",", "hstore(ARRAY[", "]::varchar[])"));
    }

    private DataType<Map<String, String>> varcharMapDataType() {
        return DataType.dataType((String)"hstore", (Type)this.getQueryRunner().getTypeManager().getType(TypeSignature.mapType((TypeSignature)VarcharType.VARCHAR.getTypeSignature(), (TypeSignature)VarcharType.VARCHAR.getTypeSignature())), value -> {
            List formatted = (List)value.entrySet().stream().flatMap(entry -> Stream.of((String)entry.getKey(), (String)entry.getValue())).map(string -> {
                if (string == null) {
                    return "null";
                }
                return DataType.formatStringLiteral((String)string);
            }).collect(ImmutableList.toImmutableList());
            ImmutableList.Builder keys = ImmutableList.builder();
            ImmutableList.Builder values = ImmutableList.builder();
            for (int i = 0; i < formatted.size(); i += 2) {
                keys.add((Object)((String)formatted.get(i)));
                values.add((Object)((String)formatted.get(i + 1)));
            }
            return String.format("MAP(ARRAY[%s], ARRAY[%s])", Joiner.on((char)',').join((Iterable)keys.build()), Joiner.on((char)',').join((Iterable)values.build()));
        });
    }

    private Session sessionWithArrayAsArray() {
        return Session.builder((Session)this.getSession()).setSystemProperty("postgresql.array_mapping", PostgreSqlConfig.ArrayMapping.AS_ARRAY.name()).build();
    }

    private Session sessionWithDecimalMappingAllowOverflow(RoundingMode roundingMode, int scale) {
        return Session.builder((Session)this.getSession()).setCatalogSessionProperty("postgresql", "decimal_mapping", DecimalConfig.DecimalMapping.ALLOW_OVERFLOW.name()).setCatalogSessionProperty("postgresql", "decimal_rounding_mode", roundingMode.name()).setCatalogSessionProperty("postgresql", "decimal_default_scale", Integer.valueOf(scale).toString()).build();
    }

    private Session sessionWithDecimalMappingStrict(UnsupportedTypeHandling unsupportedTypeHandling) {
        return Session.builder((Session)this.getSession()).setCatalogSessionProperty("postgresql", "decimal_mapping", DecimalConfig.DecimalMapping.STRICT.name()).setCatalogSessionProperty("postgresql", "unsupported_type_handling", unsupportedTypeHandling.name()).build();
    }

    private DataSetup trinoCreateAsSelect(String tableNamePrefix) {
        return this.trinoCreateAsSelect(this.getSession(), tableNamePrefix);
    }

    private DataSetup trinoCreateAsSelect(Session session, String tableNamePrefix) {
        return new CreateAsSelectDataSetup((SqlExecutor)new TrinoSqlExecutor(this.getQueryRunner(), session), tableNamePrefix);
    }

    private DataSetup trinoCreateAndInsert(Session session, String tableNamePrefix) {
        return new CreateAndInsertDataSetup((SqlExecutor)new TrinoSqlExecutor(this.getQueryRunner(), session), tableNamePrefix);
    }

    private DataSetup postgresCreateAndInsert(String tableNamePrefix) {
        return new CreateAndInsertDataSetup((SqlExecutor)new JdbcSqlExecutor(this.postgreSqlServer.getJdbcUrl(), this.postgreSqlServer.getProperties()), tableNamePrefix);
    }

    private DataSetup postgresCreateTrinoInsert(String tableNamePrefix) {
        return new CreateAndTrinoInsertDataSetup((SqlExecutor)new JdbcSqlExecutor(this.postgreSqlServer.getJdbcUrl(), this.postgreSqlServer.getProperties()), new TrinoSqlExecutor(this.getQueryRunner()), tableNamePrefix);
    }

    private static void checkIsGap(ZoneId zone, LocalDateTime dateTime) {
        Verify.verify((boolean)TestPostgreSqlTypeMapping.isGap(zone, dateTime), (String)"Expected %s to be a gap in %s", (Object)dateTime, (Object)zone);
    }

    private static boolean isGap(ZoneId zone, LocalDateTime dateTime) {
        return zone.getRules().getValidOffsets(dateTime).isEmpty();
    }

    private static void checkIsDoubled(ZoneId zone, LocalDateTime dateTime) {
        Verify.verify((zone.getRules().getValidOffsets(dateTime).size() == 2 ? 1 : 0) != 0, (String)"Expected %s to be doubled in %s", (Object)dateTime, (Object)zone);
    }
}

