/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.postgresql;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MoreCollectors;
import io.airlift.slice.Slices;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.plugin.jdbc.BaseJdbcConnectorTest;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.RemoteDatabaseEvent;
import io.trino.plugin.postgresql.PostgreSqlConfig;
import io.trino.plugin.postgresql.PostgreSqlQueryRunner;
import io.trino.plugin.postgresql.TestingPostgreSqlServer;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.plan.TopNNode;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingConnectorBehavior;
import io.trino.testing.sql.JdbcSqlExecutor;
import io.trino.testing.sql.SqlExecutor;
import io.trino.testing.sql.TestTable;
import io.trino.testing.sql.TestView;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestPostgreSqlConnectorTest
extends BaseJdbcConnectorTest {
    protected TestingPostgreSqlServer postgreSqlServer;

    protected QueryRunner createQueryRunner() throws Exception {
        this.postgreSqlServer = (TestingPostgreSqlServer)this.closeAfterClass(new TestingPostgreSqlServer());
        return PostgreSqlQueryRunner.createPostgreSqlQueryRunner(this.postgreSqlServer, Map.of(), Map.of(), REQUIRED_TPCH_TABLES);
    }

    @BeforeClass
    public void setExtensions() throws SQLException {
        this.execute("CREATE EXTENSION file_fdw");
    }

    protected boolean hasBehavior(TestingConnectorBehavior connectorBehavior) {
        switch (connectorBehavior) {
            case SUPPORTS_PREDICATE_PUSHDOWN_WITH_VARCHAR_INEQUALITY: 
            case SUPPORTS_JOIN_PUSHDOWN_WITH_VARCHAR_INEQUALITY: {
                return false;
            }
            case SUPPORTS_TOPN_PUSHDOWN: 
            case SUPPORTS_TOPN_PUSHDOWN_WITH_VARCHAR: {
                return true;
            }
            case SUPPORTS_AGGREGATION_PUSHDOWN_STDDEV: 
            case SUPPORTS_AGGREGATION_PUSHDOWN_VARIANCE: 
            case SUPPORTS_AGGREGATION_PUSHDOWN_COVARIANCE: 
            case SUPPORTS_AGGREGATION_PUSHDOWN_CORRELATION: 
            case SUPPORTS_AGGREGATION_PUSHDOWN_REGRESSION: 
            case SUPPORTS_AGGREGATION_PUSHDOWN_COUNT_DISTINCT: {
                return true;
            }
            case SUPPORTS_JOIN_PUSHDOWN: {
                return true;
            }
            case SUPPORTS_COMMENT_ON_TABLE: {
                return false;
            }
            case SUPPORTS_ARRAY: {
                return new PostgreSqlConfig().getArrayMapping() != PostgreSqlConfig.ArrayMapping.DISABLED;
            }
            case SUPPORTS_RENAME_TABLE_ACROSS_SCHEMAS: {
                return false;
            }
            case SUPPORTS_CANCELLATION: {
                return true;
            }
        }
        return super.hasBehavior(connectorBehavior);
    }

    protected TestTable createTableWithDefaultColumns() {
        return new TestTable((SqlExecutor)new JdbcSqlExecutor(this.postgreSqlServer.getJdbcUrl(), this.postgreSqlServer.getProperties()), "table", "(col_required BIGINT NOT NULL,col_nullable BIGINT,col_default BIGINT DEFAULT 43,col_nonnull_default BIGINT NOT NULL DEFAULT 42,col_required2 BIGINT NOT NULL)");
    }

    protected TestTable createTableWithUnsupportedColumn() {
        return new TestTable(this.onRemoteDatabase(), "test_unsupported_column_present", "(one bigint, two decimal(50,0), three varchar(10))");
    }

    @Test
    public void testDropTable() {
        this.assertUpdate("CREATE TABLE test_drop AS SELECT 123 x", 1L);
        Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_drop"));
        this.assertUpdate("DROP TABLE test_drop");
        Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_drop"));
    }

    @Test
    public void testViews() throws Exception {
        this.execute("CREATE OR REPLACE VIEW test_view AS SELECT * FROM orders");
        Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_view"));
        this.assertQuery("SELECT orderkey FROM test_view", "SELECT orderkey FROM orders");
        this.execute("DROP VIEW IF EXISTS test_view");
    }

    @Test
    public void testPostgreSqlMaterializedView() throws Exception {
        this.execute("CREATE MATERIALIZED VIEW test_mv as SELECT * FROM orders");
        Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_mv"));
        this.assertQuery("SELECT orderkey FROM test_mv", "SELECT orderkey FROM orders");
        this.execute("DROP MATERIALIZED VIEW test_mv");
    }

    @Test
    public void testForeignTable() throws Exception {
        this.execute("CREATE SERVER devnull FOREIGN DATA WRAPPER file_fdw");
        this.execute("CREATE FOREIGN TABLE test_ft (x bigint) SERVER devnull OPTIONS (filename '/dev/null')");
        Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_ft"));
        this.computeActual("SELECT * FROM test_ft");
        this.execute("DROP FOREIGN TABLE test_ft");
        this.execute("DROP SERVER devnull");
    }

    @Test
    public void testSystemTable() {
        Assertions.assertThat((Iterable)this.computeActual("SHOW TABLES FROM pg_catalog").getOnlyColumnAsSet()).contains(new Object[]{"pg_tables", "pg_views", "pg_type", "pg_index"});
        Assertions.assertThat((Iterable)this.computeActual("SELECT typname FROM pg_catalog.pg_type").getOnlyColumnAsSet()).contains(new Object[]{"char", "text"});
        Assertions.assertThat((Stream)this.computeActual("SELECT tablename FROM pg_catalog.pg_tables WHERE schemaname = 'tpch'").getOnlyColumn()).contains(new Object[]{"orders"});
    }

    @Test
    public void testPartitionedTables() throws Exception {
        try (TestTable testTable = new TestTable(this.postgreSqlServer::execute, "test_part_tbl", "(id int NOT NULL, payload varchar, logdate date NOT NULL) PARTITION BY RANGE (logdate)");){
            String values202111 = "(1, 'A', '2021-11-01'), (2, 'B', '2021-11-25')";
            String values202112 = "(3, 'C', '2021-12-01')";
            this.execute(String.format("CREATE TABLE %s_2021_11 PARTITION OF %s FOR VALUES FROM ('2021-11-01') TO ('2021-12-01')", testTable.getName(), testTable.getName()));
            this.execute(String.format("CREATE TABLE %s_2021_12 PARTITION OF %s FOR VALUES FROM ('2021-12-01') TO ('2022-01-01')", testTable.getName(), testTable.getName()));
            this.execute(String.format("INSERT INTO %s VALUES %s ,%s", testTable.getName(), values202111, values202112));
            Assertions.assertThat((Iterable)this.computeActual("SHOW TABLES").getOnlyColumnAsSet()).contains(new Object[]{testTable.getName(), testTable.getName() + "_2021_11", testTable.getName() + "_2021_12"});
            this.assertQuery(String.format("SELECT * FROM %s", testTable.getName()), String.format("VALUES %s, %s", values202111, values202112));
            this.assertQuery(String.format("SELECT * FROM %s_2021_12", testTable.getName()), "VALUES " + values202112);
        }
        testTable = new TestTable(this.postgreSqlServer::execute, "test_part_tbl", "(id int NOT NULL, type varchar, logdate varchar) PARTITION BY LIST (type)");
        try {
            String valuesA = "(1, 'A', '2021-11-11'), (4, 'A', '2021-12-25')";
            String valuesB = "(3, 'B', '2021-12-12'), (2, 'B', '2021-12-28')";
            this.execute(String.format("CREATE TABLE %s_a PARTITION OF %s FOR VALUES IN ('A')", testTable.getName(), testTable.getName()));
            this.execute(String.format("CREATE TABLE %s_b PARTITION OF %s FOR VALUES IN ('B')", testTable.getName(), testTable.getName()));
            this.assertUpdate(String.format("INSERT INTO %s VALUES %s ,%s", testTable.getName(), valuesA, valuesB), 4L);
            Assertions.assertThat((Iterable)this.computeActual("SHOW TABLES").getOnlyColumnAsSet()).contains(new Object[]{testTable.getName(), testTable.getName() + "_a", testTable.getName() + "_b"});
            this.assertQuery(String.format("SELECT * FROM %s", testTable.getName()), String.format("VALUES %s, %s", valuesA, valuesB));
            this.assertQuery(String.format("SELECT * FROM %s_a", testTable.getName()), "VALUES " + valuesA);
        }
        finally {
            testTable.close();
        }
    }

    @Test
    public void testTableWithNoSupportedColumns() throws Exception {
        String unsupportedDataType = "interval";
        String supportedDataType = "varchar(5)";
        try (AutoCloseable ignore1 = this.withTable("no_supported_columns", String.format("(c %s)", unsupportedDataType));
             AutoCloseable ignore2 = this.withTable("supported_columns", String.format("(good %s)", supportedDataType));
             AutoCloseable ignore3 = this.withTable("no_columns", "()");){
            Assertions.assertThat((Iterable)this.computeActual("SHOW TABLES").getOnlyColumnAsSet()).contains(new Object[]{"orders", "no_supported_columns", "supported_columns", "no_columns"});
            this.assertQueryFails("SELECT c FROM no_supported_columns", "\\QTable 'tpch.no_supported_columns' has no supported columns (all 1 columns are not supported)");
            this.assertQueryFails("SELECT * FROM no_supported_columns", "\\QTable 'tpch.no_supported_columns' has no supported columns (all 1 columns are not supported)");
            this.assertQueryFails("SELECT 'a' FROM no_supported_columns", "\\QTable 'tpch.no_supported_columns' has no supported columns (all 1 columns are not supported)");
            this.assertQueryFails("SELECT c FROM no_columns", "\\QTable 'tpch.no_columns' has no supported columns (all 0 columns are not supported)");
            this.assertQueryFails("SELECT * FROM no_columns", "\\QTable 'tpch.no_columns' has no supported columns (all 0 columns are not supported)");
            this.assertQueryFails("SELECT 'a' FROM no_columns", "\\QTable 'tpch.no_columns' has no supported columns (all 0 columns are not supported)");
            this.assertQueryFails("SELECT c FROM non_existent", ".* Table .*tpch.non_existent.* does not exist");
            this.assertQueryFails("SELECT * FROM non_existent", ".* Table .*tpch.non_existent.* does not exist");
            this.assertQueryFails("SELECT 'a' FROM non_existent", ".* Table .*tpch.non_existent.* does not exist");
            this.assertQueryFails("SHOW COLUMNS FROM no_supported_columns", "\\QTable 'tpch.no_supported_columns' has no supported columns (all 1 columns are not supported)");
            this.assertQueryFails("SHOW COLUMNS FROM no_columns", "\\QTable 'tpch.no_columns' has no supported columns (all 0 columns are not supported)");
            Assertions.assertThat((Stream)this.computeActual("SHOW TABLES").getOnlyColumn()).contains(new Object[]{"orders", "no_supported_columns", "supported_columns", "no_columns"});
            Assertions.assertThat((Stream)this.computeActual("SELECT table_name FROM information_schema.tables WHERE table_schema = 'tpch'").getOnlyColumn()).contains(new Object[]{"orders", "no_supported_columns", "supported_columns", "no_columns"});
            this.assertQuery("SHOW COLUMNS FROM supported_columns", "VALUES ('good', 'varchar(5)', '', '')");
            this.computeActual("SELECT column_name FROM information_schema.columns WHERE table_schema = 'tpch'");
        }
    }

    @Test
    public void testInsertWithFailureDoesNotLeaveBehindOrphanedTable() throws Exception {
        String schemaName = String.format("tmp_schema_%s", UUID.randomUUID().toString().replaceAll("-", ""));
        try (AutoCloseable schema = this.withSchema(schemaName);
             AutoCloseable table = this.withTable(String.format("%s.test_cleanup", schemaName), "(x INTEGER)");){
            this.assertQuery(String.format("SELECT table_name FROM information_schema.tables WHERE table_schema = '%s'", schemaName), "VALUES 'test_cleanup'");
            this.execute(String.format("ALTER TABLE %s.test_cleanup ADD CHECK (x > 0)", schemaName));
            this.assertQueryFails(String.format("INSERT INTO %s.test_cleanup (x) VALUES (0)", schemaName), "ERROR: new row .* violates check constraint [\\s\\S]*");
            this.assertQuery(String.format("SELECT table_name FROM information_schema.tables WHERE table_schema = '%s'", schemaName), "VALUES 'test_cleanup'");
        }
    }

    @Test
    public void testPredicatePushdown() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT regionkey, nationkey, name FROM nation WHERE name = 'ROMANIA'"))).matches("VALUES (BIGINT '3', BIGINT '19', CAST('ROMANIA' AS varchar(25)))").isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT regionkey, nationkey, name FROM nation WHERE name BETWEEN 'POLAND' AND 'RPA'"))).matches("VALUES (BIGINT '3', BIGINT '19', CAST('ROMANIA' AS varchar(25)))").isNotFullyPushedDown(new Class[]{FilterNode.class});
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT regionkey, nationkey, name FROM nation WHERE name IN ('POLAND', 'ROMANIA', 'VIETNAM')"))).matches("VALUES (BIGINT '3', BIGINT '19', CAST('ROMANIA' AS varchar(25))), (BIGINT '2', BIGINT '21', CAST('VIETNAM' AS varchar(25)))").isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(Session.builder((Session)this.getSession()).setCatalogSessionProperty("postgresql", "domain_compaction_threshold", "1").build(), "SELECT regionkey, nationkey, name FROM nation WHERE name IN ('POLAND', 'ROMANIA', 'VIETNAM')"))).matches("VALUES (BIGINT '3', BIGINT '19', CAST('ROMANIA' AS varchar(25))), (BIGINT '2', BIGINT '21', CAST('VIETNAM' AS varchar(25)))").isNotFullyPushedDown(PlanMatchPattern.node(FilterNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan(tableHandle -> ((JdbcTableHandle)tableHandle).getConstraint().isAll(), (TupleDomain)TupleDomain.all(), (Map)ImmutableMap.of())}));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT regionkey, nationkey, name FROM nation WHERE name = 'romania'"))).returnsEmptyResult().isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT regionkey, nationkey, name FROM nation WHERE nationkey = 19"))).matches("VALUES (BIGINT '3', BIGINT '19', CAST('ROMANIA' AS varchar(25)))").isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(Session.builder((Session)this.getSession()).setCatalogSessionProperty("postgresql", "domain_compaction_threshold", "1").build(), "SELECT regionkey, nationkey, name FROM nation WHERE nationkey IN (19, 21)"))).matches("VALUES (BIGINT '3', BIGINT '19', CAST('ROMANIA' AS varchar(25))), (BIGINT '2', BIGINT '21', CAST('VIETNAM' AS varchar(25)))").isNotFullyPushedDown(new Class[]{FilterNode.class});
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT regionkey, nationkey, name FROM nation WHERE nationkey BETWEEN 18.5 AND 19.5"))).matches("VALUES (BIGINT '3', BIGINT '19', CAST('ROMANIA' AS varchar(25)))").isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT orderkey FROM orders WHERE orderdate = DATE '1992-09-29'"))).matches("VALUES BIGINT '1250', 34406, 38436, 57570").isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM (SELECT regionkey, sum(nationkey) FROM nation GROUP BY regionkey) WHERE regionkey = 3"))).matches("VALUES (BIGINT '3', BIGINT '77')").isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT regionkey, sum(nationkey) FROM nation GROUP BY regionkey HAVING sum(nationkey) = 77"))).matches("VALUES (BIGINT '3', BIGINT '77')").isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT orderkey FROM (SELECT * FROM orders ORDER BY orderdate DESC, orderkey ASC LIMIT 10)WHERE orderdate = DATE '1998-08-01'"))).matches("VALUES BIGINT '27588', 22403, 37735").ordered().isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT custkey FROM (SELECT SUM(totalprice) as sum, custkey, COUNT(*) as cnt FROM orders GROUP BY custkey order by sum desc limit 10) WHERE cnt > 30"))).matches("VALUES BIGINT '643', 898").ordered().isFullyPushedDown();
        Session joinPushdownEnabled = this.joinPushdownEnabled(this.getSession());
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(joinPushdownEnabled, "SELECT c.name, n.name FROM customer c JOIN nation n ON c.custkey = n.nationkey WHERE acctbal > 8000"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(joinPushdownEnabled, "SELECT c.name, n.name FROM customer c JOIN nation n ON c.custkey = n.nationkey WHERE address = 'TcGe5gaZNgVePxU5kRrvXBfkasDTea'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(joinPushdownEnabled, "SELECT c.name, n.name FROM customer c JOIN nation n ON c.custkey = n.nationkey WHERE address < 'TcGe5gaZNgVePxU5kRrvXBfkasDTea'"))).isNotFullyPushedDown(PlanMatchPattern.node(JoinNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])}), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])})}));
    }

    @Test
    public void testStringPushdownWithCollate() {
        Session session = Session.builder((Session)this.getSession()).setCatalogSessionProperty("postgresql", "enable_string_pushdown_with_collate", "true").build();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, "SELECT regionkey, nationkey, name FROM nation WHERE name BETWEEN 'POLAND' AND 'RPA'"))).matches("VALUES (BIGINT '3', BIGINT '19', CAST('ROMANIA' AS varchar(25)))").isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(Session.builder((Session)session).setCatalogSessionProperty("postgresql", "domain_compaction_threshold", "1").build(), "SELECT regionkey, nationkey, name FROM nation WHERE name IN ('POLAND', 'ROMANIA', 'VIETNAM')"))).matches("VALUES (BIGINT '3', BIGINT '19', CAST('ROMANIA' AS varchar(25))), (BIGINT '2', BIGINT '21', CAST('VIETNAM' AS varchar(25)))").isNotFullyPushedDown(PlanMatchPattern.node(FilterNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan(tableHandle -> {
            TupleDomain constraint = ((JdbcTableHandle)tableHandle).getConstraint();
            ColumnHandle nameColumn = (ColumnHandle)((Map)constraint.getDomains().orElseThrow()).keySet().stream().map(JdbcColumnHandle.class::cast).filter(column -> column.getColumnName().equals("name")).collect(MoreCollectors.onlyElement());
            return ((Domain)((Map)constraint.getDomains().get()).get(nameColumn)).getValues().getRanges().getOrderedRanges().equals(ImmutableList.of((Object)Range.range((Type)VarcharType.createVarcharType((int)25), (Object)Slices.utf8Slice((String)"POLAND"), (boolean)true, (Object)Slices.utf8Slice((String)"VIETNAM"), (boolean)true)));
        }, (TupleDomain)TupleDomain.all(), (Map)ImmutableMap.of())}));
        Session joinPushdownEnabled = this.joinPushdownEnabled(session);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(joinPushdownEnabled, "SELECT c.name, n.name FROM customer c JOIN nation n ON c.custkey = n.nationkey WHERE address < 'TcGe5gaZNgVePxU5kRrvXBfkasDTea'"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(joinPushdownEnabled, "SELECT c.name, n.name FROM customer c JOIN nation n ON c.address = n.name"))).isNotFullyPushedDown(PlanMatchPattern.node(JoinNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])}), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])})}));
    }

    @Test
    public void testDecimalPredicatePushdown() throws Exception {
        try (AutoCloseable ignore = this.withTable("test_decimal_pushdown", "(short_decimal decimal(9, 3), long_decimal decimal(30, 10))");){
            this.execute("INSERT INTO test_decimal_pushdown VALUES (123.321, 123456789.987654321)");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_decimal_pushdown WHERE short_decimal <= 124"))).matches("VALUES (CAST(123.321 AS decimal(9,3)), CAST(123456789.987654321 AS decimal(30, 10)))").isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_decimal_pushdown WHERE short_decimal <= 124"))).matches("VALUES (CAST(123.321 AS decimal(9,3)), CAST(123456789.987654321 AS decimal(30, 10)))").isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_decimal_pushdown WHERE long_decimal <= 123456790"))).matches("VALUES (CAST(123.321 AS decimal(9,3)), CAST(123456789.987654321 AS decimal(30, 10)))").isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_decimal_pushdown WHERE short_decimal <= 123.321"))).matches("VALUES (CAST(123.321 AS decimal(9,3)), CAST(123456789.987654321 AS decimal(30, 10)))").isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_decimal_pushdown WHERE long_decimal <= 123456789.987654321"))).matches("VALUES (CAST(123.321 AS decimal(9,3)), CAST(123456789.987654321 AS decimal(30, 10)))").isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_decimal_pushdown WHERE short_decimal = 123.321"))).matches("VALUES (CAST(123.321 AS decimal(9,3)), CAST(123456789.987654321 AS decimal(30, 10)))").isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_decimal_pushdown WHERE long_decimal = 123456789.987654321"))).matches("VALUES (CAST(123.321 AS decimal(9,3)), CAST(123456789.987654321 AS decimal(30, 10)))").isFullyPushedDown();
        }
    }

    @Test
    public void testCharPredicatePushdown() throws Exception {
        try (AutoCloseable ignore = this.withTable("test_char_pushdown", "(char_1 char(1), char_5 char(5), char_10 char(10))");){
            this.execute("INSERT INTO test_char_pushdown VALUES('0', '0'    , '0'         ),('1', '12345', '1234567890')");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_char_pushdown WHERE char_1 = '0' AND char_5 = '0'"))).matches("VALUES (CHAR'0', CHAR'0    ', CHAR'0         ')").isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_char_pushdown WHERE char_5 = CHAR'12345' AND char_10 = '1234567890'"))).matches("VALUES (CHAR'1', CHAR'12345', CHAR'1234567890')").isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM test_char_pushdown WHERE char_10 = CHAR'0'"))).matches("VALUES (CHAR'0', CHAR'0    ', CHAR'0         ')").isFullyPushedDown();
        }
    }

    @Test
    public void testCharTrailingSpace() throws Exception {
        this.execute("CREATE TABLE char_trailing_space (x char(10))");
        this.assertUpdate("INSERT INTO char_trailing_space VALUES ('test')", 1L);
        this.assertQuery("SELECT * FROM char_trailing_space WHERE x = char 'test'", "VALUES 'test'");
        this.assertQuery("SELECT * FROM char_trailing_space WHERE x = char 'test  '", "VALUES 'test'");
        this.assertQuery("SELECT * FROM char_trailing_space WHERE x = char 'test        '", "VALUES 'test'");
        Assert.assertEquals((int)this.getQueryRunner().execute("SELECT * FROM char_trailing_space WHERE x = char ' test'").getRowCount(), (int)0);
        this.assertUpdate("DROP TABLE char_trailing_space");
    }

    protected String errorMessageForInsertIntoNotNullColumn(String columnName) {
        return String.format("(?s).*null value in column \"%s\" violates not-null constraint.*", columnName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTopNWithEnum() {
        String enumType = "test_enum_" + TestTable.randomTableSuffix();
        this.postgreSqlServer.execute("CREATE TYPE " + enumType + " AS ENUM ('A', 'b', 'B', 'a')");
        try (TestTable testTable = new TestTable(this.postgreSqlServer::execute, "test_case_sensitive_topn_pushdown_with_enums", "(an_enum " + enumType + ", a_bigint bigint)", List.of("'A', 1", "'B', 2", "'a', 3", "'b', 4"));){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT a_bigint FROM " + testTable.getName() + " ORDER BY an_enum ASC LIMIT 2"))).ordered().isNotFullyPushedDown(new Class[]{TopNNode.class});
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT a_bigint FROM " + testTable.getName() + " ORDER BY an_enum DESC LIMIT 2"))).ordered().isNotFullyPushedDown(new Class[]{TopNNode.class});
        }
        finally {
            this.postgreSqlServer.execute("DROP TYPE " + enumType);
        }
    }

    @Test
    public void testNativeLargeIn() throws SQLException {
        this.execute("SELECT count(*) FROM orders WHERE " + this.getLongInClause(0, 500000));
    }

    @Test
    public void testNativeMultipleInClauses() throws SQLException {
        String longInClauses = IntStream.range(0, 20).mapToObj(value -> this.getLongInClause(value * 10000, 10000)).collect(Collectors.joining(" OR "));
        this.execute("SELECT count(*) FROM orders WHERE " + longInClauses);
    }

    @Test
    public void testTimestampColumnAndTimestampWithTimeZoneConstant() throws Exception {
        String tableName = "test_timestamptz_unwrap_cast" + TestTable.randomTableSuffix();
        try (AutoCloseable ignored = this.withTable(tableName, "(id integer, ts_col timestamp(6))");){
            this.execute("INSERT INTO " + tableName + " (id, ts_col) VALUES (1, timestamp '2020-01-01 01:01:01.000'),(2, timestamp '2019-01-01 01:01:01.000')");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT id FROM %s WHERE ts_col >= TIMESTAMP '2019-01-01 00:00:00 %s'", tableName, this.getSession().getTimeZoneKey().getId())))).matches("VALUES 1, 2").isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT id FROM %s WHERE ts_col >= TIMESTAMP '2019-01-01 00:00:00 %s'", tableName, "UTC")))).matches("VALUES 1").isFullyPushedDown();
        }
    }

    private String getLongInClause(int start, int length) {
        String longValues = IntStream.range(start, start + length).mapToObj(Integer::toString).collect(Collectors.joining(", "));
        return "orderkey IN (" + longValues + ")";
    }

    private AutoCloseable withSchema(String schema) throws Exception {
        this.execute(String.format("CREATE SCHEMA %s", schema));
        return () -> {
            try {
                this.execute(String.format("DROP SCHEMA %s", schema));
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        };
    }

    @Deprecated
    private AutoCloseable withTable(String tableName, String tableDefinition) throws Exception {
        this.execute(String.format("CREATE TABLE %s%s", tableName, tableDefinition));
        return () -> {
            try {
                this.execute(String.format("DROP TABLE %s", tableName));
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        };
    }

    protected SqlExecutor onRemoteDatabase() {
        return sql -> {
            try {
                this.execute(sql);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        };
    }

    private void execute(String sql) throws SQLException {
        try (Connection connection = DriverManager.getConnection(this.postgreSqlServer.getJdbcUrl(), this.postgreSqlServer.getProperties());
             Statement statement = connection.createStatement();){
            statement.execute(sql);
        }
    }

    protected List<RemoteDatabaseEvent> getRemoteDatabaseEvents() {
        return this.postgreSqlServer.getRemoteDatabaseEvents();
    }

    protected TestView createSleepingView(Duration minimalQueryDuration) {
        long secondsToSleep = Math.round(minimalQueryDuration.convertTo(TimeUnit.SECONDS).getValue() + 1.0);
        return new TestView(this.onRemoteDatabase(), "test_sleeping_view", String.format("SELECT 1 FROM pg_sleep(%d)", secondsToSleep));
    }
}

