/*
 * Decompiled with CFR 0.152.
 */
package io.trino.array;

import io.airlift.slice.SizeOf;
import io.trino.array.ObjectBigArray;
import io.trino.array.ReferenceCountMap;
import io.trino.spi.block.SqlMap;

public final class SqlMapBigArray {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(SqlMapBigArray.class);
    private final ObjectBigArray<SqlMap> array;
    private final ReferenceCountMap trackedObjects = new ReferenceCountMap();
    private long sizeOfBlocks;

    public SqlMapBigArray() {
        this.array = new ObjectBigArray();
    }

    public SqlMapBigArray(SqlMap sqlMap) {
        this.array = new ObjectBigArray(sqlMap);
    }

    public long sizeOf() {
        return (long)INSTANCE_SIZE + this.array.sizeOf() + this.sizeOfBlocks + this.trackedObjects.sizeOf();
    }

    public SqlMap get(long index) {
        return this.array.get(index);
    }

    public void set(long index, SqlMap value) {
        SqlMap previousValue = this.array.getAndSet(index, value);
        if (previousValue != null) {
            previousValue.retainedBytesForEachPart((object, size) -> {
                if (previousValue == object) {
                    this.sizeOfBlocks -= size;
                    return;
                }
                if (this.trackedObjects.decrementAndGet(object) == 0) {
                    this.sizeOfBlocks -= size;
                }
            });
        }
        if (value != null) {
            value.retainedBytesForEachPart((object, size) -> {
                if (value == object) {
                    this.sizeOfBlocks += size;
                    return;
                }
                if (this.trackedObjects.incrementAndGet(object) == 1) {
                    this.sizeOfBlocks += size;
                }
            });
        }
    }

    public void ensureCapacity(long length) {
        this.array.ensureCapacity(length);
    }
}

