/*
 * Decompiled with CFR 0.152.
 */
package io.trino.array;

import io.airlift.slice.SizeOf;
import io.trino.array.ObjectBigArray;
import io.trino.array.ReferenceCountMap;
import io.trino.spi.block.SqlRow;

public final class SqlRowBigArray {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(SqlRowBigArray.class);
    private final ObjectBigArray<SqlRow> array;
    private final ReferenceCountMap trackedObjects = new ReferenceCountMap();
    private long sizeOfBlocks;

    public SqlRowBigArray() {
        this.array = new ObjectBigArray();
    }

    public SqlRowBigArray(SqlRow sqlRow) {
        this.array = new ObjectBigArray(sqlRow);
    }

    public long sizeOf() {
        return (long)INSTANCE_SIZE + this.array.sizeOf() + this.sizeOfBlocks + this.trackedObjects.sizeOf();
    }

    public SqlRow get(long index) {
        return this.array.get(index);
    }

    public void set(long index, SqlRow value) {
        SqlRow currentValue = this.array.get(index);
        if (currentValue != null) {
            currentValue.retainedBytesForEachPart((object, size) -> {
                if (currentValue == object) {
                    this.sizeOfBlocks -= size;
                    return;
                }
                if (this.trackedObjects.decrementAndGet(object) == 0) {
                    this.sizeOfBlocks -= size;
                }
            });
        }
        if (value != null) {
            value.retainedBytesForEachPart((object, size) -> {
                if (value == object) {
                    this.sizeOfBlocks += size;
                    return;
                }
                if (this.trackedObjects.incrementAndGet(object) == 1) {
                    this.sizeOfBlocks += size;
                }
            });
        }
        this.array.set(index, value);
    }

    public void ensureCapacity(long length) {
        this.array.ensureCapacity(length);
    }
}

