/*
 * Decompiled with CFR 0.152.
 */
package io.ticofab.androidgpxparser.parser.domain;

import io.ticofab.androidgpxparser.parser.domain.Metadata;
import io.ticofab.androidgpxparser.parser.domain.Route;
import io.ticofab.androidgpxparser.parser.domain.Track;
import io.ticofab.androidgpxparser.parser.domain.WayPoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Gpx {
    private final String mVersion;
    private final String mCreator;
    private final Metadata mMetadata;
    private final List<WayPoint> mWayPoints;
    private final List<Route> mRoutes;
    private final List<Track> mTracks;

    private Gpx(Builder builder) {
        this.mVersion = builder.mVersion;
        this.mCreator = builder.mCreator;
        this.mMetadata = builder.mMetadata;
        this.mWayPoints = Collections.unmodifiableList(new ArrayList(builder.mWayPoints));
        this.mRoutes = Collections.unmodifiableList(new ArrayList(builder.mRoutes));
        this.mTracks = Collections.unmodifiableList(new ArrayList(builder.mTracks));
    }

    public String getVersion() {
        return this.mVersion;
    }

    public String getCreator() {
        return this.mCreator;
    }

    public Metadata getMetadata() {
        return this.mMetadata;
    }

    public List<WayPoint> getWayPoints() {
        return this.mWayPoints;
    }

    public List<Route> getRoutes() {
        return this.mRoutes;
    }

    public List<Track> getTracks() {
        return this.mTracks;
    }

    public static class Builder {
        private List<WayPoint> mWayPoints;
        private List<Route> mRoutes;
        private List<Track> mTracks;
        private String mVersion;
        private String mCreator;
        private Metadata mMetadata;

        public Builder setTracks(List<Track> tracks) {
            this.mTracks = tracks;
            return this;
        }

        public Builder setWayPoints(List<WayPoint> wayPoints) {
            this.mWayPoints = wayPoints;
            return this;
        }

        public Builder setRoutes(List<Route> routes) {
            this.mRoutes = routes;
            return this;
        }

        public Builder setVersion(String version) {
            this.mVersion = version;
            return this;
        }

        public Builder setCreator(String creator) {
            this.mCreator = creator;
            return this;
        }

        public Builder setMetadata(Metadata mMetadata) {
            this.mMetadata = mMetadata;
            return this;
        }

        public Gpx build() {
            return new Gpx(this);
        }
    }
}

