/*
 * Decompiled with CFR 0.152.
 */
package io.ticofab.androidgpxparser.parser.domain;

import io.ticofab.androidgpxparser.parser.domain.Route;
import io.ticofab.androidgpxparser.parser.domain.Track;
import io.ticofab.androidgpxparser.parser.domain.WayPoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Gpx {
    private final List<WayPoint> mWayPoints;
    private final List<Route> mRoutes;
    private final List<Track> mTracks;

    private Gpx(Builder builder) {
        this.mWayPoints = Collections.unmodifiableList(new ArrayList(builder.mWayPoints));
        this.mRoutes = Collections.unmodifiableList(new ArrayList(builder.mRoutes));
        this.mTracks = Collections.unmodifiableList(new ArrayList(builder.mTracks));
    }

    public List<WayPoint> getWayPoints() {
        return this.mWayPoints;
    }

    public List<Route> getRoutes() {
        return this.mRoutes;
    }

    public List<Track> getTracks() {
        return this.mTracks;
    }

    public static class Builder {
        private List<WayPoint> mWayPoints;
        private List<Route> mRoutes;
        private List<Track> mTracks;

        public Builder setTracks(List<Track> tracks) {
            this.mTracks = tracks;
            return this;
        }

        public Builder setWayPoints(List<WayPoint> wayPoints) {
            this.mWayPoints = wayPoints;
            return this;
        }

        public Builder setRoutes(List<Route> routes) {
            this.mRoutes = routes;
            return this;
        }

        public Gpx build() {
            return new Gpx(this);
        }
    }
}

