/*
 * Decompiled with CFR 0.152.
 */
package io.ticofab.androidgpxparser.parser;

import android.util.Xml;
import io.ticofab.androidgpxparser.parser.domain.Gpx;
import io.ticofab.androidgpxparser.parser.domain.Track;
import io.ticofab.androidgpxparser.parser.domain.TrackPoint;
import io.ticofab.androidgpxparser.parser.domain.TrackSegment;
import io.ticofab.androidgpxparser.parser.task.FetchAndParseGPXTask;
import io.ticofab.androidgpxparser.parser.task.GpxFetchedAndParsed;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.joda.time.DateTime;
import org.joda.time.format.ISODateTimeFormat;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class GPXParser {
    static final String TAG_GPX = "gpx";
    static final String TAG_TRACK = "trk";
    static final String TAG_SEGMENT = "trkseg";
    static final String TAG_POINT = "trkpt";
    static final String TAG_LAT = "lat";
    static final String TAG_LON = "lon";
    static final String TAG_ELEVATION = "ele";
    static final String TAG_TIME = "time";
    static final String ns = null;

    public void parse(String gpxUrl, GpxFetchedAndParsed listener) {
        new FetchAndParseGPXTask(gpxUrl, listener).execute(new Void[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Gpx parse(InputStream in) throws XmlPullParserException, IOException {
        try {
            XmlPullParser parser = Xml.newPullParser();
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            parser.setInput(in, null);
            parser.nextTag();
            Gpx gpx = this.readGpx(parser);
            return gpx;
        }
        finally {
            in.close();
        }
    }

    Gpx readGpx(XmlPullParser parser) throws XmlPullParserException, IOException {
        ArrayList<Track> tracks = new ArrayList<Track>();
        parser.require(2, ns, TAG_GPX);
        block6: while (parser.next() != 3) {
            String name;
            if (parser.getEventType() != 2) continue;
            switch (name = parser.getName()) {
                case "trk": {
                    tracks.add(this.readTrack(parser));
                    continue block6;
                }
            }
            this.skip(parser);
        }
        parser.require(3, ns, TAG_GPX);
        return new Gpx.Builder().setTracks(tracks).build();
    }

    Track readTrack(XmlPullParser parser) throws XmlPullParserException, IOException {
        ArrayList<TrackSegment> segments = new ArrayList<TrackSegment>();
        parser.require(2, ns, TAG_TRACK);
        block6: while (parser.next() != 3) {
            String name;
            if (parser.getEventType() != 2) continue;
            switch (name = parser.getName()) {
                case "trkseg": {
                    segments.add(this.readSegment(parser));
                    continue block6;
                }
            }
            this.skip(parser);
        }
        parser.require(3, ns, TAG_TRACK);
        return new Track.Builder().setTrackSegments(segments).build();
    }

    TrackSegment readSegment(XmlPullParser parser) throws IOException, XmlPullParserException {
        ArrayList<TrackPoint> points = new ArrayList<TrackPoint>();
        parser.require(2, ns, TAG_SEGMENT);
        block6: while (parser.next() != 3) {
            String name;
            if (parser.getEventType() != 2) continue;
            switch (name = parser.getName()) {
                case "trkpt": {
                    points.add(this.readPoint(parser));
                    continue block6;
                }
            }
            this.skip(parser);
        }
        parser.require(3, ns, TAG_SEGMENT);
        return new TrackSegment.Builder().setTrackPoints(points).build();
    }

    TrackPoint readPoint(XmlPullParser parser) throws IOException, XmlPullParserException {
        parser.require(2, ns, TAG_POINT);
        Double lat = Double.valueOf(parser.getAttributeValue(null, TAG_LAT));
        Double lng = Double.valueOf(parser.getAttributeValue(null, TAG_LON));
        Double ele = null;
        DateTime time = null;
        block8: while (parser.next() != 3) {
            String name;
            if (parser.getEventType() != 2) continue;
            switch (name = parser.getName()) {
                case "ele": {
                    ele = this.readElevation(parser);
                    continue block8;
                }
                case "time": {
                    time = this.readTime(parser);
                    continue block8;
                }
            }
            this.skip(parser);
        }
        parser.require(3, ns, TAG_POINT);
        return new TrackPoint.Builder().setElevation(ele).setLatitude(lat).setLongitude(lng).setTime(time).build();
    }

    Double readElevation(XmlPullParser parser) throws IOException, XmlPullParserException {
        parser.require(2, ns, TAG_ELEVATION);
        Double ele = Double.valueOf(this.readText(parser));
        parser.require(3, ns, TAG_ELEVATION);
        return ele;
    }

    DateTime readTime(XmlPullParser parser) throws IOException, XmlPullParserException {
        parser.require(2, ns, TAG_TIME);
        DateTime time = ISODateTimeFormat.dateTimeParser().parseDateTime(this.readText(parser));
        parser.require(3, ns, TAG_TIME);
        return time;
    }

    String readText(XmlPullParser parser) throws IOException, XmlPullParserException {
        String result = "";
        if (parser.next() == 4) {
            result = parser.getText();
            parser.nextTag();
        }
        return result;
    }

    void skip(XmlPullParser parser) throws XmlPullParserException, IOException {
        if (parser.getEventType() != 2) {
            throw new IllegalStateException();
        }
        int depth = 1;
        while (depth != 0) {
            switch (parser.next()) {
                case 3: {
                    --depth;
                    break;
                }
                case 2: {
                    ++depth;
                }
            }
        }
    }
}

