/*
 * Decompiled with CFR 0.152.
 */
package io.ticofab.androidgpxparser.parser.domain;

import org.joda.time.DateTime;

public class TrackPoint {
    private final Double mLatitude;
    private final Double mLongitude;
    private final Double mElevation;
    private final DateTime mTime;

    public TrackPoint(Builder builder) {
        this.mLatitude = builder.mLatitude;
        this.mLongitude = builder.mLongitude;
        this.mElevation = builder.mElevation;
        this.mTime = builder.mTime;
    }

    public Double getElevation() {
        return this.mElevation;
    }

    public Double getLatitude() {
        return this.mLatitude;
    }

    public Double getLongitude() {
        return this.mLongitude;
    }

    public DateTime getTime() {
        return this.mTime;
    }

    public static class Builder {
        private Double mLatitude;
        private Double mLongitude;
        private Double mElevation;
        private DateTime mTime;

        public Builder setLatitude(Double latitude) {
            this.mLatitude = latitude;
            return this;
        }

        public Builder setLongitude(Double longitude) {
            this.mLongitude = longitude;
            return this;
        }

        public Builder setElevation(Double elevation) {
            this.mElevation = elevation;
            return this;
        }

        public Builder setTime(DateTime time) {
            this.mTime = time;
            return this;
        }

        public TrackPoint build() {
            return new TrackPoint(this);
        }
    }
}

