/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.wordnik.swagger.models.Swagger;
import com.wordnik.swagger.models.auth.AuthorizationValue;
import com.wordnik.swagger.util.Json;
import com.wordnik.swagger.util.Yaml;
import io.swagger.parser.SwaggerParserExtension;
import io.swagger.parser.util.RemoteUrl;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.Validate;

public class Swagger20Parser
implements SwaggerParserExtension {
    @Override
    public Swagger read(String location, List<AuthorizationValue> auths) throws IOException {
        System.out.println("reading from " + location);
        try {
            String data = location.toLowerCase().startsWith("http") ? RemoteUrl.urlToString(location, auths) : FileUtils.readFileToString((File)new File(location), (String)"UTF-8");
            return this.convertToSwagger(data);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            if (System.getProperty("debugParser") != null) {
                e.printStackTrace();
            }
            return null;
        }
    }

    private Swagger convertToSwagger(String data) throws IOException {
        if (data != null) {
            ObjectMapper mapper = data.trim().startsWith("{") ? Json.mapper() : Yaml.mapper();
            JsonNode rootNode = mapper.readTree(data);
            JsonNode swaggerNode = rootNode.get("swagger");
            if (swaggerNode == null) {
                return null;
            }
            return (Swagger)mapper.convertValue((Object)rootNode, Swagger.class);
        }
        return null;
    }

    public Swagger parse(String data) throws IOException {
        Validate.notEmpty((CharSequence)data, (String)"data must not be null!", (Object[])new Object[0]);
        return this.convertToSwagger(data);
    }

    @Override
    public Swagger read(JsonNode node) throws IOException {
        if (node == null) {
            return null;
        }
        return (Swagger)Json.mapper().convertValue((Object)node, Swagger.class);
    }
}

