/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser.processors;

import io.swagger.models.Operation;
import io.swagger.models.RefResponse;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.Parameter;
import io.swagger.parser.ResolverCache;
import io.swagger.parser.processors.ParameterProcessor;
import io.swagger.parser.processors.ResponseProcessor;
import java.util.List;
import java.util.Map;

public class OperationProcessor {
    private final ParameterProcessor parameterProcessor;
    private final ResponseProcessor responseProcessor;
    private final ResolverCache cache;

    public OperationProcessor(ResolverCache cache, Swagger swagger) {
        this.cache = cache;
        this.parameterProcessor = new ParameterProcessor(cache, swagger);
        this.responseProcessor = new ResponseProcessor(cache, swagger);
    }

    public void processOperation(Operation operation) {
        List<Parameter> processedOperationParameters = this.parameterProcessor.processParameters(operation.getParameters());
        operation.setParameters(processedOperationParameters);
        Map responses = operation.getResponses();
        if (responses != null) {
            for (String responseCode : responses.keySet()) {
                RefResponse refResponse;
                Response resolvedResponse;
                Response response = (Response)responses.get(responseCode);
                if (response instanceof RefResponse && (resolvedResponse = this.cache.loadRef((refResponse = (RefResponse)response).get$ref(), refResponse.getRefFormat(), Response.class)) != null) {
                    response = resolvedResponse;
                    responses.put(responseCode, resolvedResponse);
                }
                this.responseProcessor.processResponse(response);
            }
        }
    }
}

