/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser.processors;

import io.swagger.models.Model;
import io.swagger.models.RefModel;
import io.swagger.models.Swagger;
import io.swagger.parser.ResolverCache;
import io.swagger.parser.processors.ModelProcessor;
import java.util.HashSet;
import java.util.Map;

public class DefinitionsProcessor {
    private final ResolverCache cache;
    private final Swagger swagger;
    private final ModelProcessor modelProcessor;

    public DefinitionsProcessor(ResolverCache cache, Swagger swagger) {
        this.cache = cache;
        this.swagger = swagger;
        this.modelProcessor = new ModelProcessor(cache, swagger);
    }

    public void processDefinitions() {
        Map definitions = this.swagger.getDefinitions();
        if (definitions == null) {
            return;
        }
        HashSet keySet = new HashSet();
        keySet.addAll(definitions.keySet());
        for (String modelName : keySet) {
            String renamedRef;
            Model model = (Model)definitions.get(modelName);
            String originalRef = model instanceof RefModel ? ((RefModel)model).get$ref() : null;
            this.modelProcessor.processModel(model);
            if (!(model instanceof RefModel) || (renamedRef = this.cache.getRenamedRef(originalRef)) == null) continue;
            Model resolvedModel = (Model)definitions.remove(renamedRef);
            definitions.put(modelName, resolvedModel);
        }
    }
}

