/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.transform.migrate;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.wordnik.swagger.util.Json;
import io.swagger.transform.migrate.OperationParametersMigrator;
import io.swagger.transform.migrate.SwaggerMigrator;
import io.swagger.transform.util.MutableJsonTree;
import io.swagger.transform.util.SwaggerMigrationException;
import io.swagger.transform.util.SwaggerMigrators;
import java.util.Iterator;
import javax.annotation.Nonnull;

public final class ApiObjectMigrator
implements SwaggerMigrator {
    private final SwaggerMigrator parametersMigrator = new OperationParametersMigrator();

    @Override
    @Nonnull
    public JsonNode migrate(@Nonnull JsonNode input) throws SwaggerMigrationException {
        ObjectNode on = (ObjectNode)input;
        if (on.get("type") == null) {
            JsonNode responseMessages = on.get("responseMessages");
            JsonNode type = null;
            if (responseMessages != null && responseMessages instanceof ArrayNode) {
                ArrayNode arrayNode = (ArrayNode)responseMessages;
                Iterator itr = arrayNode.elements();
                while (itr.hasNext()) {
                    JsonNode rm = (JsonNode)itr.next();
                    JsonNode code = rm.get("code");
                    if (code == null || !"200".equals(code.toString())) continue;
                    type = rm;
                }
            }
            if (type != null) {
                if (type.get("type") == null) {
                    on.put("type", "void");
                } else {
                    on.put("type", type.get("type"));
                }
            } else {
                on.put("type", "void");
            }
        }
        if (on.get("parameters") == null) {
            on.put("parameters", (JsonNode)Json.mapper().createArrayNode());
        }
        MutableJsonTree tree = new MutableJsonTree(input);
        tree.applyMigrator(SwaggerMigrators.renameMember("httpMethod", "method"));
        tree.applyMigrator(SwaggerMigrators.renameMember("errorResponses", "responseMessages"));
        JsonPointer ptr = JsonPointer.of((Object)"responseMessages", (Object[])new Object[0]);
        if (!((JsonNode)ptr.path((TreeNode)tree.getBaseNode())).isMissingNode()) {
            tree.setPointer(ptr);
            tree.applyMigratorToElements(SwaggerMigrators.renameMember("reason", "message"));
        }
        ptr = JsonPointer.of((Object)"parameters", (Object[])new Object[0]);
        tree.setPointer(ptr);
        tree.applyMigratorToElements(this.parametersMigrator);
        return tree.getBaseNode();
    }
}

