/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen;

import io.swagger.codegen.CodegenConfig;
import java.util.ServiceLoader;

public class CodegenConfigLoader {
    public static CodegenConfig forName(String name) {
        ServiceLoader<CodegenConfig> loader = ServiceLoader.load(CodegenConfig.class);
        StringBuilder availableConfigs = new StringBuilder();
        CodegenConfig current = null;
        for (CodegenConfig config : loader) {
            if (config.getName().equals(name)) {
                if (current == null) {
                    current = config;
                } else if (config.isPrivileged() && !current.isPrivileged()) {
                    current = config;
                } else if ((!current.isPrivileged() || config.isPrivileged()) && config.getPriority() > current.getPriority()) {
                    current = config;
                }
            }
            availableConfigs.append(config.getName()).append("\n");
        }
        if (current != null) {
            return current;
        }
        try {
            return (CodegenConfig)Class.forName(name).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Can't load config class with name ".concat(name) + " Available: " + availableConfigs.toString(), e);
        }
    }
}

