/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.utils;

import io.swagger.codegen.CodegenConstants;
import io.swagger.codegen.DefaultCodegen;

public final class EnumPropertyNamingUtils {
    public static String applyEnumPropertyCapitalisation(String value, CodegenConstants.ENUM_PROPERTY_NAMING_TYPE enumPropertyNaming) {
        switch (enumPropertyNaming) {
            case original: {
                return value;
            }
            case camelCase: {
                return DefaultCodegen.camelize(value, true);
            }
            case PascalCase: {
                return DefaultCodegen.titleCase(DefaultCodegen.camelize(value));
            }
            case snake_case: {
                return DefaultCodegen.underscore(value);
            }
            case UPPERCASE: {
                return value.toUpperCase();
            }
        }
        return value;
    }

    public static CodegenConstants.ENUM_PROPERTY_NAMING_TYPE parseEnumPropertyNaming(String enumPropertyNamingType) {
        try {
            return CodegenConstants.ENUM_PROPERTY_NAMING_TYPE.valueOf(enumPropertyNamingType);
        }
        catch (IllegalArgumentException ex) {
            StringBuilder sb = new StringBuilder(enumPropertyNamingType + " is an invalid enum property naming option. Please choose from:");
            for (CodegenConstants.ENUM_PROPERTY_NAMING_TYPE t : CodegenConstants.ENUM_PROPERTY_NAMING_TYPE.values()) {
                sb.append("\n  ").append(t.name());
            }
            throw new RuntimeException(sb.toString());
        }
    }
}

