/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import com.google.common.base.Strings;
import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.models.Info;
import io.swagger.models.License;
import io.swagger.models.Model;
import io.swagger.models.Swagger;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavascriptClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavascriptClientCodegen.class);
    private static final String PROJECT_NAME = "projectName";
    private static final String MODULE_NAME = "moduleName";
    private static final String PROJECT_DESCRIPTION = "projectDescription";
    private static final String PROJECT_VERSION = "projectVersion";
    private static final String PROJECT_LICENSE_NAME = "projectLicenseName";
    protected String projectName;
    protected String moduleName;
    protected String projectDescription;
    protected String projectVersion;
    protected String sourceFolder = "src";
    protected String localVariablePrefix = "";

    public JavascriptClientCodegen() {
        this.outputFolder = "generated-code/js";
        this.modelTemplateFiles.put("model.mustache", ".js");
        this.apiTemplateFiles.put("api.mustache", ".js");
        this.templateDir = "Javascript";
        this.apiPackage = "api";
        this.modelPackage = "model";
        this.reservedWords = new HashSet<String>(Arrays.asList("abstract", "arguments", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "debugger", "default", "delete", "do", "double", "else", "enum", "eval", "export", "extends", "false", "final", "finally", "float", "for", "function", "goto", "if", "implements", "import", "in", "instanceof", "int", "interface", "let", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "typeof", "var", "void", "volatile", "while", "with", "yield", "Array", "Date", "eval", "function", "hasOwnProperty", "Infinity", "isFinite", "isNaN", "isPrototypeOf", "Math", "NaN", "Number", "Object", "prototype", "String", "toString", "undefined", "valueOf"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("String", "Boolean", "Integer", "Number", "Array", "Object", "Date", "File"));
        this.defaultIncludes = new HashSet(this.languageSpecificPrimitives);
        this.cliOptions.add(new CliOption("sourceFolder", "source folder for generated code").defaultValue("src"));
        this.cliOptions.add(new CliOption("localVariablePrefix", "prefix for generated code members and local variables"));
        this.cliOptions.add(new CliOption(PROJECT_NAME, "name of the project (Default: generated from info.title or \"swagger-js-client\")"));
        this.cliOptions.add(new CliOption(MODULE_NAME, "module name for AMD, Node or globals (Default: generated from <projectName>)"));
        this.cliOptions.add(new CliOption(PROJECT_DESCRIPTION, "description of the project (Default: using info.description or \"Client library of <projectName>\")"));
        this.cliOptions.add(new CliOption(PROJECT_VERSION, "version of the project (Default: using info.version or \"1.0.0\")"));
        this.cliOptions.add(new CliOption(PROJECT_LICENSE_NAME, "name of the license the project uses (Default: using info.license.name)"));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "javascript";
    }

    @Override
    public String getHelp() {
        return "Generates a Javascript client library.";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.typeMapping = new HashMap();
        this.typeMapping.put("array", "Array");
        this.typeMapping.put("List", "Array");
        this.typeMapping.put("map", "Object");
        this.typeMapping.put("object", "Object");
        this.typeMapping.put("boolean", "Boolean");
        this.typeMapping.put("char", "String");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("short", "Integer");
        this.typeMapping.put("int", "Integer");
        this.typeMapping.put("integer", "Integer");
        this.typeMapping.put("long", "Integer");
        this.typeMapping.put("float", "Number");
        this.typeMapping.put("double", "Number");
        this.typeMapping.put("number", "Number");
        this.typeMapping.put("DateTime", "Date");
        this.importMapping.clear();
    }

    @Override
    public void preprocessSwagger(Swagger swagger) {
        super.preprocessSwagger(swagger);
        if (this.additionalProperties.containsKey(PROJECT_NAME)) {
            this.projectName = (String)this.additionalProperties.get(PROJECT_NAME);
        }
        if (this.additionalProperties.containsKey(MODULE_NAME)) {
            this.moduleName = (String)this.additionalProperties.get(MODULE_NAME);
        }
        if (this.additionalProperties.containsKey(PROJECT_DESCRIPTION)) {
            this.projectDescription = (String)this.additionalProperties.get(PROJECT_DESCRIPTION);
        }
        if (this.additionalProperties.containsKey(PROJECT_VERSION)) {
            this.projectVersion = (String)this.additionalProperties.get(PROJECT_VERSION);
        }
        if (this.additionalProperties.containsKey("localVariablePrefix")) {
            this.localVariablePrefix = (String)this.additionalProperties.get("localVariablePrefix");
        }
        if (this.additionalProperties.containsKey("sourceFolder")) {
            this.sourceFolder = (String)this.additionalProperties.get("sourceFolder");
        }
        if (swagger.getInfo() != null) {
            Info info = swagger.getInfo();
            if (this.projectName == null && info.getTitle() != null) {
                this.projectName = this.dashize(info.getTitle());
            }
            if (this.projectVersion == null) {
                this.projectVersion = info.getVersion();
            }
            if (this.projectDescription == null) {
                this.projectDescription = info.getDescription();
            }
            if (info.getLicense() != null) {
                License license = info.getLicense();
                if (this.additionalProperties.get(PROJECT_LICENSE_NAME) == null) {
                    this.additionalProperties.put(PROJECT_LICENSE_NAME, license.getName());
                }
            }
        }
        if (this.projectName == null) {
            this.projectName = "swagger-js-client";
        }
        if (this.moduleName == null) {
            this.moduleName = JavascriptClientCodegen.camelize(JavascriptClientCodegen.underscore(this.projectName));
        }
        if (this.projectVersion == null) {
            this.projectVersion = "1.0.0";
        }
        if (this.projectDescription == null) {
            this.projectDescription = "Client library of " + this.projectName;
        }
        this.additionalProperties.put(PROJECT_NAME, this.projectName);
        this.additionalProperties.put(MODULE_NAME, this.moduleName);
        this.additionalProperties.put(PROJECT_DESCRIPTION, this.escapeText(this.projectDescription));
        this.additionalProperties.put(PROJECT_VERSION, this.projectVersion);
        this.additionalProperties.put("localVariablePrefix", this.localVariablePrefix);
        this.additionalProperties.put("sourceFolder", this.sourceFolder);
        this.supportingFiles.add(new SupportingFile("package.mustache", "", "package.json"));
        this.supportingFiles.add(new SupportingFile("index.mustache", this.sourceFolder, "index.js"));
    }

    @Override
    public String escapeReservedWord(String name) {
        return "_" + name;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/" + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/" + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public String toVarName(String name) {
        if ("_".equals(name = this.sanitizeName(name))) {
            name = "_u";
        }
        if (name.matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.reservedWords.contains(name = JavascriptClientCodegen.camelize(name, true)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String toModelName(String name) {
        if (this.reservedWords.contains(name = this.sanitizeName(name))) {
            throw new RuntimeException(name + " (reserved word) cannot be used as a model name");
        }
        return JavascriptClientCodegen.camelize(name);
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toModelImport(String name) {
        return name;
    }

    @Override
    public String toApiImport(String name) {
        return this.toApiName(name);
    }

    @Override
    public String getTypeDeclaration(Property p) {
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            Property inner = ap.getItems();
            return this.getSwaggerType(p);
        }
        if (p instanceof MapProperty) {
            MapProperty mp = (MapProperty)p;
            Property inner = mp.getAdditionalProperties();
            return this.getSwaggerType(p) + "<String, " + this.getTypeDeclaration(inner) + ">";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String toDefaultValue(Property p) {
        if (p instanceof ArrayProperty) {
            return "[]";
        }
        if (p instanceof MapProperty) {
            return "{}";
        }
        if (p instanceof LongProperty) {
            LongProperty dp = (LongProperty)p;
            if (dp.getDefault() != null) {
                return dp.getDefault().toString() + "l";
            }
            return "null";
        }
        if (p instanceof RefProperty) {
            RefProperty rp = (RefProperty)p;
            return "new " + rp.getSimpleRef() + "()";
        }
        return super.toDefaultValue(p);
    }

    @Override
    public String toDefaultValueWithParam(String name, Property p) {
        if (p instanceof ArrayProperty) {
            return " = new Array();";
        }
        if (p instanceof MapProperty) {
            return " = {}";
        }
        if (p instanceof LongProperty) {
            LongProperty dp = (LongProperty)p;
            return " = data." + name + ";";
        }
        if (p instanceof RefProperty) {
            RefProperty rp = (RefProperty)p;
            return ".constructFromObject(data." + name + ");";
        }
        return super.toDefaultValueWithParam(name, p);
    }

    @Override
    public String getSwaggerType(Property p) {
        String swaggerType = super.getSwaggerType(p);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (!this.needToImport(type)) {
                return type;
            }
        } else {
            type = swaggerType;
        }
        if (null == type) {
            LOGGER.error("No Type defined for Property " + p);
        }
        return this.toModelName(type);
    }

    @Override
    public String toOperationId(String operationId) {
        if (StringUtils.isEmpty((String)operationId)) {
            throw new RuntimeException("Empty method/operation name (operationId) not allowed");
        }
        if (this.reservedWords.contains(operationId)) {
            throw new RuntimeException(operationId + " (reserved word) cannot be used as method name");
        }
        return JavascriptClientCodegen.camelize(this.sanitizeName(operationId), true);
    }

    @Override
    public CodegenModel fromModel(String name, Model model, Map<String, Model> allDefinitions) {
        CodegenModel codegenModel = super.fromModel(name, model, allDefinitions);
        if (allDefinitions != null && codegenModel != null && codegenModel.parent != null && codegenModel.hasEnums.booleanValue()) {
            Model parentModel = allDefinitions.get(this.toModelName(codegenModel.parent));
            CodegenModel parentCodegenModel = super.fromModel(codegenModel.parent, parentModel);
            codegenModel = this.reconcileInlineEnums(codegenModel, parentCodegenModel);
        }
        return codegenModel;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        List models = (List)objs.get("models");
        for (Object _mo : models) {
            Map mo = (Map)_mo;
            CodegenModel cm = (CodegenModel)mo.get("model");
            for (CodegenProperty var : cm.vars) {
                List values;
                Map<String, Object> allowableValues = var.allowableValues;
                if (var.items != null) {
                    allowableValues = var.items.allowableValues;
                }
                if (allowableValues == null || (values = (List)allowableValues.get("values")) == null) continue;
                ArrayList enumVars = new ArrayList();
                String commonPrefix = this.findCommonPrefixOfVars(values);
                int truncateIdx = commonPrefix.length();
                for (String value : values) {
                    String enumName;
                    HashMap<String, String> enumVar = new HashMap<String, String>();
                    if (truncateIdx == 0) {
                        enumName = value;
                    } else {
                        enumName = value.substring(truncateIdx);
                        if ("".equals(enumName)) {
                            enumName = value;
                        }
                    }
                    enumVar.put("name", this.toEnumVarName(enumName));
                    enumVar.put("value", value);
                    enumVars.add(enumVar);
                }
                allowableValues.put("enumVars", enumVars);
            }
        }
        return objs;
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        Map operations;
        if ("retrofit".equals(this.getLibrary()) && (operations = (Map)objs.get("operations")) != null) {
            List ops = (List)operations.get("operation");
            for (CodegenOperation operation : ops) {
                Map<String, String> firstType;
                if (operation.hasConsumes == Boolean.TRUE && (firstType = operation.consumes.get(0)) != null && "multipart/form-data".equals(firstType.get("mediaType"))) {
                    operation.isMultipart = Boolean.TRUE;
                }
                if (operation.returnType != null) continue;
                operation.returnType = "Void";
            }
        }
        return objs;
    }

    @Override
    protected boolean needToImport(String type) {
        return !this.defaultIncludes.contains(type) && !this.languageSpecificPrimitives.contains(type);
    }

    private String findCommonPrefixOfVars(List<String> vars) {
        String prefix = StringUtils.getCommonPrefix((String[])vars.toArray(new String[vars.size()]));
        return prefix.replaceAll("[a-zA-Z0-9]+\\z", "");
    }

    private String toEnumVarName(String value) {
        String var = value.replaceAll("\\W+", "_").toUpperCase();
        if (var.matches("\\d.*")) {
            return "_" + var;
        }
        return var;
    }

    private CodegenModel reconcileInlineEnums(CodegenModel codegenModel, CodegenModel parentCodegenModel) {
        if (parentCodegenModel.hasEnums.booleanValue()) {
            List<CodegenProperty> parentModelCodegenProperties = parentCodegenModel.vars;
            List<CodegenProperty> codegenProperties = codegenModel.vars;
            boolean removedChildEnum = false;
            for (CodegenProperty parentModelCodegenPropery : parentModelCodegenProperties) {
                if (!parentModelCodegenPropery.isEnum) continue;
                Iterator<CodegenProperty> iterator = codegenProperties.iterator();
                while (iterator.hasNext()) {
                    CodegenProperty codegenProperty = iterator.next();
                    if (!codegenProperty.isEnum || !codegenProperty.equals(parentModelCodegenPropery)) continue;
                    iterator.remove();
                    removedChildEnum = true;
                }
            }
            if (removedChildEnum) {
                int count = 0;
                int numVars = codegenProperties.size();
                for (CodegenProperty codegenProperty : codegenProperties) {
                    codegenProperty.hasMore = ++count < numVars ? Boolean.valueOf(true) : null;
                }
                codegenModel.vars = codegenProperties;
            }
        }
        return codegenModel;
    }

    private String sanitizePackageName(String packageName) {
        packageName = packageName.trim();
        if (Strings.isNullOrEmpty((String)(packageName = packageName.replaceAll("[^a-zA-Z0-9_\\.]", "_")))) {
            return "invalidPackageName";
        }
        return packageName;
    }
}

