/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser.util;

import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.XML;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.parser.models.RefType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InlineModelResolver {
    private OpenAPI openAPI;
    static final Logger LOGGER = LoggerFactory.getLogger(InlineModelResolver.class);
    Map<String, Schema> addedModels = new HashMap<String, Schema>();
    Map<String, String> generatedSignature = new HashMap<String, String>();
    private final boolean flattenComposedSchemas;
    private final boolean camelCaseFlattenNaming;
    private boolean skipMatches;

    public InlineModelResolver() {
        this(false, false, false);
    }

    public InlineModelResolver(boolean flattenComposedSchemas, boolean camelCaseFlattenNaming) {
        this(flattenComposedSchemas, camelCaseFlattenNaming, false);
    }

    public InlineModelResolver(boolean flattenComposedSchemas, boolean camelCaseFlattenNaming, boolean skipMatches) {
        this.flattenComposedSchemas = flattenComposedSchemas;
        this.camelCaseFlattenNaming = camelCaseFlattenNaming;
        this.skipMatches = skipMatches;
    }

    public void flatten(OpenAPI openAPI) {
        this.openAPI = openAPI;
        if (openAPI.getComponents() != null && openAPI.getComponents().getSchemas() == null) {
            openAPI.getComponents().setSchemas(new HashMap());
        }
        Paths paths = openAPI.getPaths();
        if (openAPI.getComponents() == null) {
            openAPI.setComponents(new Components());
        }
        Map models = openAPI.getComponents().getSchemas();
        this.flattenPaths((Map<String, PathItem>)paths);
        this.flattenDefinitions(models);
    }

    private void flattenPaths(Map<String, PathItem> paths) {
        if (paths == null) {
            return;
        }
        for (String pathname : paths.keySet()) {
            PathItem path = paths.get(pathname);
            for (Operation operation : path.readOperations()) {
                this.flattenBody(pathname, operation.getRequestBody());
                this.flattenParams(pathname, operation.getParameters());
                this.flattenResponses(pathname, (Map<String, ApiResponse>)operation.getResponses());
            }
        }
    }

    private void flattenBody(String pathname, RequestBody body) {
        if (body == null) {
            return;
        }
        Content content = body.getContent();
        if (content == null) {
            return;
        }
        for (String key : content.keySet()) {
            String modelName;
            ArraySchema am;
            Schema inner;
            String modelName2;
            MediaType mediaType;
            if (content.get(key) == null || (mediaType = (MediaType)content.get(key)).getSchema() == null) continue;
            Schema model = mediaType.getSchema();
            String genericName = InlineModelResolver.pathBody(pathname);
            if (model.getProperties() != null && model.getProperties().size() > 0) {
                this.flattenProperties(model.getProperties(), pathname);
                modelName2 = this.resolveModelName(model.getTitle(), genericName);
                mediaType.setSchema(new Schema().$ref(modelName2));
                this.addGenerated(modelName2, model);
                this.openAPI.getComponents().addSchemas(modelName2, model);
                continue;
            }
            if (model instanceof ComposedSchema) {
                this.flattenComposedSchema(model, pathname);
                if (model.get$ref() != null) continue;
                modelName2 = this.resolveModelName(model.getTitle(), genericName);
                mediaType.setSchema(this.makeRefProperty(modelName2, model));
                this.addGenerated(modelName2, model);
                this.openAPI.getComponents().addSchemas(modelName2, model);
                continue;
            }
            if (!(model instanceof ArraySchema) || !this.isObjectSchema(inner = (am = (ArraySchema)model).getItems())) continue;
            if (inner.getProperties() != null && inner.getProperties().size() > 0) {
                this.flattenProperties(inner.getProperties(), pathname);
                modelName = this.resolveModelName(inner.getTitle(), genericName);
                String existing = this.matchGenerated(inner);
                if (existing != null) {
                    am.setItems(new Schema().$ref(existing));
                    continue;
                }
                am.setItems(new Schema().$ref(modelName));
                this.addGenerated(modelName, inner);
                this.openAPI.getComponents().addSchemas(modelName, inner);
                continue;
            }
            if (!(inner instanceof ComposedSchema) || !this.flattenComposedSchemas) continue;
            this.flattenComposedSchema(inner, key);
            if (inner.get$ref() != null) continue;
            modelName = this.resolveModelName(inner.getTitle(), "inline_body_items_" + key + "_" + pathname);
            am.setItems(this.makeRefProperty(modelName, inner));
            this.addGenerated(modelName, inner);
            this.openAPI.getComponents().addSchemas(modelName, inner);
        }
    }

    private void flattenParams(String pathname, List<Parameter> parameters) {
        if (parameters == null) {
            return;
        }
        for (Parameter parameter : parameters) {
            String modelName;
            ArraySchema am;
            Schema inner;
            String modelName2;
            if (parameter.getSchema() == null) continue;
            Schema model = parameter.getSchema();
            if (model.getProperties() != null) {
                if (model.getType() != null && !"object".equals(model.getType()) || model.getProperties() == null || model.getProperties().size() <= 0) continue;
                this.flattenProperties(model.getProperties(), pathname);
                modelName2 = this.resolveModelName(model.getTitle(), parameter.getName());
                parameter.setSchema(new Schema().$ref(modelName2));
                this.addGenerated(modelName2, model);
                this.openAPI.getComponents().addSchemas(modelName2, model);
                continue;
            }
            if (model instanceof ComposedSchema) {
                modelName2 = this.resolveModelName(model.getTitle(), parameter.getName());
                parameter.setSchema(new Schema().$ref(modelName2));
                this.addGenerated(modelName2, model);
                this.openAPI.getComponents().addSchemas(modelName2, model);
                continue;
            }
            if (!(model instanceof ArraySchema) || !this.isObjectSchema(inner = (am = (ArraySchema)model).getItems())) continue;
            if (inner.getProperties() != null && inner.getProperties().size() > 0) {
                this.flattenProperties(inner.getProperties(), pathname);
                modelName = this.resolveModelName(inner.getTitle(), parameter.getName());
                String existing = this.matchGenerated(inner);
                if (existing != null) {
                    am.setItems(new Schema().$ref(existing));
                    continue;
                }
                am.setItems(new Schema().$ref(modelName));
                this.addGenerated(modelName, (Schema)am);
                this.openAPI.getComponents().addSchemas(modelName, (Schema)am);
                continue;
            }
            if (!(inner instanceof ComposedSchema) || !this.flattenComposedSchemas) continue;
            this.flattenComposedSchema(inner, parameter.getName());
            if (inner.get$ref() != null) continue;
            modelName = this.resolveModelName(inner.getTitle(), "inline_parameter_items_" + parameter.getName());
            am.setItems(this.makeRefProperty(modelName, inner));
            this.addGenerated(modelName, inner);
            this.openAPI.getComponents().addSchemas(modelName, inner);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void flattenResponses(String pathname, Map<String, ApiResponse> responses) {
        if (responses == null) {
            return;
        }
        for (String string : responses.keySet()) {
            ApiResponse response = responses.get(string);
            if (response.getContent() == null) continue;
            Content content = response.getContent();
            for (String name : content.keySet()) {
                Schema innerProperty;
                void var4_4;
                MediaType media;
                if (content.get(name) == null || (media = (MediaType)content.get(name)).getSchema() == null) continue;
                Schema mediaSchema = media.getSchema();
                if (this.isObjectSchema(mediaSchema)) {
                    ArraySchema arraySchema;
                    Schema inner;
                    if (mediaSchema.getProperties() != null && mediaSchema.getProperties().size() > 0 || mediaSchema instanceof ComposedSchema) {
                        String modelName = this.resolveModelName(mediaSchema.getTitle(), "inline_response_" + (String)var4_4);
                        String existing = this.matchGenerated(mediaSchema);
                        if (existing != null) {
                            media.setSchema(this.makeRefProperty(existing, mediaSchema));
                            continue;
                        }
                        media.setSchema(this.makeRefProperty(modelName, mediaSchema));
                        this.addGenerated(modelName, mediaSchema);
                        this.openAPI.getComponents().addSchemas(modelName, mediaSchema);
                        continue;
                    }
                    if (mediaSchema.getAdditionalProperties() == null || mediaSchema.getAdditionalProperties() instanceof Boolean) continue;
                    innerProperty = (Schema)mediaSchema.getAdditionalProperties();
                    if (this.isObjectSchema(innerProperty)) {
                        String string2 = "inline_response_map" + (String)var4_4;
                        this.flattenMapSchema(innerProperty, string2, pathname, mediaSchema);
                        continue;
                    }
                    if (!(innerProperty instanceof ArraySchema) || !this.isObjectSchema(inner = (arraySchema = (ArraySchema)innerProperty).getItems())) continue;
                    String string3 = "inline_response_map_items" + (String)var4_4;
                    this.flattenMapSchema(inner, string3, pathname, mediaSchema);
                    continue;
                }
                if (mediaSchema instanceof ArraySchema) {
                    ArraySchema ap = (ArraySchema)mediaSchema;
                    Schema inner = ap.getItems();
                    if (!this.isObjectSchema(inner)) continue;
                    this.flattenArraySchema(inner, (String)var4_4, pathname, ap);
                    continue;
                }
                if (mediaSchema.getAdditionalProperties() == null || mediaSchema.getAdditionalProperties() instanceof Boolean || !this.isObjectSchema(innerProperty = (Schema)mediaSchema.getAdditionalProperties())) continue;
                String string4 = "inline_response_map" + (String)var4_4;
                this.flattenMapSchema(innerProperty, string4, pathname, mediaSchema);
            }
        }
    }

    private void flattenDefinitions(Map<String, Schema> models) {
        if (models == null) {
            return;
        }
        ArrayList<String> modelNames = new ArrayList<String>(models.keySet());
        for (String modelName : modelNames) {
            Schema model = models.get(modelName);
            if (model.getProperties() != null) {
                Map properties = model.getProperties();
                this.flattenProperties(properties, modelName);
                this.fixStringModel(model);
                continue;
            }
            if (model instanceof ArraySchema) {
                ArraySchema m = (ArraySchema)model;
                Schema inner = m.getItems();
                if (!this.isObjectSchema(inner)) continue;
                if (inner.getProperties() != null && inner.getProperties().size() > 0) {
                    String innerModelName = this.resolveModelName(inner.getTitle(), modelName + "_inner");
                    String existing = this.matchGenerated(inner);
                    if (existing == null) {
                        this.openAPI.getComponents().addSchemas(innerModelName, inner);
                        this.addGenerated(innerModelName, inner);
                        m.setItems(new Schema().$ref(innerModelName));
                        continue;
                    }
                    m.setItems(new Schema().$ref(existing));
                    continue;
                }
                if (!(inner instanceof ComposedSchema) || !this.flattenComposedSchemas) continue;
                this.flattenComposedSchema(inner, modelName);
                if (inner.get$ref() != null) continue;
                modelName = this.resolveModelName(inner.getTitle(), "inline_array_items_" + modelName);
                m.setItems(this.makeRefProperty(modelName, inner));
                this.addGenerated(modelName, inner);
                this.openAPI.getComponents().addSchemas(modelName, inner);
                continue;
            }
            if (!(model instanceof ComposedSchema)) continue;
            ComposedSchema composedSchema = (ComposedSchema)model;
            String inlineModelName = "";
            List list = null;
            if (composedSchema.getAllOf() != null) {
                list = composedSchema.getAllOf();
                inlineModelName = "AllOf";
            } else if (composedSchema.getAnyOf() != null) {
                list = composedSchema.getAnyOf();
                inlineModelName = "AnyOf";
            } else if (composedSchema.getOneOf() != null) {
                list = composedSchema.getOneOf();
                inlineModelName = "OneOf";
            }
            for (int i = 0; i < list.size(); ++i) {
                if (((Schema)list.get(i)).get$ref() != null) continue;
                Schema inline = (Schema)list.get(i);
                if (inline.getProperties() != null) {
                    this.flattenProperties(inline.getProperties(), modelName);
                }
                if (!this.flattenComposedSchemas) continue;
                int position = i + 1;
                inlineModelName = this.resolveModelName(inline.getTitle(), modelName + inlineModelName + "_" + position);
                list.set(i, new Schema().$ref(inlineModelName));
                this.addGenerated(inlineModelName, inline);
                this.openAPI.getComponents().addSchemas(inlineModelName, inline);
            }
        }
    }

    private void flattenArraySchema(Schema inner, String key, String pathname, ArraySchema ap) {
        if (inner.getProperties() != null && inner.getProperties().size() > 0) {
            this.flattenProperties(inner.getProperties(), pathname);
            key = "inline_response_" + (String)key;
            String modelName = this.resolveModelName(inner.getTitle(), (String)key);
            String existing = this.matchGenerated(inner);
            if (existing != null) {
                ap.setItems(this.makeRefProperty(existing, inner));
            } else {
                ap.setItems(this.makeRefProperty(modelName, inner));
                this.addGenerated(modelName, inner);
                this.openAPI.getComponents().addSchemas(modelName, inner);
            }
        } else if (inner instanceof ComposedSchema && this.flattenComposedSchemas) {
            this.flattenComposedSchema(inner, (String)key);
            if (inner.get$ref() == null) {
                key = "inline_response_items" + (String)key;
                String modelName = this.resolveModelName(inner.getTitle(), (String)key);
                ap.setItems(this.makeRefProperty(modelName, inner));
                this.addGenerated(modelName, inner);
                this.openAPI.getComponents().addSchemas(modelName, inner);
            }
        }
    }

    private void flattenMapSchema(Schema innerProperty, String key, String pathname, Schema mediaSchema) {
        if (innerProperty.getProperties() != null && innerProperty.getProperties().size() > 0) {
            this.flattenProperties(innerProperty.getProperties(), pathname);
            String modelName = this.resolveModelName(innerProperty.getTitle(), key);
            String existing = this.matchGenerated(innerProperty);
            if (existing != null) {
                mediaSchema.setAdditionalProperties((Object)new Schema().$ref(existing));
            } else {
                mediaSchema.setAdditionalProperties((Object)new Schema().$ref(modelName));
                this.addGenerated(modelName, innerProperty);
                this.openAPI.getComponents().addSchemas(modelName, innerProperty);
            }
        } else if (innerProperty instanceof ComposedSchema && this.flattenComposedSchemas) {
            this.flattenComposedSchema(innerProperty, key);
            if (innerProperty.get$ref() == null) {
                String modelName = this.resolveModelName(innerProperty.getTitle(), key);
                mediaSchema.setAdditionalProperties((Object)new Schema().$ref(modelName));
                this.addGenerated(modelName, innerProperty);
                this.openAPI.getComponents().addSchemas(modelName, innerProperty);
            }
        }
    }

    private void fixStringModel(Schema m) {
        String example;
        if (m.getType() != null && m.getType().equals("string") && m.getExample() != null && (example = m.getExample().toString()).substring(0, 1).equals("\"") && example.substring(example.length() - 1).equals("\"") && (example != null || example == null && m.getExampleSetFlag())) {
            m.setExample((Object)example.substring(1, example.length() - 1));
        }
    }

    private static String pathBody(String pathname) {
        String[] parts = pathname.split("/");
        StringBuilder body = new StringBuilder();
        if (parts.length > 2) {
            body.append(InlineModelResolver.normalize(parts[parts.length - 2])).append('_');
        }
        if (parts.length > 1) {
            body.append(InlineModelResolver.normalize(parts[parts.length - 1])).append('_');
        }
        body.append("body");
        return body.toString();
    }

    private static String normalize(String pathPart) {
        return pathPart.replace(".", "_");
    }

    private String resolveModelName(String title, String key) {
        if (title == null) {
            return this.uniqueName(key);
        }
        return this.uniqueName(title);
    }

    public String matchGenerated(Schema model) {
        if (this.skipMatches) {
            return null;
        }
        String json = Json.pretty((Object)model);
        if (this.generatedSignature.containsKey(json)) {
            return this.generatedSignature.get(json);
        }
        return null;
    }

    public void addGenerated(String name, Schema model) {
        this.generatedSignature.put(Json.pretty((Object)model), name);
    }

    public String uniqueName(String key) {
        int count = 0;
        boolean done = false;
        if (this.camelCaseFlattenNaming) {
            String concatenated = "";
            for (int i = 0; i < key.split("[-|\\s|_]").length; ++i) {
                Object uniqueKey = key.split("[-|\\s|_]")[i];
                uniqueKey = ((String)uniqueKey).substring(0, 1).toUpperCase() + ((String)uniqueKey).substring(1);
                concatenated = concatenated.concat((String)uniqueKey);
            }
            key = concatenated.replaceAll("[^a-z_\\.A-Z0-9 ]", "");
        } else {
            key = key.replaceAll("[^a-z_\\.A-Z0-9 ]", "");
        }
        while (!done) {
            Object name = key;
            if (count > 0) {
                name = key + "_" + count;
            }
            if (this.openAPI.getComponents().getSchemas() == null) {
                return name;
            }
            if (!this.openAPI.getComponents().getSchemas().containsKey(name)) {
                return name;
            }
            ++count;
        }
        return key;
    }

    public void flattenProperties(Map<String, Schema> properties, String path) {
        if (properties == null) {
            return;
        }
        HashMap<String, Schema> propsToUpdate = new HashMap<String, Schema>();
        HashMap<String, Schema> modelsToAdd = new HashMap<String, Schema>();
        for (String key : properties.keySet()) {
            Schema inner;
            Schema property = properties.get(key);
            if (this.isObjectSchema(property) && property.getProperties() != null && property.getProperties().size() > 0) {
                String modelName = this.resolveModelName(property.getTitle(), path + "_" + key);
                Schema model = this.createModelFromProperty(property, modelName);
                String existing = this.matchGenerated(model);
                if (existing != null) {
                    propsToUpdate.put(key, new Schema().$ref(existing));
                    continue;
                }
                propsToUpdate.put(key, new Schema().$ref(RefType.SCHEMAS.getInternalPrefix() + modelName));
                modelsToAdd.put(modelName, model);
                this.addGenerated(modelName, model);
                this.openAPI.getComponents().addSchemas(modelName, model);
                continue;
            }
            if (property instanceof ArraySchema) {
                String existing;
                Schema innerModel;
                String modelName;
                ArraySchema ap = (ArraySchema)property;
                Schema inner2 = ap.getItems();
                if (!this.isObjectSchema(inner2)) continue;
                if (inner2.getProperties() != null && inner2.getProperties().size() > 0) {
                    this.flattenProperties(inner2.getProperties(), path);
                    modelName = this.resolveModelName(inner2.getTitle(), path + "_" + key);
                    innerModel = this.createModelFromProperty(inner2, modelName);
                    existing = this.matchGenerated(innerModel);
                    if (existing != null) {
                        ap.setItems(new Schema().$ref(existing));
                        continue;
                    }
                    ap.setItems(new Schema().$ref(modelName));
                    this.addGenerated(modelName, innerModel);
                    this.openAPI.getComponents().addSchemas(modelName, innerModel);
                    continue;
                }
                if (!(inner2 instanceof ComposedSchema) || !this.flattenComposedSchemas) continue;
                this.flattenComposedSchema(inner2, key);
                modelName = this.resolveModelName(inner2.getTitle(), path + "_" + key);
                innerModel = this.createModelFromProperty(inner2, modelName);
                existing = this.matchGenerated(innerModel);
                if (existing != null) {
                    ap.setItems(new Schema().$ref(existing));
                    continue;
                }
                ap.setItems(new Schema().$ref(modelName));
                this.addGenerated(modelName, innerModel);
                this.openAPI.getComponents().addSchemas(modelName, innerModel);
                continue;
            }
            if (property.getAdditionalProperties() == null || property.getAdditionalProperties() instanceof Boolean || !this.isObjectSchema(inner = (Schema)property.getAdditionalProperties()) || inner.getProperties() == null || inner.getProperties().size() <= 0) continue;
            this.flattenProperties(inner.getProperties(), path);
            String modelName = this.resolveModelName(inner.getTitle(), path + "_" + key);
            Schema innerModel = this.createModelFromProperty(inner, modelName);
            String existing = this.matchGenerated(innerModel);
            if (existing != null) {
                property.setAdditionalProperties((Object)new Schema().$ref(existing));
                continue;
            }
            property.setAdditionalProperties((Object)new Schema().$ref(modelName));
            this.addGenerated(modelName, innerModel);
            this.openAPI.getComponents().addSchemas(modelName, innerModel);
        }
        if (propsToUpdate.size() > 0) {
            for (String key : propsToUpdate.keySet()) {
                properties.put(key, (Schema)propsToUpdate.get(key));
            }
        }
        for (String key : modelsToAdd.keySet()) {
            this.openAPI.getComponents().addSchemas(key, (Schema)modelsToAdd.get(key));
            this.addedModels.put(key, (Schema)modelsToAdd.get(key));
        }
    }

    private void flattenComposedSchema(Schema inner, String key) {
        ComposedSchema composedSchema = (ComposedSchema)inner;
        String inlineModelName = "";
        List list = null;
        if (composedSchema.getAllOf() != null) {
            list = composedSchema.getAllOf();
            inlineModelName = "AllOf";
        } else if (composedSchema.getAnyOf() != null) {
            list = composedSchema.getAnyOf();
            inlineModelName = "AnyOf";
        } else if (composedSchema.getOneOf() != null) {
            list = composedSchema.getOneOf();
            inlineModelName = "OneOf";
        }
        for (int i = 0; i < list.size(); ++i) {
            if (((Schema)list.get(i)).get$ref() != null) continue;
            Schema inline = (Schema)list.get(i);
            if (inline.getProperties() != null) {
                this.flattenProperties(inline.getProperties(), key);
            }
            if (!this.flattenComposedSchemas) continue;
            int position = i + 1;
            inlineModelName = this.resolveModelName(inline.getTitle(), key + inlineModelName + "_" + position);
            list.set(i, new Schema().$ref(inlineModelName));
            this.addGenerated(inlineModelName, inline);
            this.openAPI.getComponents().addSchemas(inlineModelName, inline);
        }
    }

    public Schema modelFromProperty(ArraySchema object, String path) {
        Schema inner;
        String description = object.getDescription();
        String example = null;
        Object obj = object.getExample();
        if (obj != null) {
            example = obj.toString();
        }
        if ((inner = object.getItems()) instanceof ObjectSchema) {
            ArraySchema model = new ArraySchema();
            model.setDescription(description);
            if (example != null || example == null && object.getExampleSetFlag()) {
                model.setExample((Object)example);
            }
            model.setItems(object.getItems());
            return model;
        }
        return null;
    }

    public Schema createModelFromProperty(Schema schema, String path) {
        String description = schema.getDescription();
        String example = null;
        List requiredList = schema.getRequired();
        Object obj = schema.getExample();
        if (obj != null) {
            example = obj.toString();
        }
        String name = schema.getName();
        XML xml = schema.getXml();
        Map properties = schema.getProperties();
        if (schema instanceof ComposedSchema && this.flattenComposedSchemas) {
            ComposedSchema composedModel = (ComposedSchema)schema;
            composedModel.setDescription(description);
            if (example != null || example == null && schema.getExampleSetFlag()) {
                composedModel.setExample((Object)example);
            }
            composedModel.setName(name);
            composedModel.setXml(xml);
            composedModel.setType(schema.getType());
            composedModel.setRequired(requiredList);
            return composedModel;
        }
        Schema model = new Schema();
        model.setAdditionalProperties(schema.getAdditionalProperties());
        model.setDescription(description);
        model.setDeprecated(schema.getDeprecated());
        model.setDiscriminator(schema.getDiscriminator());
        model.setEnum(schema.getEnum());
        if (example != null || example == null && schema.getExampleSetFlag()) {
            model.setExample((Object)example);
        }
        model.setExclusiveMaximum(schema.getExclusiveMaximum());
        model.setExclusiveMinimum(schema.getExclusiveMinimum());
        model.setFormat(schema.getFormat());
        model.setMinLength(schema.getMinLength());
        model.setMaximum(schema.getMaximum());
        model.setMaxItems(schema.getMaxItems());
        model.setMaxProperties(schema.getMaxProperties());
        model.setMaxLength(schema.getMaxLength());
        model.setMinimum(schema.getMinimum());
        model.setMinItems(schema.getMinItems());
        model.setMinLength(schema.getMinLength());
        model.setMinProperties(schema.getMinProperties());
        model.setMultipleOf(schema.getMultipleOf());
        model.setName(name);
        model.setNullable(schema.getNullable());
        model.setNot(schema.getNot());
        model.setPattern(schema.getPattern());
        model.setReadOnly(schema.getReadOnly());
        model.setRequired(requiredList);
        model.setUniqueItems(schema.getUniqueItems());
        model.setTitle(schema.getTitle());
        model.setType(schema.getType());
        model.setXml(xml);
        model.setWriteOnly(schema.getWriteOnly());
        if (properties != null) {
            this.flattenProperties(properties, path);
            model.setProperties(properties);
        }
        return model;
    }

    public Schema modelFromProperty(Schema object, String path) {
        String description = object.getDescription();
        String example = null;
        Object obj = object.getExample();
        if (obj != null) {
            example = obj.toString();
        }
        ArraySchema model = new ArraySchema();
        model.setDescription(description);
        if (example != null || example == null && object.getExampleSetFlag()) {
            model.setExample((Object)example);
        }
        if (object.getAdditionalProperties() != null && !(object.getAdditionalProperties() instanceof Boolean)) {
            model.setItems((Schema)object.getAdditionalProperties());
        }
        return model;
    }

    public Schema makeRefProperty(String ref, Schema property) {
        Schema newProperty = new Schema().$ref(ref);
        this.copyVendorExtensions(property, newProperty);
        return newProperty;
    }

    public void copyVendorExtensions(Schema source, Schema target) {
        if (source.getExtensions() != null) {
            Map vendorExtensions = source.getExtensions();
            for (String extName : vendorExtensions.keySet()) {
                target.addExtension(extName, vendorExtensions.get(extName));
            }
        }
    }

    private boolean isObjectSchema(Schema schema) {
        return schema instanceof ObjectSchema || "object".equalsIgnoreCase(schema.getType()) || schema.getType() == null && schema.getProperties() != null && !schema.getProperties().isEmpty() || schema instanceof ComposedSchema;
    }

    public boolean isSkipMatches() {
        return this.skipMatches;
    }

    public void setSkipMatches(boolean skipMatches) {
        this.skipMatches = skipMatches;
    }
}

