/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.codegen.api;

import io.sundr.codegen.api.Identifier;
import io.sundr.codegen.api.Identifiers;
import io.sundr.codegen.api.Output;
import io.sundr.codegen.api.Renderer;
import io.sundr.codegen.api.Renderers;
import io.sundr.codegen.api.SystemOutput;
import io.sundr.utils.Predicates;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class CodeGenerator<T> {
    private final Class<T> type;
    private final Function<T, Writer> output;
    private final Function<T, String> identifier;
    private final Function<T, String> renderer;
    private final Predicate<T> skip;
    private final Consumer<T> onSkip;
    private final Consumer<T> ignore = t -> {};
    private final Set<String> generated = new HashSet<String>();

    private CodeGenerator(Class<T> type, Function<T, Writer> output, Function<T, String> identifier, Function<T, String> renderer, Predicate<T> skip, Consumer<T> onSkip) {
        this.type = type;
        this.output = output != null ? output : new SystemOutput().getFunction();
        this.identifier = identifier != null ? identifier : Identifiers.findIdentifier(type).map(Identifier::getFunction).orElse(o -> String.valueOf(o.hashCode()));
        this.renderer = renderer != null ? renderer : Renderers.findRenderer(type).map(Renderer::getFunction).orElseThrow(() -> new IllegalStateException("Renderer should not be null."));
        this.skip = skip != null ? skip : Predicates.distinct(t -> this.identifier.apply(t));
        this.onSkip = onSkip != null ? onSkip : this.ignore;
    }

    public static <T> Builder<T> newGenerator(Class<T> type) {
        return new Builder<T>(type);
    }

    public boolean generate(T ... items) {
        return Identifiers.withIdentifier(this.identifier).call(() -> {
            for (Object item : items) {
                String id = this.identifier.apply(item);
                if (this.skip.test(item)) {
                    this.onSkip.accept(item);
                    continue;
                }
                if (this.generated.contains(id)) continue;
                try (Writer writer = this.output.apply(item);){
                    writer.write(this.renderer.apply(item));
                    this.generated.add(id);
                }
                catch (IOException e) {
                    return false;
                }
            }
            return true;
        });
    }

    public static class Builder<T> {
        private final Class<T> type;
        private final Function<T, Writer> output;
        private final Function<T, String> identifier;
        private final Function<T, String> renderer;
        private final Predicate<T> skip;
        private final Consumer<T> onSkip;

        private Builder(Class<T> type) {
            this(type, null, null, null, null, null);
        }

        private Builder(Class<T> type, Function<T, Writer> output, Function<T, String> identifier, Function<T, String> renderer, Predicate<T> skip, Consumer<T> onSkip) {
            this.type = type;
            this.output = output;
            this.identifier = identifier;
            this.renderer = renderer;
            this.skip = skip;
            this.onSkip = onSkip;
        }

        public Builder<T> withOutput(Output<T> output) {
            return this.withOutput(output.getFunction());
        }

        public Builder<T> withOutput(Function<T, Writer> output) {
            return new Builder<T>(this.type, output, this.identifier, this.renderer, this.skip, this.onSkip);
        }

        public Builder<T> withIdentifier(Identifier<T> identifier) {
            return this.withIdentifier(identifier.getFunction());
        }

        public Builder<T> withIdentifier(Function<T, String> identifier) {
            return new Builder<T>(this.type, this.output, identifier, this.renderer, this.skip, this.onSkip);
        }

        public Builder<T> withRenderer(Renderer<T> renderer) {
            return this.withRenderer(renderer.getFunction());
        }

        public Builder<T> withRenderer(Function<T, String> renderer) {
            return new Builder<T>(this.type, this.output, this.identifier, renderer, this.skip, this.onSkip);
        }

        public Builder<T> skipping(Predicate<T> skip) {
            return new Builder<T>(this.type, this.output, this.identifier, this.renderer, skip, this.onSkip);
        }

        public CodeGenerator<T> build() {
            return new CodeGenerator<T>(this.type, this.output, this.identifier, this.renderer, this.skip, this.onSkip);
        }

        public boolean generate(T ... items) {
            return this.build().generate(items);
        }
    }
}

