/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.mappers;

import com.fasterxml.classmate.ResolvedType;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BaseIntegerProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.DecimalProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.FileProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.models.properties.UUIDProperty;
import java.util.Comparator;
import java.util.Map;
import springfox.documentation.schema.Collections;
import springfox.documentation.schema.ModelProperty;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.schema.Types;
import springfox.documentation.swagger2.mappers.EnumMapper;

class Properties {
    private static final Map<String, Function<String, ? extends Property>> typeFactory = ImmutableMap.builder().put((Object)"int", Properties.newInstanceOf(IntegerProperty.class)).put((Object)"long", Properties.newInstanceOf(LongProperty.class)).put((Object)"float", Properties.newInstanceOf(FloatProperty.class)).put((Object)"double", Properties.newInstanceOf(DoubleProperty.class)).put((Object)"string", Properties.newInstanceOf(StringProperty.class)).put((Object)"boolean", Properties.newInstanceOf(BooleanProperty.class)).put((Object)"date", Properties.newInstanceOf(DateProperty.class)).put((Object)"date-time", Properties.newInstanceOf(DateTimeProperty.class)).put((Object)"bigdecimal", Properties.newInstanceOf(DecimalProperty.class)).put((Object)"biginteger", Properties.newInstanceOf(BaseIntegerProperty.class)).put((Object)"uuid", Properties.newInstanceOf(UUIDProperty.class)).put((Object)"object", Properties.newInstanceOf(ObjectProperty.class)).put((Object)"byte", Properties.bytePropertyFactory()).put((Object)"file", Properties.filePropertyFactory()).build();

    private Properties() {
        throw new UnsupportedOperationException();
    }

    public static Property property(String typeName) {
        String safeTypeName = Strings.nullToEmpty((String)typeName);
        Function propertyLookup = Functions.forMap(typeFactory, Properties.voidOrRef(safeTypeName));
        return (Property)((Function)propertyLookup.apply((Object)safeTypeName.toLowerCase())).apply((Object)safeTypeName);
    }

    public static Property property(ModelReference modelRef) {
        if (modelRef.isMap()) {
            return new MapProperty(Properties.property((ModelReference)modelRef.itemModel().get()));
        }
        if (modelRef.isCollection()) {
            return new ArrayProperty(EnumMapper.maybeAddAllowableValues(Properties.itemTypeProperty((ModelReference)modelRef.itemModel().get()), modelRef.getAllowableValues()));
        }
        return Properties.property(modelRef.getType());
    }

    public static Property itemTypeProperty(ModelReference paramModel) {
        if (paramModel.isCollection()) {
            return new ArrayProperty(EnumMapper.maybeAddAllowableValues(Properties.itemTypeProperty((ModelReference)paramModel.itemModel().get()), paramModel.getAllowableValues()));
        }
        return Properties.property(paramModel.getType());
    }

    private static <T extends Property> Function<String, T> newInstanceOf(final Class<T> clazz) {
        return new Function<String, T>(){

            public T apply(String input) {
                try {
                    return (Property)clazz.newInstance();
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
        };
    }

    static Ordering<String> defaultOrdering(Map<String, ModelProperty> properties) {
        return Ordering.from(Properties.byPosition(properties)).compound(Properties.byName());
    }

    private static Function<String, ? extends Property> voidOrRef(final String typeName) {
        return new Function<String, Property>(){

            public Property apply(String input) {
                if (typeName.equalsIgnoreCase("void")) {
                    return null;
                }
                return new RefProperty(typeName);
            }
        };
    }

    private static Function<String, ? extends Property> bytePropertyFactory() {
        return new Function<String, Property>(){

            public Property apply(String input) {
                StringProperty byteArray = new StringProperty();
                byteArray.setFormat("byte");
                return byteArray;
            }
        };
    }

    private static Function<String, ? extends Property> filePropertyFactory() {
        return new Function<String, Property>(){

            public Property apply(String input) {
                return new FileProperty();
            }
        };
    }

    private static Comparator<String> byName() {
        return new Comparator<String>(){

            @Override
            public int compare(String first, String second) {
                return first.compareTo(second);
            }
        };
    }

    private static Comparator<String> byPosition(final Map<String, ModelProperty> modelProperties) {
        return new Comparator<String>(){

            @Override
            public int compare(String first, String second) {
                ModelProperty p1 = (ModelProperty)modelProperties.get(first);
                ModelProperty p2 = (ModelProperty)modelProperties.get(second);
                return Ints.compare((int)p1.getPosition(), (int)p2.getPosition());
            }
        };
    }

    static Predicate<Map.Entry<String, ModelProperty>> voidProperties() {
        return new Predicate<Map.Entry<String, ModelProperty>>(){

            public boolean apply(Map.Entry<String, ModelProperty> input) {
                return Types.isVoid((ResolvedType)input.getValue().getType()) || Properties.collectionOfVoid(input.getValue().getType()) || Properties.arrayTypeOfVoid(input.getValue().getType().getArrayElementType());
            }
        };
    }

    private static boolean arrayTypeOfVoid(ResolvedType arrayElementType) {
        return arrayElementType != null && Types.isVoid((ResolvedType)arrayElementType);
    }

    private static boolean collectionOfVoid(ResolvedType type) {
        return Collections.isContainerType((ResolvedType)type) && Types.isVoid((ResolvedType)Collections.collectionElementType((ResolvedType)type));
    }
}

