/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.mappers;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import io.swagger.models.Contact;
import io.swagger.models.Info;
import io.swagger.models.Path;
import io.swagger.models.Response;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.properties.Property;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.ApiDescription;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ApiListing;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.Documentation;
import springfox.documentation.service.Operation;
import springfox.documentation.service.ResponseMessage;
import springfox.documentation.swagger2.mappers.LicenseMapper;
import springfox.documentation.swagger2.mappers.ModelMapper;
import springfox.documentation.swagger2.mappers.ParameterMapper;
import springfox.documentation.swagger2.mappers.SecurityMapper;
import springfox.documentation.swagger2.mappers.VendorExtensionsMapper;

@Mapper(uses={ModelMapper.class, ParameterMapper.class, SecurityMapper.class, LicenseMapper.class, VendorExtensionsMapper.class})
public abstract class ServiceModelToSwagger2Mapper {
    @Mappings(value={@Mapping(target="info", source="resourceListing.info"), @Mapping(target="paths", source="apiListings"), @Mapping(target="host", source="host"), @Mapping(target="schemes", source="schemes"), @Mapping(target="definitions", source="apiListings"), @Mapping(target="securityDefinitions", source="resourceListing"), @Mapping(target="securityRequirement", ignore=true), @Mapping(target="security", ignore=true), @Mapping(target="swagger", ignore=true), @Mapping(target="parameters", ignore=true), @Mapping(target="responses", ignore=true), @Mapping(target="externalDocs", ignore=true), @Mapping(target="vendorExtensions", ignore=true)})
    public abstract Swagger mapDocumentation(Documentation var1);

    @Mappings(value={@Mapping(target="license", source="from", qualifiedBy={LicenseMapper.LicenseTranslator.class, LicenseMapper.License.class}), @Mapping(target="contact", source="from.contact"), @Mapping(target="termsOfService", source="termsOfServiceUrl"), @Mapping(target="vendorExtensions", ignore=true)})
    protected abstract Info mapApiInfo(ApiInfo var1);

    @Mappings(value={@Mapping(target="description", source="notes"), @Mapping(target="operationId", source="uniqueId"), @Mapping(target="schemes", source="protocol"), @Mapping(target="security", source="securityReferences"), @Mapping(target="responses", source="responseMessages"), @Mapping(target="vendorExtensions", source="vendorExtensions"), @Mapping(target="externalDocs", ignore=true)})
    protected abstract io.swagger.models.Operation mapOperation(Operation var1);

    @Mappings(value={@Mapping(target="externalDocs", ignore=true), @Mapping(target="vendorExtensions", ignore=true)})
    protected abstract Tag mapTag(springfox.documentation.service.Tag var1);

    protected List<Scheme> mapSchemes(List<String> from) {
        return FluentIterable.from(from).transform(this.toScheme()).toList();
    }

    protected Contact mapContact(String contact) {
        return new Contact().name(contact);
    }

    protected List<Map<String, List<String>>> mapAuthorizations(Map<String, List<AuthorizationScope>> from) {
        ArrayList security = Lists.newArrayList();
        for (Map.Entry<String, List<AuthorizationScope>> each : from.entrySet()) {
            HashMap newEntry = Maps.newHashMap();
            newEntry.put(each.getKey(), FluentIterable.from((Iterable)each.getValue()).transform(this.scopeToString()).toList());
            security.add(newEntry);
        }
        return security;
    }

    protected Map<String, Response> mapResponseMessages(Set<ResponseMessage> from) {
        HashMap responses = Maps.newHashMap();
        for (ResponseMessage responseMessage : from) {
            ModelReference modelRef = responseMessage.getResponseModel();
            Property responseProperty = ModelMapper.modelRefToProperty(modelRef);
            Response response = new Response().description(responseMessage.getMessage()).schema(responseProperty);
            response.setExamples((Map)Maps.newHashMap());
            response.setHeaders((Map)Maps.newHashMap());
            responses.put(String.valueOf(responseMessage.getCode()), response);
        }
        return responses;
    }

    protected Map<String, Path> mapApiListings(Multimap<String, ApiListing> apiListings) {
        HashMap paths = Maps.newHashMap();
        for (ApiListing each : apiListings.values()) {
            for (ApiDescription api : each.getApis()) {
                paths.put(api.getPath(), this.mapOperations(api, (Optional<Path>)Optional.fromNullable(paths.get(api.getPath()))));
            }
        }
        return paths;
    }

    private Function<AuthorizationScope, String> scopeToString() {
        return new Function<AuthorizationScope, String>(){

            public String apply(AuthorizationScope input) {
                return input.getScope();
            }
        };
    }

    private Path mapOperations(ApiDescription api, Optional<Path> existingPath) {
        Path path = (Path)existingPath.or((Object)new Path());
        for (Operation each : BuilderDefaults.nullToEmptyList((Collection)api.getOperations())) {
            io.swagger.models.Operation operation = this.mapOperation(each);
            path.set(each.getMethod().toString().toLowerCase(), operation);
        }
        return path;
    }

    private Function<String, Scheme> toScheme() {
        return new Function<String, Scheme>(){

            public Scheme apply(String input) {
                return Scheme.forValue((String)input);
            }
        };
    }
}

