/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.mappers;

import io.swagger.models.Contact;
import io.swagger.models.Info;
import io.swagger.models.Path;
import io.swagger.models.Response;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.properties.Property;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.ApiDescription;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ApiListing;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.Documentation;
import springfox.documentation.service.Header;
import springfox.documentation.service.Operation;
import springfox.documentation.service.ResponseMessage;
import springfox.documentation.swagger2.mappers.ExamplesMapper;
import springfox.documentation.swagger2.mappers.LicenseMapper;
import springfox.documentation.swagger2.mappers.ModelMapper;
import springfox.documentation.swagger2.mappers.ParameterMapper;
import springfox.documentation.swagger2.mappers.SecurityMapper;
import springfox.documentation.swagger2.mappers.VendorExtensionsMapper;

@Mapper(uses={ModelMapper.class, ParameterMapper.class, SecurityMapper.class, LicenseMapper.class, VendorExtensionsMapper.class})
public abstract class ServiceModelToSwagger2Mapper {
    @Mappings(value={@Mapping(target="info", source="resourceListing.info"), @Mapping(target="paths", source="apiListings"), @Mapping(target="host", source="host"), @Mapping(target="schemes", source="schemes"), @Mapping(target="definitions", source="apiListings"), @Mapping(target="securityDefinitions", source="resourceListing"), @Mapping(target="securityRequirement", ignore=true), @Mapping(target="security", ignore=true), @Mapping(target="swagger", ignore=true), @Mapping(target="parameters", ignore=true), @Mapping(target="responses", ignore=true), @Mapping(target="externalDocs", ignore=true), @Mapping(target="vendorExtensions", source="vendorExtensions"), @Mapping(target="tag", ignore=true), @Mapping(target="scheme", ignore=true)})
    public abstract Swagger mapDocumentation(Documentation var1);

    @Mappings(value={@Mapping(target="license", source="from", qualifiedBy={LicenseMapper.LicenseTranslator.class, LicenseMapper.License.class}), @Mapping(target="contact", source="from.contact"), @Mapping(target="termsOfService", source="termsOfServiceUrl"), @Mapping(target="vendorExtensions", source="vendorExtensions"), @Mapping(target="mergeWith", ignore=true)})
    protected abstract Info mapApiInfo(ApiInfo var1);

    protected abstract Contact map(springfox.documentation.service.Contact var1);

    @Mappings(value={@Mapping(target="description", source="notes"), @Mapping(target="operationId", source="uniqueId"), @Mapping(target="schemes", source="protocol"), @Mapping(target="security", source="securityReferences"), @Mapping(target="responses", source="responseMessages"), @Mapping(target="vendorExtensions", source="vendorExtensions"), @Mapping(target="externalDocs", ignore=true), @Mapping(target="scheme", ignore=true), @Mapping(target="parameter", ignore=true), @Mapping(target="defaultResponse", ignore=true), @Mapping(target="tag", ignore=true)})
    protected abstract io.swagger.models.Operation mapOperation(Operation var1);

    @Mappings(value={@Mapping(target="externalDocs", ignore=true), @Mapping(target="vendorExtensions", source="vendorExtensions")})
    protected abstract Tag mapTag(springfox.documentation.service.Tag var1);

    protected List<Scheme> mapSchemes(List<String> from) {
        return from.stream().map(Scheme::forValue).collect(Collectors.toList());
    }

    protected List<Map<String, List<String>>> mapAuthorizations(Map<String, List<AuthorizationScope>> from) {
        ArrayList<Map<String, List<String>>> security = new ArrayList<Map<String, List<String>>>();
        for (Map.Entry<String, List<AuthorizationScope>> each : from.entrySet()) {
            HashMap newEntry = new HashMap();
            newEntry.put(each.getKey(), each.getValue().stream().map(AuthorizationScope::getScope).collect(Collectors.toList()));
            security.add(newEntry);
        }
        return security;
    }

    protected Map<String, Response> mapResponseMessages(Set<ResponseMessage> from) {
        TreeMap<String, Response> responses = new TreeMap<String, Response>();
        for (ResponseMessage responseMessage : from) {
            ModelReference modelRef = responseMessage.getResponseModel();
            Property responseProperty = ModelMapper.modelRefToProperty(modelRef);
            Response response = new Response().description(responseMessage.getMessage()).schema(responseProperty);
            Map<String, Object> examples = new ExamplesMapper().mapExamples(responseMessage.getExamples());
            response.setExamples(examples);
            response.setHeaders(responseMessage.getHeaders().entrySet().stream().map(this.toPropertyEntry()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            Map<String, Object> extensions = new VendorExtensionsMapper().mapExtensions(responseMessage.getVendorExtensions());
            response.getVendorExtensions().putAll(extensions);
            responses.put(String.valueOf(responseMessage.getCode()), response);
        }
        return responses;
    }

    private Function<Map.Entry<String, Header>, Map.Entry<String, Property>> toPropertyEntry() {
        return entry -> {
            Property property = ModelMapper.modelRefToProperty(((Header)entry.getValue()).getModelReference());
            property.setDescription(((Header)entry.getValue()).getDescription());
            return new AbstractMap.SimpleEntry(entry.getKey(), property);
        };
    }

    protected Map<String, Path> mapApiListings(Map<String, List<ApiListing>> apiListings) {
        TreeMap<String, Path> paths = new TreeMap<String, Path>();
        apiListings.values().stream().flatMap(Collection::stream).forEachOrdered(each -> {
            for (ApiDescription api : each.getApis()) {
                paths.put(api.getPath(), this.mapOperations(api, Optional.ofNullable(paths.get(api.getPath()))));
            }
        });
        return paths;
    }

    private Path mapOperations(ApiDescription api, Optional<Path> existingPath) {
        Path path = existingPath.orElse(new Path());
        for (Operation each : BuilderDefaults.nullToEmptyList((Collection)api.getOperations())) {
            io.swagger.models.Operation operation = this.mapOperation(each);
            path.set(each.getMethod().toString().toLowerCase(), operation);
        }
        return path;
    }
}

