/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.mappers;

import io.swagger.models.ArrayModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.RefModel;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import org.mapstruct.Mapper;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.Types;
import springfox.documentation.swagger2.mappers.Properties;
import springfox.documentation.swagger2.mappers.SerializableParameterFactories;

@Mapper
public class ParameterMapper {
    public Parameter mapParameter(springfox.documentation.service.Parameter source) {
        Parameter bodyParameter = this.bodyParameter(source);
        return (Parameter)SerializableParameterFactories.create(source).or((Object)bodyParameter);
    }

    private Parameter bodyParameter(springfox.documentation.service.Parameter source) {
        BodyParameter parameter = new BodyParameter().description(source.getDescription()).name(source.getName()).schema(this.fromModelRef(source.getModelRef()));
        parameter.setAccess(source.getParamAccess());
        parameter.setRequired(source.isRequired().booleanValue());
        return parameter;
    }

    Model fromModelRef(ModelRef modelRef) {
        if (modelRef.isCollection()) {
            return new ArrayModel().items(Properties.property(modelRef.getItemType()));
        }
        if (modelRef.isMap()) {
            ModelImpl baseModel = new ModelImpl();
            baseModel.additionalProperties(Properties.property(modelRef.getItemType()));
            return baseModel;
        }
        if (Types.isBaseType((String)modelRef.getType())) {
            ModelImpl baseModel = new ModelImpl();
            baseModel.setType(modelRef.getType());
            return baseModel;
        }
        return new RefModel(modelRef.getType());
    }
}

