package springfox.documentation.swagger2.mappers;

import io.swagger.models.Info;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Documentation;
import springfox.documentation.service.Operation;
import springfox.documentation.service.Parameter;
import springfox.documentation.service.ResourceListing;
import springfox.documentation.service.Tag;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2015-06-24T10:14:30-0500",
    comments = "version: 1.0.0.Beta4, compiler: javac, environment: Java 1.7.0_60 (Oracle Corporation)"
)
@Component
public class ServiceModelToSwagger2MapperImpl extends ServiceModelToSwagger2Mapper {

    @Autowired
    private ModelMapper modelMapper;
    @Autowired
    private ParameterMapper parameterMapper;
    @Autowired
    private SecurityMapper securityMapper;
    @Autowired
    private LicenseMapper licenseMapper;

    @Override
    public Swagger mapDocumentation(Documentation from) {
        if ( from == null ) {
            return null;
        }

        Swagger swagger = new Swagger();

        swagger.setPaths( mapApiListings( from.getApiListings() ) );
        swagger.setSchemes( mapSchemes( from.getSchemes() ) );
        swagger.setDefinitions( modelMapper.modelsFromApiListings( from.getApiListings() ) );
        swagger.setSecurityDefinitions( securityMapper.toSecuritySchemeDefinitions( from.getResourceListing() ) );
        swagger.setInfo( mapApiInfo( fromResourceListingInfo( from ) ) );
        swagger.setTags( tagSetToTagList( from.getTags() ) );
        if ( from.getConsumes() != null ) {
            swagger.setConsumes( new ArrayList<String>( from.getConsumes() ) );
        }
        swagger.setBasePath( from.getBasePath() );
        if ( from.getProduces() != null ) {
            swagger.setProduces( new ArrayList<String>( from.getProduces() ) );
        }

        return swagger;
    }

    @Override
    protected Info mapApiInfo(ApiInfo from) {
        if ( from == null ) {
            return null;
        }

        Info info_ = new Info();

        info_.setTermsOfService( from.getTermsOfServiceUrl() );
        info_.setLicense( licenseMapper.apiInfoToLicense( from ) );
        info_.setContact( mapContact( from.getContact() ) );
        info_.setTitle( from.getTitle() );
        info_.setDescription( from.getDescription() );
        info_.setVersion( from.getVersion() );

        return info_;
    }

    @Override
    protected io.swagger.models.Operation mapOperation(Operation from) {
        if ( from == null ) {
            return null;
        }

        io.swagger.models.Operation operation = new io.swagger.models.Operation();

        operation.setSchemes( stringSetToSchemeList( from.getProtocol() ) );
        operation.setDescription( from.getNotes() );
        operation.setSecurity( mapAuthorizations( from.getSecurityReferences() ) );
        operation.setResponses( mapResponseMessages( from.getResponseMessages() ) );
        operation.setOperationId( from.getUniqueId() );
        operation.setSummary( from.getSummary() );
        if ( from.getTags() != null ) {
            operation.setTags( new ArrayList<String>( from.getTags() ) );
        }
        if ( from.getDeprecated() != null ) {
            operation.setDeprecated( Boolean.parseBoolean( from.getDeprecated() ) );
        }
        if ( from.getConsumes() != null ) {
            operation.setConsumes( new ArrayList<String>( from.getConsumes() ) );
        }
        if ( from.getProduces() != null ) {
            operation.setProduces( new ArrayList<String>( from.getProduces() ) );
        }
        operation.setParameters( parameterListToParameterList( from.getParameters() ) );

        return operation;
    }

    @Override
    protected io.swagger.models.Tag mapTag(Tag from) {
        if ( from == null ) {
            return null;
        }

        io.swagger.models.Tag tag_ = new io.swagger.models.Tag();

        tag_.setDescription( from.getDescription() );
        tag_.setName( from.getName() );

        return tag_;
    }

    private ApiInfo fromResourceListingInfo(Documentation documentation) {

        if ( documentation == null ) {
            return null;
        }
        ResourceListing resourceListing = documentation.getResourceListing();
        if ( resourceListing == null ) {
            return null;
        }
        ApiInfo info = resourceListing.getInfo();
        if ( info == null ) {
            return null;
        }
        return info;
    }

    protected List<io.swagger.models.Tag> tagSetToTagList(Set<Tag> set) {
        if ( set == null ) {
            return null;
        }

        List<io.swagger.models.Tag> list = new ArrayList<io.swagger.models.Tag>();

        for ( Tag tag : set ) {
            list.add( mapTag( tag ) );
        }

        return list;
    }

    protected List<Scheme> stringSetToSchemeList(Set<String> set) {
        if ( set == null ) {
            return null;
        }

        List<Scheme> list = new ArrayList<Scheme>();

        for ( String string : set ) {
            list.add( Enum.valueOf( Scheme.class, string ) );
        }

        return list;
    }

    protected List<io.swagger.models.parameters.Parameter> parameterListToParameterList(List<Parameter> list) {
        if ( list == null ) {
            return null;
        }

        List<io.swagger.models.parameters.Parameter> list_ = new ArrayList<io.swagger.models.parameters.Parameter>();

        for ( Parameter parameter : list ) {
            list_.add( parameterMapper.mapParameter( parameter ) );
        }

        return list_;
    }

}
