/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.mappers;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.wordnik.swagger.models.properties.BooleanProperty;
import com.wordnik.swagger.models.properties.DateProperty;
import com.wordnik.swagger.models.properties.DateTimeProperty;
import com.wordnik.swagger.models.properties.DecimalProperty;
import com.wordnik.swagger.models.properties.DoubleProperty;
import com.wordnik.swagger.models.properties.FloatProperty;
import com.wordnik.swagger.models.properties.IntegerProperty;
import com.wordnik.swagger.models.properties.LongProperty;
import com.wordnik.swagger.models.properties.ObjectProperty;
import com.wordnik.swagger.models.properties.Property;
import com.wordnik.swagger.models.properties.RefProperty;
import com.wordnik.swagger.models.properties.StringProperty;
import com.wordnik.swagger.models.properties.UUIDProperty;
import java.util.Map;

class Properties {
    private static final Map<String, Function<String, ? extends Property>> typeFactory = ImmutableMap.builder().put((Object)"int", Properties.newInstanceOf(IntegerProperty.class)).put((Object)"long", Properties.newInstanceOf(LongProperty.class)).put((Object)"float", Properties.newInstanceOf(FloatProperty.class)).put((Object)"double", Properties.newInstanceOf(DoubleProperty.class)).put((Object)"string", Properties.newInstanceOf(StringProperty.class)).put((Object)"boolean", Properties.newInstanceOf(BooleanProperty.class)).put((Object)"date", Properties.newInstanceOf(DateProperty.class)).put((Object)"date-time", Properties.newInstanceOf(DateTimeProperty.class)).put((Object)"bigdecimal", Properties.newInstanceOf(DecimalProperty.class)).put((Object)"biginteger", Properties.newInstanceOf(DecimalProperty.class)).put((Object)"uuid", Properties.newInstanceOf(UUIDProperty.class)).put((Object)"object", Properties.newInstanceOf(ObjectProperty.class)).put((Object)"byte", Properties.bytePropertyFactory()).build();

    private Properties() {
        throw new UnsupportedOperationException();
    }

    public static Property property(String typeName) {
        String safeTypeName = Strings.nullToEmpty((String)typeName);
        Function propertyLookup = Functions.forMap(typeFactory, Properties.voidOrRef(safeTypeName));
        return (Property)((Function)propertyLookup.apply((Object)safeTypeName.toLowerCase())).apply((Object)safeTypeName);
    }

    private static <T extends Property> Function<String, T> newInstanceOf(final Class<T> clazz) {
        return new Function<String, T>(){

            public T apply(String input) {
                try {
                    return (Property)clazz.newInstance();
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
        };
    }

    private static Function<String, ? extends Property> voidOrRef(final String typeName) {
        return new Function<String, Property>(){

            public Property apply(String input) {
                if (typeName.equalsIgnoreCase("void")) {
                    return null;
                }
                return new RefProperty(typeName);
            }
        };
    }

    private static Function<String, ? extends Property> bytePropertyFactory() {
        return new Function<String, Property>(){

            public Property apply(String input) {
                StringProperty byteArray = new StringProperty();
                byteArray.setFormat("byte");
                return byteArray;
            }
        };
    }
}

