/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.readers.operation;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ResponseHeader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.schema.Types;

public class ResponseHeaders {
    private ResponseHeaders() {
        throw new UnsupportedOperationException();
    }

    public static Function<ApiOperation, ResponseHeader[]> resposeHeaders() {
        return new Function<ApiOperation, ResponseHeader[]>(){

            public ResponseHeader[] apply(ApiOperation input) {
                return input.responseHeaders();
            }
        };
    }

    public static Map<String, ModelReference> headers(ResponseHeader[] responseHeaders) {
        HashMap headers = Maps.newHashMap();
        for (ResponseHeader each : FluentIterable.from((Iterable)Lists.newArrayList((Object[])responseHeaders)).filter(Predicates.not(ResponseHeaders.emptyOrVoid()))) {
            headers.put(each.name(), ResponseHeaders.headerModel(each));
        }
        return headers;
    }

    private static Predicate<ResponseHeader> emptyOrVoid() {
        return new Predicate<ResponseHeader>(){

            public boolean apply(ResponseHeader input) {
                return Strings.isNullOrEmpty((String)input.name()) || Void.class.equals((Object)input.response());
            }
        };
    }

    private static ModelReference headerModel(ResponseHeader each) {
        String typeName = (String)Optional.fromNullable((Object)Types.typeNameFor((Type)each.response())).or((Object)"string");
        ModelRef modelReference = Strings.isNullOrEmpty((String)each.responseContainer()) ? new ModelRef(typeName) : new ModelRef(each.responseContainer(), (ModelReference)new ModelRef(typeName));
        return modelReference;
    }
}

