/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.web;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;
import springfox.documentation.spring.web.DocumentationCache;
import springfox.documentation.swagger.web.SecurityConfiguration;
import springfox.documentation.swagger.web.SwaggerResource;
import springfox.documentation.swagger.web.UiConfiguration;

@Controller
@ApiIgnore
public class ApiResourceController {
    @Value(value="${springfox.documentation.swagger.v1.path:/api-docs}")
    private String swagger1Url;
    @Value(value="${springfox.documentation.swagger.v2.path:/v2/api-docs}")
    private String swagger2Url;
    @Autowired
    private DocumentationCache documentationCache;
    @Autowired(required=false)
    private SecurityConfiguration securityConfiguration;
    @Autowired(required=false)
    private UiConfiguration uiConfiguration;
    private boolean swagger1Available = this.classByName("springfox.documentation.swagger1.web.Swagger1Controller").isPresent();
    private boolean swagger2Available = this.classByName("springfox.documentation.swagger2.web.Swagger2Controller").isPresent();

    @RequestMapping(value={"/configuration/security"})
    @ResponseBody
    ResponseEntity<SecurityConfiguration> securityConfiguration() {
        return new ResponseEntity(Optional.fromNullable((Object)this.securityConfiguration).or((Object)SecurityConfiguration.DEFAULT), HttpStatus.OK);
    }

    @RequestMapping(value={"/configuration/ui"})
    @ResponseBody
    ResponseEntity<UiConfiguration> uiConfiguration() {
        return new ResponseEntity(Optional.fromNullable((Object)this.uiConfiguration).or((Object)UiConfiguration.DEFAULT), HttpStatus.OK);
    }

    @RequestMapping(value={"/swagger-resources"})
    @ResponseBody
    ResponseEntity<List<SwaggerResource>> swaggerResources() {
        ArrayList<SwaggerResource> resources = new ArrayList<SwaggerResource>();
        for (Map.Entry entry : this.documentationCache.all().entrySet()) {
            SwaggerResource swaggerResource;
            String swaggerGroup = (String)entry.getKey();
            if (this.swagger1Available) {
                swaggerResource = this.resource(swaggerGroup, this.swagger1Url);
                swaggerResource.setSwaggerVersion("1.2");
                resources.add(swaggerResource);
            }
            if (!this.swagger2Available) continue;
            swaggerResource = this.resource(swaggerGroup, this.swagger2Url);
            swaggerResource.setSwaggerVersion("2.0");
            resources.add(swaggerResource);
        }
        Collections.sort(resources);
        return new ResponseEntity(resources, HttpStatus.OK);
    }

    private SwaggerResource resource(String swaggerGroup, String baseUrl) {
        SwaggerResource swaggerResource = new SwaggerResource();
        swaggerResource.setName(swaggerGroup);
        swaggerResource.setLocation(this.swaggerLocation(baseUrl, swaggerGroup));
        return swaggerResource;
    }

    private String swaggerLocation(String swaggerUrl, String swaggerGroup) {
        String base = (String)Optional.of((Object)swaggerUrl).get();
        if ("default".equals(swaggerGroup)) {
            return base;
        }
        return base + "?group=" + swaggerGroup;
    }

    private Optional<? extends Class> classByName(String className) {
        try {
            return Optional.of(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            return Optional.absent();
        }
    }
}

