/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.readers.operation;

import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import springfox.documentation.builders.ResponseMessageBuilder;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.service.ResponseMessage;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.AlternateTypeProvider;
import springfox.documentation.spi.schema.GenericTypeNamingStrategy;
import springfox.documentation.spi.schema.contexts.ModelContext;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.swagger.annotations.Annotations;
import springfox.documentation.swagger.common.SwaggerPluginSupport;

@Component
@Order(value=-2147482648)
public class SwaggerResponseMessageReader
implements OperationBuilderPlugin {
    private TypeNameExtractor typeNameExtractor;

    @Autowired
    public SwaggerResponseMessageReader(TypeNameExtractor typeNameExtractor) {
        this.typeNameExtractor = typeNameExtractor;
    }

    public void apply(OperationContext context) {
        HandlerMethod handlerMethod = context.getHandlerMethod();
        context.operationBuilder().responseMessages(this.read(handlerMethod, context));
    }

    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply(delimiter);
    }

    protected Set<ResponseMessage> read(HandlerMethod handlerMethod, OperationContext context) {
        Optional<ApiResponses> apiResponsesOptional = Annotations.findApiResponsesAnnotations(handlerMethod.getMethod());
        HashSet responseMessages = Sets.newHashSet();
        if (apiResponsesOptional.isPresent()) {
            ApiResponse[] apiResponseAnnotations;
            for (ApiResponse apiResponse : apiResponseAnnotations = ((ApiResponses)apiResponsesOptional.get()).value()) {
                String overrideTypeName = this.overrideTypeName(apiResponse, context);
                responseMessages.add(new ResponseMessageBuilder().code(apiResponse.code()).message(apiResponse.message()).responseModel(new ModelRef(overrideTypeName)).build());
            }
        }
        return responseMessages;
    }

    private String overrideTypeName(ApiResponse apiResponse, OperationContext context) {
        if (apiResponse.response() != null) {
            ModelContext modelContext = ModelContext.returnValue((Type)apiResponse.response(), (DocumentationType)context.getDocumentationType(), (AlternateTypeProvider)context.getAlternateTypeProvider(), (GenericTypeNamingStrategy)context.getDocumentationContext().getGenericsNamingStrategy());
            return this.typeNameExtractor.typeName(modelContext);
        }
        return "";
    }
}

