/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.readers.operation;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.Authorization;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.method.HandlerMethod;
import springfox.documentation.builders.AuthorizationScopeBuilder;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.swagger.common.SwaggerPluginSupport;

@Component
@Order(value=-2147482648)
public class OperationAuthReader
implements OperationBuilderPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(OperationAuthReader.class);

    public void apply(OperationContext context) {
        Authorization[] authorizationAnnotations;
        ApiOperation apiOperationAnnotation;
        Optional securityContext = context.securityContext();
        HandlerMethod handlerMethod = context.getHandlerMethod();
        String requestMappingPattern = context.requestMappingPattern();
        List<SecurityReference> securityReferences = Lists.newArrayList();
        if (securityContext.isPresent()) {
            securityReferences = ((SecurityContext)securityContext.get()).securityForPath(requestMappingPattern);
        }
        if (null != (apiOperationAnnotation = (ApiOperation)handlerMethod.getMethodAnnotation(ApiOperation.class)) && null != apiOperationAnnotation.authorizations() && (authorizationAnnotations = apiOperationAnnotation.authorizations()) != null && authorizationAnnotations.length > 0 && StringUtils.hasText((String)authorizationAnnotations[0].value())) {
            securityReferences = Lists.newArrayList();
            for (Authorization authorization : authorizationAnnotations) {
                String value = authorization.value();
                com.wordnik.swagger.annotations.AuthorizationScope[] scopes = authorization.scopes();
                ArrayList authorizationScopeList = Lists.newArrayList();
                for (com.wordnik.swagger.annotations.AuthorizationScope authorizationScope : scopes) {
                    String description = authorizationScope.description();
                    String scope = authorizationScope.scope();
                    if (Strings.isNullOrEmpty((String)scope)) continue;
                    authorizationScopeList.add(new AuthorizationScopeBuilder().scope(scope).description(description).build());
                }
                AuthorizationScope[] authorizationScopes = authorizationScopeList.toArray(new AuthorizationScope[authorizationScopeList.size()]);
                SecurityReference securityReference = SecurityReference.builder().reference(value).scopes(authorizationScopes).build();
                securityReferences.add(securityReference);
            }
        }
        if (securityReferences != null) {
            LOG.debug("Authorization count {} for method {}", (Object)securityReferences.size(), (Object)handlerMethod.getMethod().getName());
            context.operationBuilder().authorizations(securityReferences);
        }
    }

    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply(delimiter);
    }
}

