/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.scanners;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import springfox.documentation.PathProvider;
import springfox.documentation.builders.ApiDescriptionBuilder;
import springfox.documentation.service.ApiDescription;
import springfox.documentation.spi.service.contexts.ApiSelector;
import springfox.documentation.spi.service.contexts.RequestMappingContext;
import springfox.documentation.spring.web.Paths;
import springfox.documentation.spring.web.readers.operation.ApiOperationReader;
import springfox.documentation.spring.web.scanners.PathMappingAdjuster;

@Component
public class ApiDescriptionReader {
    private final ApiOperationReader operationReader;

    @Autowired
    public ApiDescriptionReader(ApiOperationReader operationReader) {
        this.operationReader = operationReader;
    }

    public List<ApiDescription> read(RequestMappingContext outerContext) {
        RequestMappingInfo requestMappingInfo = outerContext.getRequestMappingInfo();
        HandlerMethod handlerMethod = outerContext.getHandlerMethod();
        PatternsRequestCondition patternsCondition = requestMappingInfo.getPatternsCondition();
        ApiSelector selector = outerContext.getDocumentationContext().getApiSelector();
        PathProvider pathProvider = outerContext.getDocumentationContext().getPathProvider();
        ArrayList apiDescriptionList = Lists.newArrayList();
        for (String pattern : this.matchingPaths(selector, patternsCondition)) {
            String cleanedRequestMappingPath = Paths.sanitizeRequestMappingPattern(pattern);
            String path = pathProvider.getOperationPath(cleanedRequestMappingPath);
            String methodName = handlerMethod.getMethod().getName();
            RequestMappingContext operationContext = outerContext.copyPatternUsing(cleanedRequestMappingPath);
            PathMappingAdjuster adjuster = new PathMappingAdjuster(operationContext.getDocumentationContext());
            apiDescriptionList.add(new ApiDescriptionBuilder(outerContext.operationOrdering()).path(adjuster.adjustedPath(path)).description(methodName).operations(this.operationReader.read(operationContext)).hidden(false).build());
        }
        return apiDescriptionList;
    }

    private FluentIterable<String> matchingPaths(ApiSelector selector, PatternsRequestCondition patternsCondition) {
        return FluentIterable.from((Iterable)patternsCondition.getPatterns()).filter(selector.getPathSelector());
    }
}

